/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.IAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class ProofTermGenerator
extends NonRecursive {
    private final Deque<Term> mConverted = new ArrayDeque<Term>();
    private final Map<Clause, Term> mNodes = new HashMap<Clause, Term>();
    ProofRules mProofRules;

    public ProofTermGenerator(ProofRules proofRules) {
        this.mProofRules = proofRules;
    }

    public Theory getTheory() {
        return this.mProofRules.getTheory();
    }

    Term getTerm(Clause clause) {
        return this.mNodes.get(clause);
    }

    Term getConverted() {
        return this.mConverted.pop();
    }

    void pushConverted(Term term) {
        assert (ProofRules.isProof(term));
        this.mConverted.push(term);
    }

    void setResult(Clause clause, Term term) {
        this.mNodes.put(clause, term);
    }

    public Term convert(Clause clause) {
        assert (clause.getProof() != null);
        this.run(new Expander(clause));
        Term term = this.mConverted.pop();
        return term;
    }

    private static class Expander
    implements NonRecursive.Walker {
        private final Clause mCls;

        public Expander(Clause clause) {
            this.mCls = clause;
        }

        public void walk(NonRecursive nonRecursive) {
            ProofTermGenerator proofTermGenerator = (ProofTermGenerator)nonRecursive;
            Term term = proofTermGenerator.getTerm(this.mCls);
            if (term != null) {
                proofTermGenerator.pushConverted(term);
                return;
            }
            ProofNode proofNode = this.mCls.getProof();
            if (proofNode.isLeaf()) {
                Term term2;
                LeafNode leafNode = (LeafNode)proofNode;
                Theory theory = proofTermGenerator.getTheory();
                IAnnotation iAnnotation = leafNode.getTheoryAnnotation();
                if (iAnnotation == null) {
                    assert (leafNode.getLeafKind() == -7);
                    term2 = proofTermGenerator.mProofRules.asserted(this.mCls.toTerm(theory));
                } else {
                    term2 = iAnnotation.toTerm(this.mCls, proofTermGenerator.mProofRules);
                }
                proofTermGenerator.setResult(this.mCls, term2);
                proofTermGenerator.pushConverted(term2);
            } else {
                ResolutionNode.Antecedent[] antecedentArray;
                ResolutionNode resolutionNode = (ResolutionNode)proofNode;
                proofTermGenerator.enqueueWalker(new GenerateTerm(this.mCls));
                proofTermGenerator.enqueueWalker(new Expander(resolutionNode.getPrimary()));
                ResolutionNode.Antecedent[] antecedentArray2 = antecedentArray = resolutionNode.getAntecedents();
                int n = antecedentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ResolutionNode.Antecedent antecedent = antecedentArray2[n2];
                    proofTermGenerator.enqueueWalker(new Expander(antecedent.mAntecedent));
                    ++n2;
                }
            }
        }
    }

    private static class GenerateTerm
    implements NonRecursive.Walker {
        private final Clause mCls;

        public GenerateTerm(Clause clause) {
            assert (clause.getProof() instanceof ResolutionNode);
            this.mCls = clause;
        }

        public void walk(NonRecursive nonRecursive) {
            Annotation[] annotationArray;
            ProofTermGenerator proofTermGenerator = (ProofTermGenerator)nonRecursive;
            Theory theory = proofTermGenerator.getTheory();
            ResolutionNode.Antecedent[] antecedentArray = ((ResolutionNode)this.mCls.getProof()).getAntecedents();
            Term term = proofTermGenerator.getConverted();
            int n = 0;
            while (n < antecedentArray.length) {
                annotationArray = antecedentArray[n].mPivot;
                Term term2 = proofTermGenerator.getConverted();
                boolean bl = annotationArray.getSign() > 0;
                term = proofTermGenerator.mProofRules.resolutionRule(annotationArray.getAtom().getSMTFormula(theory), bl ? term2 : term, bl ? term : term2);
                ++n;
            }
            Object[] objectArray = ProofRules.convertProofLiteralsToAnnotation(this.mCls.toProofLiterals(proofTermGenerator.mProofRules));
            annotationArray = new Annotation[]{new Annotation(":proves", (Object)objectArray), new Annotation(":rup", null)};
            term = theory.annotatedTerm(annotationArray, term);
            proofTermGenerator.setResult(this.mCls, term);
            proofTermGenerator.pushConverted(term);
        }
    }
}

