/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.util.LazyInt;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.ILattice;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import java.util.AbstractCollection;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public final class BitSubSet<E>
extends AbstractCollection<E> {
    private final Factory<E> mFactory;
    private final BitSet mBitSet;
    private final LazyInt mHash;

    private BitSubSet(Factory<E> factory, BitSet bitSet) {
        this.mFactory = factory;
        this.mBitSet = bitSet;
        this.mHash = new LazyInt(this.mBitSet::hashCode);
    }

    @Override
    public boolean contains(Object object) {
        Integer n = this.mFactory.getIndex(object);
        return n != null && this.mBitSet.get(n);
    }

    @Override
    public boolean containsAll(BitSubSet<?> bitSubSet) {
        assert (bitSubSet.mFactory == this.mFactory) : "Cannot compare sets from different universes";
        BitSet bitSet = BitSet.valueOf(bitSubSet.mBitSet.toLongArray());
        bitSet.andNot(this.mBitSet);
        return bitSet.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new BitSubSetIterator(this.mFactory.mElements, this.mBitSet);
    }

    @Override
    public int size() {
        return this.mBitSet.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.mBitSet.isEmpty();
    }

    @Override
    public int hashCode() {
        return this.mHash.get();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BitSubSet) {
            BitSubSet bitSubSet = (BitSubSet)object;
            if (bitSubSet.mFactory == this.mFactory) {
                return bitSubSet.mBitSet.equals(this.mBitSet);
            }
        }
        return super.equals(object);
    }

    private static class BitSubSetIterator<E>
    implements Iterator<E> {
        private final Object[] mElements;
        private final BitSet mBitSet;
        private int mIndex;

        public BitSubSetIterator(Object[] objectArray, BitSet bitSet) {
            this.mElements = objectArray;
            this.mBitSet = bitSet;
            this.mIndex = this.mBitSet.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.mIndex >= 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this.mElements[this.mIndex];
            this.mIndex = this.mBitSet.nextSetBit(this.mIndex + 1);
            return (E)object;
        }
    }

    public static class Factory<E>
    implements ILattice<BitSubSet<E>> {
        private static final String LEFT_NOT_CREATED_BY_FACTORY = "Operand 'left' not created by this factory";
        private static final String RIGHT_NOT_CREATED_BY_FACTORY = "Operand 'right' not created by this factory";
        private final Object[] mElements;
        private final Map<E, Integer> mIndexMap;
        private BitSubSet<E> mUniverse;
        private BitSubSet<E> mEmpty;

        public Factory(Set<E> set) {
            this.mElements = set.stream().sorted(Comparator.comparing(Objects::hashCode)).toArray();
            this.mIndexMap = new HashMap<E, Integer>(set.size());
            int n = 0;
            while (n < this.mElements.length) {
                this.mIndexMap.put(this.mElements[n], n);
                ++n;
            }
        }

        public BitSubSet<E> valueOf(Set<E> set) {
            BitSet bitSet = new BitSet(this.mElements.length);
            for (E e : set) {
                int n = this.getIndex(e);
                bitSet.set(n);
            }
            return new BitSubSet(this, bitSet);
        }

        public BitSubSet<E> universe() {
            if (this.mUniverse == null) {
                BitSet bitSet = new BitSet(this.mElements.length);
                this.flip(bitSet);
                this.mUniverse = new BitSubSet(this, bitSet);
            }
            return this.mUniverse;
        }

        public BitSubSet<E> empty() {
            if (this.mEmpty == null) {
                this.mEmpty = new BitSubSet(this, new BitSet());
            }
            return this.mEmpty;
        }

        public BitSubSet<E> complement(BitSubSet<E> bitSubSet) {
            assert (bitSubSet.mFactory == this) : "operand not created by this factory";
            BitSet bitSet = Factory.copy(bitSubSet.mBitSet);
            this.flip(bitSet);
            return new BitSubSet(this, bitSet);
        }

        public BitSubSet<E> union(BitSubSet<E> bitSubSet, BitSubSet<E> bitSubSet2) {
            assert (bitSubSet.mFactory == this) : "Operand 'left' not created by this factory";
            assert (bitSubSet2.mFactory == this) : "Operand 'right' not created by this factory";
            if (bitSubSet == bitSubSet2) {
                return bitSubSet;
            }
            if (bitSubSet2.isEmpty()) {
                return bitSubSet;
            }
            if (bitSubSet.isEmpty()) {
                return bitSubSet2;
            }
            BitSet bitSet = Factory.copy(bitSubSet.mBitSet);
            bitSet.or(bitSubSet2.mBitSet);
            return new BitSubSet(this, bitSet);
        }

        public BitSubSet<E> intersection(BitSubSet<E> bitSubSet, BitSubSet<E> bitSubSet2) {
            assert (bitSubSet.mFactory == this) : "Operand 'left' not created by this factory";
            assert (bitSubSet2.mFactory == this) : "Operand 'right' not created by this factory";
            if (bitSubSet == bitSubSet2) {
                return bitSubSet;
            }
            if (bitSubSet2.isEmpty()) {
                return this.empty();
            }
            if (bitSubSet.isEmpty()) {
                return this.empty();
            }
            BitSet bitSet = Factory.copy(bitSubSet.mBitSet);
            bitSet.and(bitSubSet2.mBitSet);
            return new BitSubSet(this, bitSet);
        }

        public BitSubSet<E> difference(BitSubSet<E> bitSubSet, BitSubSet<E> bitSubSet2) {
            assert (bitSubSet.mFactory == this) : "Operand 'left' not created by this factory";
            assert (bitSubSet2.mFactory == this) : "Operand 'right' not created by this factory";
            if (bitSubSet.isEmpty() || bitSubSet2.isEmpty()) {
                return bitSubSet;
            }
            BitSet bitSet = Factory.copy(bitSubSet.mBitSet);
            bitSet.andNot(bitSubSet2.mBitSet);
            return new BitSubSet(this, bitSet);
        }

        private void flip(BitSet bitSet) {
            if (this.mElements.length == 0) {
                return;
            }
            bitSet.flip(0, this.mElements.length);
        }

        private static BitSet copy(BitSet bitSet) {
            return (BitSet)bitSet.clone();
        }

        private final Integer getIndex(Object object) {
            return this.mIndexMap.get(object);
        }

        @Override
        public IPartialComparator.ComparisonResult compare(BitSubSet<E> bitSubSet, BitSubSet<E> bitSubSet2) {
            assert (bitSubSet.mFactory == this && bitSubSet2.mFactory == this) : "operand not created by this factory";
            if (bitSubSet.equals(bitSubSet2)) {
                return IPartialComparator.ComparisonResult.EQUAL;
            }
            if (bitSubSet2.containsAll(bitSubSet)) {
                return IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
            }
            if (bitSubSet.containsAll(bitSubSet2)) {
                return IPartialComparator.ComparisonResult.STRICTLY_GREATER;
            }
            return IPartialComparator.ComparisonResult.INCOMPARABLE;
        }

        @Override
        public BitSubSet<E> getBottom() {
            return this.empty();
        }

        @Override
        public BitSubSet<E> getTop() {
            return this.universe();
        }

        @Override
        public BitSubSet<E> supremum(BitSubSet<E> bitSubSet, BitSubSet<E> bitSubSet2) {
            return this.union(bitSubSet, bitSubSet2);
        }

        @Override
        public BitSubSet<E> infimum(BitSubSet<E> bitSubSet, BitSubSet<E> bitSubSet2) {
            return this.intersection(bitSubSet, bitSubSet2);
        }
    }
}

