/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.SimultaneousUpdate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Monomial;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LinearUpdate {
    Map<TermVariable, AffineTerm> mUpdateMap;
    Set<Term> mReadonlyVariables;

    public LinearUpdate(Map<TermVariable, AffineTerm> map, Set<Term> set) {
        this.mUpdateMap = map;
        this.mReadonlyVariables = set;
    }

    public Map<TermVariable, AffineTerm> getUpdateMap() {
        return this.mUpdateMap;
    }

    public Set<Term> getReadonlyVariables() {
        return this.mReadonlyVariables;
    }

    public static Pair<LinearUpdate, String> fromSimultaneousUpdate(ManagedScript managedScript, SimultaneousUpdate simultaneousUpdate) {
        Object object;
        Object object2;
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        for (Map.Entry object42 : simultaneousUpdate.getDeterministicAssignment().entrySet()) {
            hashSet.add(((IProgramVar)object42.getKey()).getTermVariable());
        }
        for (IProgramVar iProgramVar : simultaneousUpdate.getHavocedVars()) {
            hashSet.add(iProgramVar.getTermVariable());
        }
        HashSet<Term> hashSet2 = new HashSet<Term>();
        HashMap hashMap = new HashMap();
        ArrayList<MultiDimensionalSelect> arrayList = new ArrayList<MultiDimensionalSelect>();
        for (Map.Entry entry : simultaneousUpdate.getDeterministicAssignment().entrySet()) {
            UpdateExpression updateExpression = LinearUpdate.extractLinearUpdate(managedScript, hashSet, (Term)entry.getValue());
            if (updateExpression.getmErrorMessage() != null) {
                return new Pair(null, (Object)updateExpression.getmErrorMessage());
            }
            Iterator iterator = new ArrayList();
            for (MultiDimensionalSelect multiDimensionalSelect : updateExpression.getmArrayReads()) {
                if (!LinearUpdate.isMoving(multiDimensionalSelect.getIndex(), hashSet)) continue;
                object2 = hashSet.contains(multiDimensionalSelect.getArray()) ? String.format("Array read from modified array %s at modified index %s.", multiDimensionalSelect.getArray(), multiDimensionalSelect.getIndex()) : String.format("Array read from non-modified array %s at modified index %s.", multiDimensionalSelect.getArray(), multiDimensionalSelect.getIndex());
                iterator.add((Object)object2);
            }
            if (!iterator.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                if (Arrays.asList(((Term)entry.getValue()).getFreeVars()).contains(((IProgramVar)entry.getKey()).getTermVariable())) {
                    stringBuilder.append("Forever unsupported. ");
                    stringBuilder.append(String.format("Update of scalar variable %s contains this variable and %s array reads whose index is modified. ", entry.getKey(), iterator.size()));
                } else {
                    stringBuilder.append(String.format("Update of scalar variable %s contains %s array reads whose index is modified. ", entry.getKey(), iterator.size()));
                }
                stringBuilder.append(iterator);
                stringBuilder.append(" Modified variables: ");
                stringBuilder.append(hashSet);
                object = stringBuilder.toString();
                throw new AssertionError(object);
            }
            hashMap.put(((IProgramVar)entry.getKey()).getTermVariable(), updateExpression.getmAffineTerm());
            hashSet2.addAll(updateExpression.getmReadonlyVariables());
            arrayList.addAll(updateExpression.getmArrayReads());
        }
        boolean bl = false;
        ArrayList arrayList2 = new ArrayList();
        for (Map.Entry entry : simultaneousUpdate.getDeterministicArrayWrites().entrySet()) {
            MultiDimensionalNestedStore multiDimensionalNestedStore = (MultiDimensionalNestedStore)entry.getValue();
            int n = 0;
            while (n < multiDimensionalNestedStore.getIndices().size()) {
                boolean bl2 = LinearUpdate.isMoving((ArrayIndex)multiDimensionalNestedStore.getIndices().get(n), hashSet);
                bl |= !bl2;
                if (LinearUpdate.isNondeterministicUpdate(n, multiDimensionalNestedStore, ((IProgramVar)entry.getKey()).getTermVariable())) {
                    if (bl2) {
                        arrayList2.add(String.format("Nondeterministic update of %s at moving index %s", multiDimensionalNestedStore.getArray(), multiDimensionalNestedStore.getIndices().get(n)));
                    } else {
                        arrayList2.add(String.format("Nondeterministic update of %s at fixed index %s", multiDimensionalNestedStore.getArray(), multiDimensionalNestedStore.getIndices().get(n)));
                    }
                } else {
                    UpdateExpression updateExpression = LinearUpdate.extractLinearUpdate(managedScript, hashSet, (Term)multiDimensionalNestedStore.getValues().get(n));
                    if (updateExpression.getmErrorMessage() != null) {
                        throw new AssertionError((Object)updateExpression.getmErrorMessage());
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Deterministic update of ");
                    stringBuilder.append(multiDimensionalNestedStore.getArray());
                    stringBuilder.append(" at ");
                    stringBuilder.append(bl2 ? "moving" : "fixed");
                    stringBuilder.append(" index ");
                    stringBuilder.append(multiDimensionalNestedStore.getIndices().get(n));
                    stringBuilder.append(" with");
                    if (updateExpression.getmAffineTerm().getVariable2Coefficient().isEmpty()) {
                        stringBuilder.append(" constant value ");
                    } else {
                        stringBuilder.append(" value ");
                    }
                    stringBuilder.append(updateExpression.getmAffineTerm());
                    stringBuilder.append(". ");
                    for (MultiDimensionalSelect multiDimensionalSelect : updateExpression.getmArrayReads()) {
                        stringBuilder.append(" Update contains array read at ");
                        boolean bl3 = LinearUpdate.isMoving(multiDimensionalSelect.getIndex(), hashSet);
                        stringBuilder.append(bl3 ? "moving" : "fixed");
                        stringBuilder.append(" index ");
                        stringBuilder.append(multiDimensionalSelect.getIndex());
                        stringBuilder.append(". ");
                    }
                    arrayList2.add(stringBuilder.toString());
                }
                ++n;
            }
            for (MultiDimensionalSelect multiDimensionalSelect : arrayList) {
                if (!multiDimensionalSelect.getArray().equals(((IProgramVar)entry.getKey()).getTermVariable())) continue;
                String string = String.format("Acceleration would only be sound under the assumption that index %s is different each index in %s", multiDimensionalSelect.getIndex(), ((MultiDimensionalNestedStore)entry.getValue()).getIndices());
                return new Pair(null, (Object)string);
            }
        }
        if (bl) {
            throw new AssertionError(arrayList2);
        }
        for (Map.Entry entry : simultaneousUpdate.getDeterministicArrayWrites().entrySet()) {
            Set set = ((ArrayIndex)((MultiDimensionalNestedStore)entry.getValue()).getIndices().get(0)).getFreeVars();
            set.retainAll(hashSet);
            if (!set.isEmpty()) continue;
            object = LinearUpdate.extractLinearUpdate(managedScript, hashSet, (Term)((MultiDimensionalNestedStore)entry.getValue()).getValues().get(0));
            if (((UpdateExpression)object).getmErrorMessage() == null) {
                return new Pair(null, (Object)((UpdateExpression)object).getmErrorMessage());
            }
            object2 = ((UpdateExpression)object).getmArrayReads();
            for (Map.Entry entry2 : simultaneousUpdate.getDeterministicArrayWrites().entrySet()) {
                Iterator<MultiDimensionalSelect> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    MultiDimensionalSelect multiDimensionalSelect;
                    multiDimensionalSelect = iterator.next();
                    if (!multiDimensionalSelect.getArray().equals(((IProgramVar)entry2.getKey()).getTermVariable())) continue;
                    String string = String.format("Fixed index update would only be sound under the assumption that index %s and index %s are different. We have %s reads in this update and %s writes in the loop.", ((MultiDimensionalNestedStore)entry2.getValue()).getIndices(), multiDimensionalSelect.getIndex(), arrayList.size(), simultaneousUpdate.getDeterministicArrayWrites().size());
                    return new Pair(null, (Object)string);
                }
            }
            object2 = String.format("Fixed index update on array %s at index %s with value %s.", ((MultiDimensionalNestedStore)entry.getValue()).getArray(), ((MultiDimensionalNestedStore)entry.getValue()).getIndices().get(0), ((MultiDimensionalNestedStore)entry.getValue()).getValues().get(0));
            return new Pair(null, object2);
        }
        return new Pair((Object)new LinearUpdate(hashMap, hashSet2), null);
    }

    private static boolean isNondeterministicUpdate(int n, MultiDimensionalNestedStore multiDimensionalNestedStore, TermVariable termVariable) {
        ArrayIndex arrayIndex = (ArrayIndex)multiDimensionalNestedStore.getIndices().get(n);
        Term term = (Term)multiDimensionalNestedStore.getValues().get(n);
        MultiDimensionalSelect multiDimensionalSelect = MultiDimensionalSelect.of((Term)term);
        return multiDimensionalSelect != null && multiDimensionalSelect.getArray() == termVariable && multiDimensionalSelect.getIndex().equals((Object)arrayIndex);
    }

    private static UpdateExpression extractLinearUpdate(ManagedScript managedScript, Set<TermVariable> set, Term term) {
        IPolynomialTerm iPolynomialTerm = (IPolynomialTerm)new PolynomialTermTransformer(managedScript.getScript()).transform(term);
        HashMap<Term, Rational> hashMap = new HashMap<Term, Rational>();
        HashSet<Term> hashSet = new HashSet<Term>();
        ArrayList<MultiDimensionalSelect> arrayList = new ArrayList<MultiDimensionalSelect>();
        for (Map.Entry affineTerm2 : iPolynomialTerm.getMonomial2Coefficient().entrySet()) {
            Object object;
            Term term2 = ((Monomial)affineTerm2.getKey()).toTerm(managedScript.getScript());
            if (set.contains(term2)) {
                hashMap.put(term2, (Rational)affineTerm2.getValue());
                continue;
            }
            TermVariable termVariable = LinearUpdate.containsTermVariableOfModified(set, term2);
            MultiDimensionalSelect multiDimensionalSelect = MultiDimensionalSelect.of((Term)term2);
            if (multiDimensionalSelect != null) {
                arrayList.add(multiDimensionalSelect);
                hashMap.put(term2, (Rational)affineTerm2.getValue());
                if (termVariable != null) continue;
                hashSet.add(term2);
                continue;
            }
            if (termVariable == null) {
                hashSet.add(term2);
                hashMap.put(term2, (Rational)affineTerm2.getValue());
                object = MultiDimensionalSelect.extractSelectDeep((Term)term);
                if (object.isEmpty()) continue;
                String string = String.format("Yet unsupported: Array read inside variable. Monomial %s", term2);
                return new UpdateExpression(null, null, null, string);
            }
            object = !((Monomial)affineTerm2.getKey()).isLinear() ? String.format("Nonlinear update. Monomial %s, Updated variable %s", term2, termVariable) : String.format("Linear monomial contains modified variable. Monomial %s, Updated variable %s", term2, termVariable);
            return new UpdateExpression(null, null, null, (String)object);
        }
        AffineTerm affineTerm = new AffineTerm(iPolynomialTerm.getSort(), iPolynomialTerm.getConstant(), hashMap);
        return new UpdateExpression(affineTerm, hashSet, arrayList, null);
    }

    private static TermVariable containsTermVariableOfModified(Set<TermVariable> set, Term term) {
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            if (set.contains(termVariable)) {
                return termVariable;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isMoving(ArrayIndex arrayIndex, Set<TermVariable> set) {
        return DataStructureUtils.haveNonEmptyIntersection((Set)arrayIndex.getFreeVars(), set);
    }

    public List<LinearUpdate> partition() {
        UnionFind unionFind = new UnionFind();
        for (Map.Entry<TermVariable, AffineTerm> object2 : this.mUpdateMap.entrySet()) {
            unionFind.findAndConstructEquivalenceClassIfNeeded((Object)((Term)object2.getKey()));
            for (Term term : object2.getValue().getVariable2Coefficient().keySet()) {
                unionFind.findAndConstructEquivalenceClassIfNeeded((Object)term);
                unionFind.union((Object)((Term)object2.getKey()), (Object)term);
            }
        }
        ArrayList<LinearUpdate> arrayList = new ArrayList<LinearUpdate>();
        for (Object object3 : unionFind.getAllEquivalenceClasses()) {
            Object object2;
            Map.Entry<TermVariable, AffineTerm> entry2;
            HashMap hashMap = new HashMap();
            for (Map.Entry<TermVariable, AffineTerm> entry2 : this.mUpdateMap.entrySet()) {
                if (!object3.contains(entry2.getKey())) continue;
                hashMap.put((TermVariable)entry2.getKey(), (AffineTerm)entry2.getValue());
            }
            entry2 = new HashSet();
            for (Object object2 : this.mReadonlyVariables) {
                if (!object3.contains(object2)) continue;
                entry2.add(object2);
            }
            object2 = new LinearUpdate(hashMap, (Set<Term>)((Object)entry2));
            arrayList.add((LinearUpdate)object2);
        }
        return arrayList;
    }

    private static class UpdateExpression {
        private final AffineTerm mAffineTerm;
        private final Set<Term> mReadonlyVariables;
        private final List<MultiDimensionalSelect> mArrayReads;
        private final String mErrorMessage;

        public UpdateExpression(AffineTerm affineTerm, Set<Term> set, List<MultiDimensionalSelect> list, String string) {
            this.mAffineTerm = affineTerm;
            this.mReadonlyVariables = set;
            this.mArrayReads = list;
            this.mErrorMessage = string;
        }

        public AffineTerm getmAffineTerm() {
            return this.mAffineTerm;
        }

        public Set<Term> getmReadonlyVariables() {
            return this.mReadonlyVariables;
        }

        public List<MultiDimensionalSelect> getmArrayReads() {
            return this.mArrayReads;
        }

        public String getmErrorMessage() {
            return this.mErrorMessage;
        }
    }
}

