/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubTermFinder;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class TermVarsFuns {
    private final Term mTerm;
    private final Set<IProgramVar> mVars;
    private final Set<IProgramFunction> mFuns;
    private final Term mClosedTerm;

    public TermVarsFuns(Term term, Set<IProgramVar> set, Set<IProgramFunction> set2, Term term2) {
        this.mTerm = term;
        this.mVars = set;
        this.mFuns = set2;
        this.mClosedTerm = term2;
    }

    public Term getFormula() {
        return this.mTerm;
    }

    public Term getClosedFormula() {
        return this.mClosedTerm;
    }

    public Set<IProgramVar> getVars() {
        return this.mVars;
    }

    public Set<IProgramFunction> getFuns() {
        return this.mFuns;
    }

    public static TermVarsFuns computeTermVarsFuns(Term term, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable) {
        return TermVarsFuns.computeTermVarsProc(term, managedScript, iIcfgSymbolTable::getProgramVar, iIcfgSymbolTable::getProgramFun);
    }

    public static TermVarsFuns computeTermVarsProc(Term term, ManagedScript managedScript, Function<TermVariable, IProgramVar> function, Function<FunctionSymbol, IProgramFunction> function2) {
        Set set;
        TermVariable termVariable;
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        ApplicationTerm applicationTerm2 = term.getFreeVars();
        int n = ((TermVariable[])applicationTerm2).length;
        int n2 = 0;
        while (n2 < n) {
            termVariable = applicationTerm2[n2];
            IProgramVar iProgramVar = function.apply(termVariable);
            if (iProgramVar == null) {
                throw new AssertionError((Object)("No corresponding IProgramVar for " + String.valueOf(termVariable)));
            }
            hashSet.add(iProgramVar);
            ++n2;
        }
        termVariable = TermVarsFuns.findNonTheoryApplicationTerms(term);
        if (termVariable.isEmpty()) {
            set = Collections.emptySet();
        } else {
            HashSet<IProgramFunction> hashSet2 = new HashSet<IProgramFunction>();
            for (ApplicationTerm applicationTerm2 : termVariable) {
                IProgramFunction iProgramFunction = function2.apply(applicationTerm2.getFunction());
                if (iProgramFunction == null) {
                    throw new AssertionError((Object)("No corresponding IProgramFunction for " + String.valueOf(applicationTerm2.getFunction())));
                }
                hashSet2.add(iProgramFunction);
            }
            set = DataStructureUtils.getUnmodifiable(hashSet2);
        }
        Term term2 = PredicateUtils.computeClosedFormula(term, hashSet, managedScript);
        return new TermVarsFuns(term, hashSet, set, term2);
    }

    public static Set<ApplicationTerm> findNonTheoryApplicationTerms(Term term2) {
        Set set;
        Predicate<Term> predicate = term -> term instanceof ApplicationTerm && !((ApplicationTerm)term).getFunction().isIntern();
        Set set2 = set = SubTermFinder.find((Term)term2, predicate, (boolean)false);
        return set2;
    }
}

