/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.concurrency;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.CachingHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.ChainingHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateCoverageChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.UnionPredicateCoverageChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngineResult;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.ILooperCheck;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.IndependenceBuilder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.IndependenceSettings;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.LooperIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.concurrency.IRefinableIndependenceProvider;
import de.uni_freiburg.informatik.ultimate.util.Lazy;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;

class IndependenceProviderForLoopers<L extends IIcfgTransition<?>>
implements IRefinableIndependenceProvider<L> {
    private static final boolean USE_SEPARATE_SCRIPT = false;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final CfgSmtToolkit mCsToolkit;
    private final Lazy<ManagedScript> mIndependenceScript;
    private final IndependenceSettings.IndependenceType mType;
    private Set<IPredicate> mAbstractionLevel;
    private ChainingHoareTripleChecker mHtc;
    private UnionPredicateCoverageChecker mCoverage;

    public IndependenceProviderForLoopers(IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit, Lazy<ManagedScript> lazy, IndependenceSettings.IndependenceType independenceType) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(IndependenceProviderForLoopers.class);
        this.mCsToolkit = cfgSmtToolkit;
        this.mIndependenceScript = lazy;
        this.mType = independenceType;
    }

    @Override
    public void initialize() {
        this.mAbstractionLevel = Collections.emptySet();
        if (this.mType != IndependenceSettings.IndependenceType.SYNTACTIC) {
            this.mHtc = ChainingHoareTripleChecker.empty((ILogger)this.mLogger);
            this.mCoverage = UnionPredicateCoverageChecker.empty();
        }
    }

    @Override
    public void refine(IRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> iRefinementEngineResult) {
        this.mAbstractionLevel = LooperIndependenceRelation.refine(this.mAbstractionLevel, iRefinementEngineResult);
        if (this.mType != IndependenceSettings.IndependenceType.SYNTACTIC) {
            Predicate<IPredicate> predicate = iPredicate -> !iRefinementEngineResult.getPredicateUnifier().isRepresentative(iPredicate);
            this.mHtc = this.mHtc.andThen(this.getHoareTripleChecker(iRefinementEngineResult)).predicatesProtectedBy(predicate);
            this.mCoverage = this.mCoverage.with(iRefinementEngineResult.getPredicateUnifier().getCoverageRelation(), predicate);
        }
    }

    @Override
    public IIndependenceRelation<IPredicate, L> retrieveIndependence() {
        return ((IndependenceBuilder.PredicateActionIndependenceBuilder)IndependenceBuilder.fromPredicateActionIndependence((IIndependenceRelation)new LooperIndependenceRelation(this.mAbstractionLevel, this.constructCheck())).threadSeparated()).build();
    }

    private IHoareTripleChecker getHoareTripleChecker(IRefinementEngineResult<L, ?> iRefinementEngineResult) {
        IHoareTripleChecker iHoareTripleChecker = iRefinementEngineResult.getHoareTripleChecker();
        assert (iHoareTripleChecker != null) : "Refinement must have Hoare triple checker";
        return iHoareTripleChecker;
    }

    private HoareTripleCheckerCache extractCache(IHoareTripleChecker iHoareTripleChecker) {
        if (iHoareTripleChecker instanceof CachingHoareTripleChecker) {
            return ((CachingHoareTripleChecker)iHoareTripleChecker).getCache();
        }
        this.mLogger.warn((Object)"Can not access Hoare triple cache. Additional checks may be costly.");
        return new HoareTripleCheckerCache();
    }

    private ILooperCheck<L> constructCheck() {
        return switch (this.mType) {
            case IndependenceSettings.IndependenceType.SEMANTIC -> new ILooperCheck.HoareLooperCheck((IHoareTripleChecker)this.mHtc, (IPredicateCoverageChecker)this.mCoverage);
            case IndependenceSettings.IndependenceType.SYNTACTIC -> new ILooperCheck.IndependentLooperCheck();
            default -> throw new MatchException(null, null);
        };
    }
}

