/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgSummaryTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.MonolithicHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.FloydHoareValidityCheck;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.IFloydHoareAnnotation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class IcfgFloydHoareValidityCheck<LOC extends IcfgLocation>
extends FloydHoareValidityCheck<LOC> {
    private final IIcfg<LOC> mIcfg;
    private final Set<LOC> mErrorLocs;

    public IcfgFloydHoareValidityCheck(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<LOC> iIcfg, IFloydHoareAnnotation<LOC> iFloydHoareAnnotation, boolean bl) {
        this(iUltimateServiceProvider, iIcfg, iFloydHoareAnnotation, bl, FloydHoareValidityCheck.MissingAnnotationBehaviour.IGNORE, false);
    }

    public IcfgFloydHoareValidityCheck(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<LOC> iIcfg, IFloydHoareAnnotation<LOC> iFloydHoareAnnotation, boolean bl, FloydHoareValidityCheck.MissingAnnotationBehaviour missingAnnotationBehaviour, boolean bl2) {
        this(iUltimateServiceProvider, (IHoareTripleChecker)new MonolithicHoareTripleChecker(iIcfg.getCfgSmtToolkit()), iIcfg, iFloydHoareAnnotation, bl, missingAnnotationBehaviour, bl2);
    }

    public IcfgFloydHoareValidityCheck(IUltimateServiceProvider iUltimateServiceProvider, IHoareTripleChecker iHoareTripleChecker, IIcfg<LOC> iIcfg, IFloydHoareAnnotation<LOC> iFloydHoareAnnotation, boolean bl, FloydHoareValidityCheck.MissingAnnotationBehaviour missingAnnotationBehaviour, boolean bl2) {
        this(iUltimateServiceProvider, iIcfg.getCfgSmtToolkit().getManagedScript(), iHoareTripleChecker, iIcfg, iFloydHoareAnnotation, bl, missingAnnotationBehaviour, bl2);
    }

    public IcfgFloydHoareValidityCheck(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, IHoareTripleChecker iHoareTripleChecker, IIcfg<LOC> iIcfg, IFloydHoareAnnotation<LOC> iFloydHoareAnnotation, boolean bl, FloydHoareValidityCheck.MissingAnnotationBehaviour missingAnnotationBehaviour, boolean bl2) {
        super(iUltimateServiceProvider, managedScript, iHoareTripleChecker, iFloydHoareAnnotation, bl, missingAnnotationBehaviour, bl2);
        this.mIcfg = iIcfg;
        this.mErrorLocs = iIcfg.getProcedureErrorNodes().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (iIcfg.getInitialNodes().isEmpty()) {
            this.mLogger.warn((Object)"There was no procedure with an implementation");
        }
        this.performCheck();
    }

    @Override
    protected Iterable<Pair<IInternalAction, LOC>> getInternalSuccessors(LOC LOC) {
        return this.getSuccessors(LOC, IInternalAction.class, IcfgFloydHoareValidityCheck::isNoTrivialSummary);
    }

    @Override
    protected Iterable<Pair<ICallAction, LOC>> getCallSuccessors(LOC LOC) {
        return this.getSuccessors(LOC, ICallAction.class);
    }

    @Override
    protected Iterable<Triple<IReturnAction, LOC, LOC>> getReturnSuccessors(LOC LOC) {
        return LOC.getOutgoingEdges().stream().filter(IIcfgReturnTransition.class::isInstance).map(icfgEdge -> new Triple((Object)((IReturnAction)icfgEdge), (Object)((IcfgLocation)icfgEdge.getTarget()), (Object)((IIcfgReturnTransition)icfgEdge).getCallerProgramPoint())).collect(Collectors.toList());
    }

    private static boolean isNoTrivialSummary(IInternalAction iInternalAction) {
        return !(iInternalAction instanceof IIcfgSummaryTransition) || !((IIcfgSummaryTransition)iInternalAction).calledProcedureHasImplementation();
    }

    private <A extends IAction> Iterable<Pair<A, LOC>> getSuccessors(LOC LOC, Class<A> clazz) {
        return this.getSuccessors(LOC, clazz, iAction -> true);
    }

    private <A extends IAction> Iterable<Pair<A, LOC>> getSuccessors(LOC LOC, Class<A> clazz, Predicate<A> predicate) {
        return LOC.getOutgoingEdges().stream().filter(clazz::isInstance).map(icfgEdge -> new Pair((Object)((IAction)clazz.cast(icfgEdge)), (Object)((IcfgLocation)icfgEdge.getTarget()))).filter(pair -> predicate.test((IAction)pair.getFirst())).collect(Collectors.toList());
    }
}

