/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ContractStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class Behavior
extends ACSLNode {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(Behavior.class);
    String[] name;
    ContractStatement[] body;

    public Behavior(String[] stringArray, ContractStatement[] contractStatementArray) {
        this.name = stringArray;
        this.body = contractStatementArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Behavior: " + String.valueOf(this);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Behavior").append('[');
        if (this.name == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.name.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.name[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.body == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.body.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.body[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public String[] getName() {
        return this.name;
    }

    public ContractStatement[] getBody() {
        return this.body;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        if (this.body != null) {
            list.addAll(Arrays.asList(this.body));
        }
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (aCSLVisitor.visit(this) && this.body != null) {
            ContractStatement[] contractStatementArray = this.body;
            int n = this.body.length;
            int n2 = 0;
            while (n2 < n) {
                ContractStatement contractStatement = contractStatementArray[n2];
                contractStatement.accept(aCSLVisitor);
                ++n2;
            }
        }
    }

    @Override
    public Behavior accept(ACSLTransformer aCSLTransformer) {
        Behavior behavior = aCSLTransformer.transform(this);
        if (behavior != this) {
            return behavior;
        }
        boolean bl = false;
        ArrayList<ContractStatement> arrayList = new ArrayList<ContractStatement>();
        if (this.body != null) {
            ContractStatement[] contractStatementArray = this.body;
            int n = this.body.length;
            int n2 = 0;
            while (n2 < n) {
                ContractStatement contractStatement = contractStatementArray[n2];
                ContractStatement contractStatement2 = contractStatement.accept(aCSLTransformer);
                bl = bl || contractStatement2 != contractStatement;
                arrayList.add(contractStatement2);
                ++n2;
            }
        }
        if (bl) {
            return new Behavior(this.name, arrayList.toArray(new ContractStatement[0]));
        }
        return this;
    }
}

