/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.TypeDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.FlatSymbolTable;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.AcslTypeUtils;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.SymbolTableValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.ISOIEC9899TC3;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLResultExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.AtLabelExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.CastExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.OldValueExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.BacktranslatedACSLValue;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.CACSL2BoogieBacktranslatorMapping;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BigInterval;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;

public final class Boogie2ACSL {
    private final TypeSizes mTypeSizes;
    private final CACSL2BoogieBacktranslatorMapping mMapping;
    private final FlatSymbolTable mSymbolTable;
    private final Consumer<String> mReporter;

    public Boogie2ACSL(TypeSizes typeSizes, CACSL2BoogieBacktranslatorMapping cACSL2BoogieBacktranslatorMapping, FlatSymbolTable flatSymbolTable, Consumer<String> consumer) {
        this.mTypeSizes = typeSizes;
        this.mMapping = cACSL2BoogieBacktranslatorMapping;
        this.mSymbolTable = flatSymbolTable;
        this.mReporter = consumer;
    }

    public BacktranslatedACSLValue.BacktranslatedExpression translateExpression(de.uni_freiburg.informatik.ultimate.boogie.ast.Expression expression, ILocation iLocation) {
        return this.translateExpression(expression, iLocation, false);
    }

    public BacktranslatedACSLValue.BacktranslatedExpression translateEnsuresExpression(de.uni_freiburg.informatik.ultimate.boogie.ast.Expression expression2, ILocation iLocation, Set<de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression> set) {
        BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression;
        String string = ((IASTFunctionDefinition)((CLocation)iLocation).getNode()).getDeclarator().getName().toString();
        BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression2 = backtranslatedExpression = expression2 == null ? null : this.translateExpression(expression2, iLocation);
        if (backtranslatedExpression == null) {
            CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
            BigInterval bigInterval = BigInterval.booleanRange();
            return this.computeOldVarEqualities(string, set).map(expression -> new BacktranslatedACSLValue.BacktranslatedExpression((Expression)expression, cPrimitive, bigInterval)).orElse(null);
        }
        Optional<Expression> optional = this.computeOldVarEqualities(string, set);
        if (optional.isPresent()) {
            return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.LOGICAND, backtranslatedExpression.expression(), optional.get()), new CPrimitive(CPrimitive.CPrimitives.INT), BigInterval.booleanRange());
        }
        return backtranslatedExpression;
    }

    private Optional<Expression> computeOldVarEqualities(String string2, Set<de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression> set) {
        Set set2 = set.stream().map(de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression::getIdentifier).collect(Collectors.toSet());
        boolean bl = set2.stream().anyMatch(string -> string.startsWith("#memory"));
        return this.mSymbolTable.getGlobalScope().entrySet().stream().flatMap(entry -> this.makeOldVarEquality(string2, (String)entry.getKey(), (SymbolTableValue)entry.getValue(), set2, bl).stream()).reduce((expression, expression2) -> new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.LOGICAND, expression, expression2));
    }

    private Optional<Expression> makeOldVarEquality(String string, String string2, SymbolTableValue symbolTableValue, Set<String> set, boolean bl) {
        boolean bl2 = symbolTableValue.getBoogieDecl() instanceof TypeDeclaration;
        if (bl2) {
            return Optional.empty();
        }
        String string3 = symbolTableValue.getBoogieName();
        if (set.contains(string3)) {
            return Optional.empty();
        }
        if (!this.mMapping.hasVar(string3, symbolTableValue.getDeclarationInformation())) {
            this.mReporter.accept("Unknown variable: " + string3);
            return Optional.empty();
        }
        Triple<String, ICType, Boolean> triple = this.mMapping.getVar(string3, symbolTableValue.getDeclarationInformation());
        boolean bl3 = (Boolean)triple.getThird();
        if (bl3 && bl) {
            this.mReporter.accept("Cannot encode non-modifiability of on-heap variable " + string2 + " by function " + string);
            return Optional.empty();
        }
        IdentifierExpression identifierExpression = new IdentifierExpression(string2);
        return Optional.of(new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.COMPEQ, (Expression)identifierExpression, (Expression)new OldValueExpression((Expression)identifierExpression)));
    }

    private BacktranslatedACSLValue.BacktranslatedExpression translateExpression(de.uni_freiburg.informatik.ultimate.boogie.ast.Expression expression, ILocation iLocation, boolean bl) {
        if (expression == null) {
            this.mReporter.accept("Unknown expressions could not be backtranslated (possibly during translation to Boogie)");
            return null;
        }
        if (expression instanceof UnaryExpression) {
            return this.translateUnaryExpression((UnaryExpression)expression, iLocation, bl);
        }
        if (expression instanceof BinaryExpression) {
            return this.translateBinaryExpression((BinaryExpression)expression, iLocation, bl);
        }
        if (expression instanceof de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression) {
            return this.translateIdentifierExpression((de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression)expression, iLocation);
        }
        if (expression instanceof IntegerLiteral) {
            return this.translateIntegerLiteral(new BigInteger(((IntegerLiteral)expression).getValue()));
        }
        if (expression instanceof BooleanLiteral) {
            return Boogie2ACSL.translateBooleanLiteral((BooleanLiteral)expression);
        }
        if (expression instanceof RealLiteral) {
            return Boogie2ACSL.translateRealLiteral((RealLiteral)expression);
        }
        if (expression instanceof BitvecLiteral) {
            return this.translateBitvecLiteral((BitvecLiteral)expression);
        }
        if (expression instanceof FunctionApplication) {
            return this.translateFunctionApplication((FunctionApplication)expression, iLocation, bl);
        }
        if (expression instanceof ArrayAccessExpression) {
            return this.translateArrayAccess((ArrayAccessExpression)expression, iLocation);
        }
        this.mReporter.accept("Expression type not yet supported in backtranslation: " + expression.getClass().getSimpleName());
        return null;
    }

    private BacktranslatedACSLValue.BacktranslatedExpression translateIdentifierExpression(de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression identifierExpression, ILocation iLocation) {
        String string = identifierExpression.getIdentifier();
        if (string.equals("#res")) {
            ICType iCType = this.mMapping.getReturnTypeOfFunction(identifierExpression.getDeclarationInformation().getProcedure());
            BigInterval bigInterval = this.getRangeForCType(iCType);
            return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new ACSLResultExpression(), iCType, bigInterval);
        }
        if (this.mMapping.hasVar(string, identifierExpression.getDeclarationInformation())) {
            Triple<String, ICType, Boolean> triple = this.mMapping.getVar(string, identifierExpression.getDeclarationInformation());
            if (this.isPresentInContext((String)triple.getFirst(), iLocation)) {
                BigInterval bigInterval = this.getRangeForCType((ICType)triple.getSecond());
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new IdentifierExpression((String)triple.getFirst()), (ICType)triple.getSecond(), bigInterval);
            }
        } else if (this.mMapping.hasInVar(string, identifierExpression.getDeclarationInformation())) {
            Pair<String, ICType> pair = this.mMapping.getInVar(string, identifierExpression.getDeclarationInformation());
            BigInterval bigInterval = this.getRangeForCType((ICType)pair.getSecond());
            if (Boogie2ACSL.isFunctionDefinition(iLocation)) {
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new IdentifierExpression((String)pair.getFirst()), (ICType)pair.getSecond(), bigInterval);
            }
            return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new AtLabelExpression((Expression)new IdentifierExpression((String)pair.getFirst()), "Pre"), (ICType)pair.getSecond(), bigInterval);
        }
        this.mReporter.accept("Unknown variable: " + identifierExpression.getIdentifier());
        return null;
    }

    private static boolean isFunctionDefinition(ILocation iLocation) {
        return iLocation instanceof CLocation && ((CLocation)iLocation).getNode() instanceof IASTFunctionDefinition;
    }

    private BacktranslatedACSLValue.BacktranslatedExpression constructFloat(BitvecLiteral bitvecLiteral, BitvecLiteral bitvecLiteral2, BitvecLiteral bitvecLiteral3) {
        String string = Boogie2ACSL.bitvecToString(bitvecLiteral) + Boogie2ACSL.bitvecToString(bitvecLiteral2) + Boogie2ACSL.bitvecToString(bitvecLiteral3);
        BigDecimal bigDecimal = Boogie2ACSL.getDecimalFromBinaryString(string);
        if (bigDecimal == null) {
            this.mReporter.accept("Unable to backtranslate infinite floats");
            return null;
        }
        return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.RealLiteral(bigDecimal.toPlainString()));
    }

    private static BigDecimal getDecimalFromBinaryString(String string) {
        int n = string.length();
        if (n == 32) {
            int n2 = Integer.parseUnsignedInt(string, 2);
            float f = Float.intBitsToFloat(n2);
            if (!Float.isFinite(f)) {
                return null;
            }
            return BigDecimal.valueOf(f);
        }
        if (n == 64) {
            long l = Long.parseUnsignedLong(string, 2);
            double d = Double.longBitsToDouble(l);
            if (!Double.isFinite(d)) {
                return null;
            }
            return BigDecimal.valueOf(d);
        }
        throw new IllegalArgumentException("Unsupported length: " + n);
    }

    private static String bitvecToString(BitvecLiteral bitvecLiteral) {
        String string = new BigInteger(bitvecLiteral.getValue()).toString(2);
        assert (string.length() <= bitvecLiteral.getLength()) : "Binary string cannot be longer than bitvector literal length";
        int n = bitvecLiteral.getLength() - string.length();
        if (n > 0) {
            String string2 = "%" + bitvecLiteral.getLength() + "s";
            return String.format(string2, string).replace(' ', '0');
        }
        return string;
    }

    private BacktranslatedACSLValue.BacktranslatedExpression translateFunctionApplication(FunctionApplication functionApplication, ILocation iLocation, boolean bl) {
        BacktranslatedACSLValue.BacktranslatedExpression[] backtranslatedExpressionArray = new BacktranslatedACSLValue.BacktranslatedExpression[functionApplication.getArguments().length];
        int n = 0;
        while (n < functionApplication.getArguments().length) {
            backtranslatedExpressionArray[n] = this.translateExpression(functionApplication.getArguments()[n], iLocation, bl);
            if (backtranslatedExpressionArray[n] == null) {
                return null;
            }
            ++n;
        }
        String string = functionApplication.getIdentifier();
        Pair<String, Integer> pair = SFO.reverseBoogieFunctionName(string);
        if (pair == null) {
            this.mReporter.accept("Cannot identify Boogie2SMT function " + string);
            return null;
        }
        Integer n2 = (Integer)pair.getSecond();
        switch ((String)pair.getFirst()) {
            case "sign_extend": 
            case "zero_extend": {
                return backtranslatedExpressionArray[0];
            }
            case "fp": {
                if (Arrays.stream(functionApplication.getArguments()).allMatch(BitvecLiteral.class::isInstance)) {
                    return this.constructFloat((BitvecLiteral)functionApplication.getArguments()[0], (BitvecLiteral)functionApplication.getArguments()[1], (BitvecLiteral)functionApplication.getArguments()[2]);
                }
                this.mReporter.accept("fp can only be backtranslated, if the arguments are literals: " + String.valueOf(functionApplication));
                return null;
            }
            case "NaN": {
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.RealLiteral(String.valueOf(Float.NaN)));
            }
            case "bvadd": {
                de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression binaryExpression = new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.ARITHPLUS, backtranslatedExpressionArray[0].expression(), backtranslatedExpressionArray[1].expression());
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.ARITHMOD, (Expression)binaryExpression, (Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral(String.valueOf(1L << n2))));
            }
            case "bvmul": {
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.ARITHMUL, backtranslatedExpressionArray[0].expression(), backtranslatedExpressionArray[1].expression()));
            }
            case "bvsub": {
                de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression binaryExpression = new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.ARITHMINUS, backtranslatedExpressionArray[0].expression(), backtranslatedExpressionArray[1].expression());
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.ARITHMOD, (Expression)binaryExpression, (Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral(String.valueOf(1L << n2))));
            }
            case "bvand": {
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.BITAND, backtranslatedExpressionArray[0].expression(), backtranslatedExpressionArray[1].expression()));
            }
            case "bvor": {
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.BITOR, backtranslatedExpressionArray[0].expression(), backtranslatedExpressionArray[1].expression()));
            }
            case "bvxor": {
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.BITXOR, backtranslatedExpressionArray[0].expression(), backtranslatedExpressionArray[1].expression()));
            }
            case "bvshl": {
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.BITSHIFTLEFT, backtranslatedExpressionArray[0].expression(), backtranslatedExpressionArray[1].expression()));
            }
            case "bvashr": {
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.BITSHIFTRIGHT, backtranslatedExpressionArray[0].expression(), backtranslatedExpressionArray[1].expression()));
            }
            case "bvslt": 
            case "bvult": {
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.COMPLT, backtranslatedExpressionArray[0].expression(), backtranslatedExpressionArray[1].expression()));
            }
            case "bvsle": 
            case "bvule": {
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.COMPLEQ, backtranslatedExpressionArray[0].expression(), backtranslatedExpressionArray[1].expression()));
            }
            case "bvsgt": 
            case "bvugt": {
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.COMPGT, backtranslatedExpressionArray[0].expression(), backtranslatedExpressionArray[1].expression()));
            }
            case "bvsge": 
            case "bvuge": {
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.COMPGEQ, backtranslatedExpressionArray[0].expression(), backtranslatedExpressionArray[1].expression()));
            }
            case "bvsdiv": 
            case "bvudiv": {
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.ARITHDIV, backtranslatedExpressionArray[0].expression(), backtranslatedExpressionArray[1].expression()));
            }
            case "bvsrem": 
            case "bvurem": {
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.ARITHMOD, backtranslatedExpressionArray[0].expression(), backtranslatedExpressionArray[1].expression()));
            }
            case "bvneg": {
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.UnaryExpression(UnaryExpression.Operator.MINUS, backtranslatedExpressionArray[0].expression()));
            }
            case "bvnot": {
                return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.UnaryExpression(UnaryExpression.Operator.LOGICCOMPLEMENT, backtranslatedExpressionArray[0].expression()));
            }
        }
        this.mReporter.accept("Missing case for function " + string);
        return null;
    }

    private BacktranslatedACSLValue.BacktranslatedExpression translateBitvecLiteral(BitvecLiteral bitvecLiteral) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = new BigInteger(bitvecLiteral.getValue());
        if (bigInteger2.compareTo(bigInteger = BigInteger.TWO.pow(bitvecLiteral.getLength() - 1)) >= 0) {
            BigInteger bigInteger3 = BigInteger.TWO.pow(bitvecLiteral.getLength());
            bigInteger2 = bigInteger2.subtract(bigInteger3);
        }
        return this.translateIntegerLiteral(bigInteger2);
    }

    private static BacktranslatedACSLValue.BacktranslatedExpression translateRealLiteral(RealLiteral realLiteral) {
        return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.RealLiteral(realLiteral.getValue()));
    }

    private static BacktranslatedACSLValue.BacktranslatedExpression translateBooleanLiteral(BooleanLiteral booleanLiteral) {
        String string = booleanLiteral.getValue() ? "1" : "0";
        BigInteger bigInteger = new BigInteger(string);
        return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral(string), new CPrimitive(CPrimitive.CPrimitives.INT), BigInterval.singleton((BigInteger)bigInteger));
    }

    private BacktranslatedACSLValue.BacktranslatedExpression translateIntegerLiteral(BigInteger bigInteger) {
        String string = bigInteger.toString();
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.LONGLONG);
        if (this.fitsInType(bigInteger, (ICType)cPrimitive)) {
            CPrimitive cPrimitive2 = ISOIEC9899TC3.determineTypeForIntegerLiteral(string, this.mTypeSizes);
            return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral(string), cPrimitive2, BigInterval.singleton((BigInteger)bigInteger));
        }
        CPrimitive cPrimitive3 = new CPrimitive(CPrimitive.CPrimitives.ULONGLONG);
        if (this.fitsInType(bigInteger, (ICType)cPrimitive3)) {
            return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral(string + "U"), cPrimitive3, BigInterval.singleton((BigInteger)bigInteger));
        }
        CPrimitive cPrimitive4 = new CPrimitive(CPrimitive.CPrimitives.INT128);
        CPrimitive cPrimitive5 = new CPrimitive(CPrimitive.CPrimitives.UINT128);
        if (!this.fitsInType(bigInteger, (ICType)cPrimitive4) && !this.fitsInType(bigInteger, (ICType)cPrimitive5)) {
            this.mReporter.accept("Unable to backtranslate " + string + ", there is no C type to represent it.");
            return null;
        }
        CPrimitive cPrimitive6 = bigInteger.signum() >= 0 ? cPrimitive5 : cPrimitive4;
        BigInteger[] bigIntegerArray = bigInteger.abs().divideAndRemainder(this.mTypeSizes.getMaxValueOfPrimitiveType(cPrimitive3).add(BigInteger.ONE));
        CastExpression castExpression = new CastExpression(AcslTypeUtils.translateCTypeToAcslType(cPrimitive6), this.translateIntegerLiteral(bigIntegerArray[0]).expression());
        de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral integerLiteral = new de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral(String.valueOf(8 * this.mTypeSizes.getSize(cPrimitive3.getType())));
        de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression binaryExpression = new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.BITSHIFTLEFT, (Expression)castExpression, (Expression)integerLiteral);
        if (bigIntegerArray[1].signum() != 0) {
            binaryExpression = new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.BITOR, (Expression)binaryExpression, this.translateIntegerLiteral(bigIntegerArray[1]).expression());
        }
        if (bigInteger.signum() < 0) {
            binaryExpression = new de.uni_freiburg.informatik.ultimate.model.acsl.ast.UnaryExpression(UnaryExpression.Operator.MINUS, (Expression)binaryExpression);
        }
        return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)binaryExpression, cPrimitive6, BigInterval.singleton((BigInteger)bigInteger));
    }

    private ICType determineTypeForArithmeticOperation(ICType iCType, ICType iCType2) {
        if (iCType == null || iCType2 == null) {
            return null;
        }
        if (!(iCType instanceof CPrimitive) || !(iCType2 instanceof CPrimitive)) {
            return iCType;
        }
        CPrimitive cPrimitive = (CPrimitive)iCType;
        CPrimitive cPrimitive2 = (CPrimitive)iCType2;
        if (!cPrimitive.isIntegerType() || !cPrimitive2.isIntegerType()) {
            return iCType;
        }
        if (this.mTypeSizes.getSize(cPrimitive.getType()) == this.mTypeSizes.getSize(cPrimitive2.getType())) {
            return this.mTypeSizes.isUnsigned(cPrimitive) ? cPrimitive : cPrimitive2;
        }
        return this.mTypeSizes.getSize(cPrimitive.getType()) >= this.mTypeSizes.getSize(cPrimitive2.getType()) ? cPrimitive : cPrimitive2;
    }

    private boolean fitsInType(BigInteger bigInteger, ICType iCType) {
        return this.fitsInType(BigInterval.singleton((BigInteger)bigInteger), iCType);
    }

    private boolean fitsInType(BigInterval bigInterval, ICType iCType) {
        return this.getRangeForCType(iCType).contains(bigInterval);
    }

    private ICType determineTypeForRange(BigInterval bigInterval) {
        List<CPrimitive.CPrimitives> list = List.of(CPrimitive.CPrimitives.CHAR, CPrimitive.CPrimitives.UCHAR, CPrimitive.CPrimitives.SHORT, CPrimitive.CPrimitives.USHORT, CPrimitive.CPrimitives.INT, CPrimitive.CPrimitives.UINT, CPrimitive.CPrimitives.LONG, CPrimitive.CPrimitives.ULONG, CPrimitive.CPrimitives.LONGLONG, CPrimitive.CPrimitives.ULONGLONG, CPrimitive.CPrimitives.INT128, CPrimitive.CPrimitives.UINT128);
        for (CPrimitive.CPrimitives cPrimitives : list) {
            CPrimitive cPrimitive = new CPrimitive(cPrimitives);
            if (!this.fitsInType(bigInterval, (ICType)cPrimitive)) continue;
            return cPrimitive;
        }
        return null;
    }

    private BacktranslatedACSLValue.BacktranslatedExpression translateDiv(BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression, BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression2) {
        if (backtranslatedExpression == null || backtranslatedExpression2 == null) {
            return null;
        }
        BigInterval bigInterval = backtranslatedExpression.range();
        BigInterval bigInterval2 = backtranslatedExpression2.range();
        BigInterval bigInterval3 = bigInterval.euclideanDivide(bigInterval2);
        de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression binaryExpression = new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.ARITHDIV, backtranslatedExpression.expression(), backtranslatedExpression2.expression());
        if (bigInterval.isNonNegative()) {
            if (bigInterval3.isSingleton()) {
                return this.translateIntegerLiteral(bigInterval3.getMinValue());
            }
            return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)binaryExpression, backtranslatedExpression.cType(), bigInterval3);
        }
        de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression binaryExpression2 = new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.ARITHMINUS, (Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.ARITHDIV, backtranslatedExpression.expression(), backtranslatedExpression2.expression()), (Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral("1"));
        de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression binaryExpression3 = new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.ARITHPLUS, (Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.ARITHDIV, backtranslatedExpression.expression(), backtranslatedExpression2.expression()), (Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral("1"));
        Object object = bigInterval2.isNonNegative() ? binaryExpression2 : (bigInterval2.isNonPositive() ? binaryExpression3 : new IfThenElseExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.COMPGEQ, backtranslatedExpression2.expression(), (Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral("0")), (Expression)binaryExpression2, (Expression)binaryExpression3));
        if (bigInterval.isNonPositive()) {
            return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)object, backtranslatedExpression.cType(), bigInterval3);
        }
        return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new IfThenElseExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.COMPGEQ, backtranslatedExpression.expression(), (Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral("0")), (Expression)binaryExpression, (Expression)object), backtranslatedExpression.cType(), bigInterval3);
    }

    private static BacktranslatedACSLValue.BacktranslatedExpression translateModulo(BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression, BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression2) {
        BigInterval bigInterval;
        if (backtranslatedExpression == null || backtranslatedExpression2 == null) {
            return null;
        }
        BigInterval bigInterval2 = backtranslatedExpression.range();
        BigInterval bigInterval3 = backtranslatedExpression2.range();
        if (bigInterval3.isStrictlyPositive() && (bigInterval = new BigInterval(BigInteger.ZERO, bigInterval3.getMinValue().subtract(BigInteger.ONE))).contains(bigInterval2)) {
            return backtranslatedExpression;
        }
        bigInterval = new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.ARITHMOD, backtranslatedExpression.expression(), backtranslatedExpression2.expression());
        BigInterval bigInterval4 = bigInterval2.euclideanModulo(bigInterval3);
        if (bigInterval2.isNonNegative()) {
            return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)bigInterval, backtranslatedExpression.cType(), bigInterval4);
        }
        de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression binaryExpression = new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.ARITHPLUS, (Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.ARITHMOD, backtranslatedExpression.expression(), backtranslatedExpression2.expression()), backtranslatedExpression2.expression());
        de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression binaryExpression2 = new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.ARITHMINUS, (Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.ARITHMOD, backtranslatedExpression.expression(), backtranslatedExpression2.expression()), backtranslatedExpression2.expression());
        Object object = bigInterval3.isNonNegative() ? binaryExpression : (bigInterval3.isNonPositive() ? binaryExpression2 : new IfThenElseExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.COMPGEQ, backtranslatedExpression2.expression(), (Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral("0")), (Expression)binaryExpression, (Expression)binaryExpression2));
        if (bigInterval2.isNonPositive()) {
            return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)object, backtranslatedExpression.cType(), bigInterval4);
        }
        return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)new IfThenElseExpression((Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(BinaryExpression.Operator.COMPGEQ, backtranslatedExpression.expression(), (Expression)new de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral("0")), (Expression)bigInterval, (Expression)object), backtranslatedExpression.cType(), bigInterval4);
    }

    private BacktranslatedACSLValue.BacktranslatedExpression translateBinaryExpression(BinaryExpression binaryExpression, ILocation iLocation, boolean bl) {
        BinaryExpression.Operator operator;
        BigInterval bigInterval;
        ICType iCType;
        BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression = this.translateExpression(binaryExpression.getLeft(), iLocation, bl);
        BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression2 = this.translateExpression(binaryExpression.getRight(), iLocation, bl);
        BigInterval bigInterval2 = backtranslatedExpression == null ? BigInterval.unbounded() : backtranslatedExpression.range();
        BigInterval bigInterval3 = backtranslatedExpression2 == null ? BigInterval.unbounded() : backtranslatedExpression2.range();
        ICType iCType2 = backtranslatedExpression == null ? null : backtranslatedExpression.cType();
        ICType iCType3 = backtranslatedExpression2 == null ? null : backtranslatedExpression2.cType();
        switch (binaryExpression.getOperator()) {
            case ARITHDIV: {
                return this.translateDiv(backtranslatedExpression, backtranslatedExpression2);
            }
            case ARITHMINUS: {
                if (bigInterval3.isZero()) {
                    return backtranslatedExpression;
                }
                iCType = this.determineTypeForArithmeticOperation(iCType2, iCType3);
                bigInterval = bigInterval2.subtract(bigInterval3);
                operator = BinaryExpression.Operator.ARITHMINUS;
                break;
            }
            case ARITHMOD: {
                return Boogie2ACSL.translateModulo(backtranslatedExpression, backtranslatedExpression2);
            }
            case ARITHMUL: {
                iCType = this.determineTypeForArithmeticOperation(iCType2, iCType3);
                bigInterval = bigInterval2.multiply(bigInterval3);
                operator = BinaryExpression.Operator.ARITHMUL;
                break;
            }
            case ARITHPLUS: {
                if (bigInterval2.isZero()) {
                    return backtranslatedExpression2;
                }
                if (bigInterval3.isZero()) {
                    return backtranslatedExpression;
                }
                iCType = this.determineTypeForArithmeticOperation(iCType2, iCType3);
                bigInterval = bigInterval2.add(bigInterval3);
                operator = BinaryExpression.Operator.ARITHPLUS;
                break;
            }
            case COMPEQ: {
                bigInterval = BigInterval.booleanRange();
                operator = BinaryExpression.Operator.COMPEQ;
                iCType = new CPrimitive(CPrimitive.CPrimitives.INT);
                break;
            }
            case COMPGEQ: {
                bigInterval = BigInterval.booleanRange();
                operator = BinaryExpression.Operator.COMPGEQ;
                iCType = new CPrimitive(CPrimitive.CPrimitives.INT);
                break;
            }
            case COMPGT: {
                bigInterval = BigInterval.booleanRange();
                operator = BinaryExpression.Operator.COMPGT;
                iCType = new CPrimitive(CPrimitive.CPrimitives.INT);
                break;
            }
            case COMPLEQ: {
                bigInterval = BigInterval.booleanRange();
                operator = BinaryExpression.Operator.COMPLEQ;
                iCType = new CPrimitive(CPrimitive.CPrimitives.INT);
                break;
            }
            case COMPLT: {
                bigInterval = BigInterval.booleanRange();
                operator = BinaryExpression.Operator.COMPLT;
                iCType = new CPrimitive(CPrimitive.CPrimitives.INT);
                break;
            }
            case COMPNEQ: {
                bigInterval = BigInterval.booleanRange();
                operator = BinaryExpression.Operator.COMPNEQ;
                iCType = new CPrimitive(CPrimitive.CPrimitives.INT);
                break;
            }
            case LOGICAND: {
                if (!bl) {
                    if (backtranslatedExpression == null) {
                        return backtranslatedExpression2;
                    }
                    if (backtranslatedExpression2 == null) {
                        return backtranslatedExpression;
                    }
                }
                bigInterval = BigInterval.booleanRange();
                operator = BinaryExpression.Operator.LOGICAND;
                iCType = new CPrimitive(CPrimitive.CPrimitives.INT);
                break;
            }
            case LOGICOR: {
                if (bl) {
                    if (backtranslatedExpression == null) {
                        return backtranslatedExpression2;
                    }
                    if (backtranslatedExpression2 == null) {
                        return backtranslatedExpression;
                    }
                }
                bigInterval = BigInterval.booleanRange();
                operator = BinaryExpression.Operator.LOGICOR;
                iCType = new CPrimitive(CPrimitive.CPrimitives.INT);
                break;
            }
            default: {
                this.mReporter.accept("Operator not supported: " + String.valueOf(binaryExpression.getOperator()));
                return null;
            }
        }
        if (backtranslatedExpression == null || backtranslatedExpression2 == null) {
            return null;
        }
        if (bigInterval.isSingleton()) {
            return this.translateIntegerLiteral(bigInterval.getMinValue());
        }
        Expression expression = backtranslatedExpression.expression();
        if (!this.fitsInType(bigInterval, iCType) && (iCType = this.determineTypeForRange(bigInterval)) != null) {
            expression = new CastExpression(AcslTypeUtils.translateCTypeToAcslType(iCType), expression);
        }
        de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression binaryExpression2 = new de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression(operator, expression, backtranslatedExpression2.expression());
        return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)binaryExpression2, iCType, bigInterval);
    }

    private BacktranslatedACSLValue.BacktranslatedExpression translateUnaryExpression(UnaryExpression unaryExpression, ILocation iLocation, boolean bl) {
        ICType iCType;
        Object object;
        BigInterval bigInterval;
        switch (unaryExpression.getOperator()) {
            case ARITHNEGATIVE: {
                BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression = this.translateExpression(unaryExpression.getExpr(), iLocation, bl);
                if (backtranslatedExpression == null) {
                    return null;
                }
                bigInterval = backtranslatedExpression.range().negate();
                object = new de.uni_freiburg.informatik.ultimate.model.acsl.ast.UnaryExpression(UnaryExpression.Operator.MINUS, backtranslatedExpression.expression());
                iCType = backtranslatedExpression.cType();
                break;
            }
            case LOGICNEG: {
                BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression = this.translateExpression(unaryExpression.getExpr(), iLocation, !bl);
                if (backtranslatedExpression == null) {
                    return null;
                }
                bigInterval = BigInterval.booleanRange();
                object = new de.uni_freiburg.informatik.ultimate.model.acsl.ast.UnaryExpression(UnaryExpression.Operator.LOGICNEG, backtranslatedExpression.expression());
                iCType = backtranslatedExpression.cType();
                break;
            }
            case OLD: {
                BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression = this.translateExpression(unaryExpression.getExpr(), iLocation, bl);
                if (backtranslatedExpression == null) {
                    return null;
                }
                bigInterval = backtranslatedExpression.range();
                object = Boogie2ACSL.isFunctionDefinition(iLocation) ? new OldValueExpression(backtranslatedExpression.expression()) : new AtLabelExpression(backtranslatedExpression.expression(), "Pre");
                iCType = backtranslatedExpression.cType();
                break;
            }
            default: {
                this.mReporter.accept("Operator not supported: " + String.valueOf(unaryExpression.getOperator()));
                return null;
            }
        }
        return new BacktranslatedACSLValue.BacktranslatedExpression((Expression)object, iCType, bigInterval);
    }

    private boolean isPresentInContext(String string, ILocation iLocation) {
        if (iLocation instanceof CLocation) {
            return this.mSymbolTable.containsCSymbol(((CLocation)iLocation).getNode(), string);
        }
        return true;
    }

    private BigInterval getRangeForCType(ICType iCType) {
        if (iCType == null || !(iCType.getUnderlyingType() instanceof CPrimitive)) {
            return BigInterval.unbounded();
        }
        CPrimitive cPrimitive = (CPrimitive)iCType.getUnderlyingType();
        if (!cPrimitive.isIntegerType()) {
            return BigInterval.unbounded();
        }
        return new BigInterval(this.mTypeSizes.getMinValueOfPrimitiveType(cPrimitive), this.mTypeSizes.getMaxValueOfPrimitiveType(cPrimitive));
    }

    private BacktranslatedACSLValue.BacktranslatedExpression translateArrayAccess(ArrayAccessExpression arrayAccessExpression, ILocation iLocation) {
        BigInterval bigInterval;
        BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression = this.translateExpression(arrayAccessExpression.getArray(), iLocation);
        if (backtranslatedExpression == null) {
            this.mReporter.accept("Cannot backtranslate array access to array " + String.valueOf(arrayAccessExpression.getArray()));
            return null;
        }
        Expression expression = backtranslatedExpression.expression();
        ICType iCType = backtranslatedExpression.cType();
        de.uni_freiburg.informatik.ultimate.boogie.ast.Expression[] expressionArray = arrayAccessExpression.getIndices();
        int n = expressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            bigInterval = expressionArray[n2];
            BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression2 = this.translateExpression((de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)bigInterval, iLocation);
            if (backtranslatedExpression2 == null) {
                return null;
            }
            expression = new de.uni_freiburg.informatik.ultimate.model.acsl.ast.ArrayAccessExpression(expression, backtranslatedExpression2.expression());
            iCType = ((CArray)iCType).getValueType();
            ++n2;
        }
        bigInterval = this.getRangeForCType(iCType);
        return new BacktranslatedACSLValue.BacktranslatedExpression(expression, iCType, bigInterval);
    }
}

