/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelectOverNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class ArrayOccurrenceAnalysis {
    private static final boolean THROW_ERROR_BEFORE_DOWNGRADE = false;
    private final Term mAnalyzedTerm;
    private final Term mWantedArray;
    private final int mDimensionUpperLimit;
    private final List<MultiDimensionalSelectOverNestedStore> mArraySelectOverStores = new ArrayList<MultiDimensionalSelectOverNestedStore>();
    private final List<MultiDimensionalNestedStore> mNestedArrayStores = new ArrayList<MultiDimensionalNestedStore>();
    private final List<MultiDimensionalSelect> mArraySelects = new ArrayList<MultiDimensionalSelect>();
    private final List<BinaryEqualityRelation> mArrayEqualities = new ArrayList<BinaryEqualityRelation>();
    private final List<BinaryEqualityRelation> mArrayDisequalities = new ArrayList<BinaryEqualityRelation>();
    private final List<Term> mOtherFunctionApplications = new ArrayList<Term>();
    private final List<Term> mIsValueOfStore = new ArrayList<Term>();

    public ArrayOccurrenceAnalysis(Script script, Term term, Term term2) {
        this.mAnalyzedTerm = term;
        this.mWantedArray = term2;
        this.mDimensionUpperLimit = Integer.MAX_VALUE;
        new ArrOccFinder(script, this.mAnalyzedTerm);
    }

    public ArrayOccurrenceAnalysis(Script script, Term term, Term term2, int n) {
        this.mAnalyzedTerm = term;
        this.mWantedArray = term2;
        this.mDimensionUpperLimit = n;
        new ArrOccFinder(script, this.mAnalyzedTerm);
    }

    public List<MultiDimensionalSelectOverNestedStore> getArraySelectOverStores() {
        return this.mArraySelectOverStores;
    }

    public List<MultiDimensionalNestedStore> getNestedArrayStores() {
        return this.mNestedArrayStores;
    }

    public List<MultiDimensionalSelect> getArraySelects() {
        return this.mArraySelects;
    }

    public List<BinaryEqualityRelation> getArrayEqualities() {
        return this.mArrayEqualities;
    }

    public List<BinaryEqualityRelation> getArrayDisequalities() {
        return this.mArrayDisequalities;
    }

    public List<Term> getOtherFunctionApplications() {
        return this.mOtherFunctionApplications;
    }

    public List<Term> getValueOfStore() {
        return this.mIsValueOfStore;
    }

    public List<BinaryEqualityRelation> getDerRelations(int n) {
        if (n == 0) {
            return this.getArrayEqualities().stream().filter(binaryEqualityRelation -> ArrayOccurrenceAnalysis.isRhsOrLhs(this.mWantedArray, binaryEqualityRelation)).collect(Collectors.toList());
        }
        if (n == 1) {
            return this.getArrayDisequalities().stream().filter(binaryEqualityRelation -> ArrayOccurrenceAnalysis.isRhsOrLhs(this.mWantedArray, binaryEqualityRelation)).collect(Collectors.toList());
        }
        throw new AssertionError((Object)"unknown quantifier");
    }

    public List<BinaryEqualityRelation> getAntiDerRelations(int n) {
        if (n == 0) {
            return this.getArrayDisequalities();
        }
        if (n == 1) {
            return this.getArrayEqualities();
        }
        throw new AssertionError((Object)"unknown quantifier");
    }

    public TreeSet<Integer> computeSelectAndStoreDimensions() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (MultiDimensionalSelect iTermProvider : this.getArraySelects()) {
            treeSet.add(iTermProvider.getDimension());
        }
        for (MultiDimensionalNestedStore multiDimensionalNestedStore : this.getNestedArrayStores()) {
            treeSet.add(multiDimensionalNestedStore.getDimension());
        }
        return treeSet;
    }

    public ArrayOccurrenceAnalysis downgradeDimensionsIfNecessary(Script script) {
        TreeSet<Integer> treeSet = this.computeSelectAndStoreDimensions();
        if (treeSet.size() <= 1) {
            return this;
        }
        int n = treeSet.first();
        assert (n >= 1);
        return new ArrayOccurrenceAnalysis(script, this.mAnalyzedTerm, this.mWantedArray, n);
    }

    private static boolean isRhsOrLhs(Term term, BinaryEqualityRelation binaryEqualityRelation) {
        return binaryEqualityRelation.getLhs().equals(term) || binaryEqualityRelation.getRhs().equals(term);
    }

    private static boolean isSubtermOfSome(Term term, Term ... termArray) {
        return Arrays.stream(termArray).anyMatch(term2 -> SmtUtils.isSubterm(term2, term));
    }

    public static Set<ArrayIndex> extractSelectIndices(List<MultiDimensionalSelect> list) {
        return list.stream().map(MultiDimensionalSelect::getIndex).collect(Collectors.toSet());
    }

    public static Set<ArrayIndex> extractStoreIndices(List<MultiDimensionalStore> list) {
        return list.stream().map(MultiDimensionalStore::getIndex).collect(Collectors.toSet());
    }

    public static Set<ArrayIndex> extractNestedStoreIndices(List<MultiDimensionalNestedStore> list) {
        return list.stream().map(MultiDimensionalNestedStore::getIndices).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static boolean isStoreWhereWantedArrayIsValue(Term term, Term term2) {
        ArrayStore arrayStore = ArrayStore.of(term);
        if (arrayStore == null) {
            return false;
        }
        return arrayStore.getValue().equals(term2);
    }

    private class ArrOccFinder
    extends NonRecursive {
        private final Script mScript;
        private final Set<Term> mTermsInWhichWeAlreadyDescended = new HashSet<Term>();

        public ArrOccFinder(Script script, Term term) {
            this.mScript = script;
            this.run((NonRecursive.Walker)new MyWalker(term));
        }

        class MyWalker
        extends NonRecursive.TermWalker {
            MyWalker(Term term) {
                super(term);
            }

            public void walk(NonRecursive nonRecursive) {
                if (!ArrOccFinder.this.mTermsInWhichWeAlreadyDescended.contains(this.getTerm())) {
                    super.walk(nonRecursive);
                }
            }

            public void walk(NonRecursive nonRecursive, ConstantTerm constantTerm) {
            }

            public void walk(NonRecursive nonRecursive, AnnotatedTerm annotatedTerm) {
                ArrOccFinder.this.mTermsInWhichWeAlreadyDescended.add((Term)annotatedTerm);
                nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(annotatedTerm.getSubterm()));
            }

            /*
             * WARNING - void declaration
             */
            public void walk(NonRecursive nonRecursive, ApplicationTerm applicationTerm) {
                ArrOccFinder.this.mTermsInWhichWeAlreadyDescended.add((Term)applicationTerm);
                String string = applicationTerm.getFunction().getName();
                if (string.equals("=")) {
                    if (applicationTerm.getParameters().length != 2) {
                        throw new UnsupportedOperationException("expecting equality with two parameters");
                    }
                    if (SmtSortUtils.isArraySort(applicationTerm.getParameters()[0].getSort()) && ArrayOccurrenceAnalysis.isSubtermOfSome(((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray, applicationTerm.getParameters()[0], applicationTerm.getParameters()[1])) {
                        ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mArrayEqualities.add(this.constructBinaryEqualityRelation(applicationTerm));
                    }
                    nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(applicationTerm.getParameters()[0]));
                    nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(applicationTerm.getParameters()[1]));
                } else {
                    if (string.equals("distinct")) {
                        throw new UnsupportedOperationException("UNF requires negated equality");
                    }
                    if (string.equals("not")) {
                        assert (applicationTerm.getParameters().length == 1);
                        if (!SmtUtils.isAtomicFormula(applicationTerm.getParameters()[0])) {
                            throw new UnsupportedOperationException("expected NNF");
                        }
                        Term term2 = applicationTerm.getParameters()[0];
                        if (term2 instanceof ApplicationTerm) {
                            ApplicationTerm applicationTerm2 = (ApplicationTerm)term2;
                            if (applicationTerm2.getFunction().getName().equals("=")) {
                                if (applicationTerm2.getParameters().length != 2) {
                                    throw new UnsupportedOperationException("expecting equality with two parameters");
                                }
                                if (SmtSortUtils.isArraySort(applicationTerm2.getParameters()[0].getSort()) && ArrayOccurrenceAnalysis.isSubtermOfSome(((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray, applicationTerm2.getParameters()[0], applicationTerm2.getParameters()[1])) {
                                    ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mArrayDisequalities.add(this.constructBinaryEqualityRelation(applicationTerm));
                                }
                                nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(applicationTerm2.getParameters()[0]));
                                nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(applicationTerm2.getParameters()[1]));
                            } else {
                                nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(term2));
                            }
                        } else {
                            nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(term2));
                        }
                    } else if (string.equals("store")) {
                        MultiDimensionalNestedStore multiDimensionalNestedStore = MultiDimensionalNestedStore.of((Term)applicationTerm);
                        if (multiDimensionalNestedStore != null) {
                            Set<Term> object2 = SubTermFinder.find((Term)applicationTerm, term -> ArrayOccurrenceAnalysis.isStoreWhereWantedArrayIsValue(term, ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray), false);
                            ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mIsValueOfStore.addAll(object2);
                        }
                        if (multiDimensionalNestedStore != null && multiDimensionalNestedStore.getArray().equals(((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray)) {
                            if (multiDimensionalNestedStore.getDimension() > ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mDimensionUpperLimit) {
                                multiDimensionalNestedStore = new MultiDimensionalNestedStore(multiDimensionalNestedStore.extractDowngradeToHigherDimensions(ArrOccFinder.this.mScript, ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mDimensionUpperLimit));
                                assert (multiDimensionalNestedStore.getArray() == ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray);
                            }
                            assert (multiDimensionalNestedStore.getArray() == ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray);
                            ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mNestedArrayStores.add(multiDimensionalNestedStore);
                            for (ArrayIndex object : multiDimensionalNestedStore.getIndices()) {
                                for (Term term2 : object) {
                                    nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(term2));
                                }
                            }
                            for (Term multiDimensionalSelect : multiDimensionalNestedStore.getValues()) {
                                nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(multiDimensionalSelect));
                            }
                        } else {
                            Term[] termArray = applicationTerm.getParameters();
                            int n = termArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Term term3 = termArray[n2];
                                nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(term3));
                                ++n2;
                            }
                        }
                    } else if (string.equals("select")) {
                        MultiDimensionalSelectOverNestedStore multiDimensionalSelectOverNestedStore = MultiDimensionalSelectOverNestedStore.of((Term)applicationTerm);
                        if (multiDimensionalSelectOverNestedStore != null) {
                            if (multiDimensionalSelectOverNestedStore.getNestedStore().getArray().equals(((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray)) {
                                if (multiDimensionalSelectOverNestedStore.getNestedStore().getDimension() > ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mDimensionUpperLimit) {
                                    Term[] termArray = applicationTerm.getParameters();
                                    int n = termArray.length;
                                    int n3 = 0;
                                    while (n3 < n) {
                                        Term term4 = termArray[n3];
                                        nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(term4));
                                        ++n3;
                                    }
                                    return;
                                }
                                ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mArraySelectOverStores.add(multiDimensionalSelectOverNestedStore);
                                for (Term term5 : multiDimensionalSelectOverNestedStore.getSelectIndex()) {
                                    nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(term5));
                                }
                                for (ArrayIndex arrayIndex : multiDimensionalSelectOverNestedStore.getNestedStore().getIndices()) {
                                    for (Term term6 : arrayIndex) {
                                        nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(term6));
                                    }
                                }
                                for (Term term7 : multiDimensionalSelectOverNestedStore.getNestedStore().getValues()) {
                                    nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(term7));
                                }
                            } else {
                                Term[] termArray = applicationTerm.getParameters();
                                int n = termArray.length;
                                int n4 = 0;
                                while (n4 < n) {
                                    Term term8 = termArray[n4];
                                    nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(term8));
                                    ++n4;
                                }
                            }
                        } else {
                            MultiDimensionalSelect multiDimensionalSelect = MultiDimensionalSelect.of((Term)applicationTerm);
                            if (multiDimensionalSelect.getIndex().size() > 0 && multiDimensionalSelect.getArray().equals(((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray) && multiDimensionalSelect.getDimension() <= ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mDimensionUpperLimit) {
                                ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mArraySelects.add(multiDimensionalSelect);
                                for (Term term9 : multiDimensionalSelect.getIndex()) {
                                    nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(term9));
                                }
                            } else {
                                Term[] termArray = applicationTerm.getParameters();
                                int n = termArray.length;
                                int n5 = 0;
                                while (n5 < n) {
                                    Term term10 = termArray[n5];
                                    nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(term10));
                                    ++n5;
                                }
                            }
                        }
                    } else {
                        void var5_25;
                        Term[] termArray = applicationTerm.getParameters();
                        int n = termArray.length;
                        boolean bl = false;
                        while (var5_25 < n) {
                            Term term9 = termArray[var5_25];
                            if (term9.equals(((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray)) {
                                ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mOtherFunctionApplications.add(term9);
                            } else {
                                nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(term9));
                            }
                            ++var5_25;
                        }
                    }
                }
            }

            private BinaryEqualityRelation constructBinaryEqualityRelation(ApplicationTerm applicationTerm) {
                BinaryEqualityRelation binaryEqualityRelation = BinaryEqualityRelation.convert((Term)applicationTerm);
                if (binaryEqualityRelation == null) {
                    throw new AssertionError((Object)"Cannot convert relation");
                }
                return binaryEqualityRelation;
            }

            public void walk(NonRecursive nonRecursive, LetTerm letTerm) {
                throw new UnsupportedOperationException();
            }

            public void walk(NonRecursive nonRecursive, QuantifiedFormula quantifiedFormula) {
                nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(quantifiedFormula.getSubformula()));
            }

            public void walk(NonRecursive nonRecursive, TermVariable termVariable) {
            }

            public void walk(NonRecursive nonRecursive, MatchTerm matchTerm) {
                throw new UnsupportedOperationException("not yet implemented: MatchTerm");
            }

            public void walk(NonRecursive nonRecursive, LambdaTerm lambdaTerm) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

