/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.HistoryRecordingScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.DiffWrapperScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.LoggingScriptForMainTrackBenchmarks;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.LoggingScriptForUnsatCoreBenchmarks;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SMTFeatureExtractorScript;
import de.uni_freiburg.informatik.ultimate.logic.LoggingScript;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.MusEnumerationScript;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.NonIncrementalScriptor;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Scriptor;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.ScriptorWithGetInterpolants;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.SmtInterpolLogProxyWrapper;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.ReflectionUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public final class SolverBuilder {
    public static final boolean USE_DIFF_WRAPPER_SCRIPT = true;
    private static final boolean USE_WRAPPER_SCRIPT_WITH_TERM_CONSTRUCTION_CHECKS = false;

    private SolverBuilder() {
    }

    public static SolverSettings constructSolverSettings() throws AssertionError {
        return new SolverSettings(SolverMode.Internal_SMTInterpol, false, false, null, null, -1L, null, false, false, false, null, null, false, false, null, false, Collections.emptyMap(), null, false);
    }

    public static Script buildScript(IUltimateServiceProvider iUltimateServiceProvider, SolverSettings solverSettings) {
        Object object;
        ILogger iLogger = iUltimateServiceProvider.getLoggingService().getLogger(SolverBuilder.class);
        ILogger iLogger2 = SolverBuilder.getSolverLogger(iUltimateServiceProvider, solverSettings);
        if (solverSettings.useExternalSolver()) {
            object = SolverBuilder.createExternalSolver(iUltimateServiceProvider, solverSettings, iLogger2, iLogger);
        } else {
            iLogger.info("Constructing new instance of SMTInterpol with explicit timeout %s ms and remaining time %s ms", new Object[]{solverSettings.getTimeoutSmtInterpol(), iUltimateServiceProvider.getProgressMonitorService().remainingTime()});
            SmtInterpolLogProxyWrapper smtInterpolLogProxyWrapper = new SmtInterpolLogProxyWrapper(iLogger2);
            SMTInterpolTerminationRequest sMTInterpolTerminationRequest = new SMTInterpolTerminationRequest(iUltimateServiceProvider.getProgressMonitorService());
            object = solverSettings.useMinimalUnsatCoreEnumerationForSmtInterpol() ? new MusEnumerationScript(new SMTInterpol((LogProxy)smtInterpolLogProxyWrapper, (TerminationRequest)sMTInterpolTerminationRequest)) : new SMTInterpol((LogProxy)smtInterpolLogProxyWrapper, (TerminationRequest)sMTInterpolTerminationRequest);
            if (solverSettings.dumpSmtScriptToFile()) {
                object = SolverBuilder.wrapScriptWithLoggingScript(iUltimateServiceProvider, object, iLogger, solverSettings.constructFullPathOfDumpedScript());
            }
            if (solverSettings.getTimeoutSmtInterpol() != -1L) {
                object.setOption(":timeout", (Object)solverSettings.getTimeoutSmtInterpol());
            }
            object = new SelfDestructingSolverStorable((Script)object, iUltimateServiceProvider.getStorage());
        }
        if (solverSettings.dumpFeatureExtractionVector()) {
            object = new SMTFeatureExtractorScript((Script)object, SolverBuilder.getSolverLogger(iUltimateServiceProvider, solverSettings), solverSettings.getFeatureVectorDumpPath());
        }
        if (solverSettings.dumpUnsatCoreTrackBenchmark()) {
            object = new LoggingScriptForUnsatCoreBenchmarks((Script)object, solverSettings.getBaseNameOfDumpedScript(), solverSettings.getPathOfDumpedScript());
        }
        if (solverSettings.dumpMainTrackBenchmark()) {
            object = new LoggingScriptForMainTrackBenchmarks((Script)object, solverSettings.getBaseNameOfDumpedScript(), solverSettings.getPathOfDumpedScript());
        }
        return new HistoryRecordingScript((Script)object);
    }

    private static Script createExternalSolver(IUltimateServiceProvider iUltimateServiceProvider, SolverSettings solverSettings, ILogger iLogger, ILogger iLogger2) {
        Object object;
        String string;
        assert (solverSettings.getSolverMode() == null || solverSettings.getSolverMode() != SolverMode.Internal_SMTInterpol) : "You set solver mode to Internal* and enabled useExternalSolver";
        String string2 = solverSettings.getCommandExternalSolver();
        iLogger2.info("Constructing external solver with command: %s", new Object[]{solverSettings.getCommandExternalSolver()});
        if (solverSettings.dumpSmtScriptToFile()) {
            string = solverSettings.constructFullPathOfDumpedScript();
            iLogger2.info((Object)("Dumping SMT script to " + string));
        } else {
            string = null;
        }
        try {
            ScriptorWithGetInterpolants.ExternalInterpolator externalInterpolator = solverSettings.getExternalInterpolator();
            if (externalInterpolator == null) {
                object = solverSettings.fakeNonIncrementalScript() ? new NonIncrementalScriptor(string2, iLogger, iUltimateServiceProvider, "External_FakeNonIncremental", solverSettings.dumpSmtScriptToFile(), solverSettings.getPathOfDumpedScript(), solverSettings.getBaseNameOfDumpedScript(), string) : new Scriptor(string2, iLogger, iUltimateServiceProvider, "External", string);
            } else {
                iLogger2.info((Object)("external solver will use " + String.valueOf(externalInterpolator) + " interpolation mode"));
                object = new ScriptorWithGetInterpolants(string2, iLogger, iUltimateServiceProvider, externalInterpolator, "ExternalInterpolator", string);
            }
            if (solverSettings.useDiffWrapper()) {
                object = new DiffWrapperScript((Script)object);
            }
        }
        catch (IOException iOException) {
            iLogger2.fatal("Unable to construct solver: %s", new Object[]{iOException.getMessage()});
            throw new RuntimeException(iOException);
        }
        return object;
    }

    public static Script buildAndInitializeSolver(IUltimateServiceProvider iUltimateServiceProvider, SolverSettings solverSettings, String string) throws AssertionError {
        if (solverSettings.getSolverMode() == null) {
            throw new IllegalArgumentException("You cannot initialize a solver without specifying the solver mode in the solver settings instance");
        }
        Script script = SolverBuilder.buildScript(iUltimateServiceProvider, solverSettings);
        if (!solverSettings.getAdditionalOptions().isEmpty()) {
            for (Map.Entry<String, String> object2 : solverSettings.getAdditionalOptions().entrySet()) {
                script.setOption(":" + object2.getKey(), (Object)object2.getValue());
            }
        }
        SolverBuilder.setSolverModeDependentOptions(solverSettings, script);
        String string2 = "SMT script generated on " + CoreUtil.getIsoUtcTimestampWithUtcOffset() + " by Ultimate (https://ultimate.informatik.uni-freiburg.de/)";
        script.setInfo(":source", (Object)string2);
        script.setInfo(":smt-lib-version", (Object)new BigDecimal("2.5"));
        script.setInfo(":category", (Object)new QuotedObject("industrial"));
        script.setInfo(":ultimate-id", (Object)string);
        return script;
    }

    private static Script wrapScriptWithLoggingScript(IUltimateServiceProvider iUltimateServiceProvider, Script script, ILogger iLogger, String string) {
        SelfDestructingSolverStorable selfDestructingSolverStorable;
        try {
            selfDestructingSolverStorable = new SelfDestructingSolverStorable((Script)new LoggingScript(script, string, true), iUltimateServiceProvider.getStorage());
            iLogger.info((Object)("Dumping SMT script to " + string));
        }
        catch (IOException iOException) {
            iLogger.error((Object)("Unable dump SMT script to " + string));
            throw new RuntimeException(iOException);
        }
        return selfDestructingSolverStorable;
    }

    private static ILogger getSolverLogger(IUltimateServiceProvider iUltimateServiceProvider, SolverSettings solverSettings) {
        if (solverSettings.getSolverLogger() != null) {
            return solverSettings.getSolverLogger();
        }
        return iUltimateServiceProvider.getLoggingService().getLoggerForExternalTool(SolverBuilder.class);
    }

    private static void setSolverModeDependentOptions(SolverSettings solverSettings, Script script) throws AssertionError {
        Logics logics = solverSettings.getSolverLogics();
        switch (solverSettings.getSolverMode()) {
            case External_DefaultMode: {
                if (logics == null) break;
                script.setLogic(logics);
                break;
            }
            case External_ModelsMode: {
                script.setOption(":produce-models", (Object)true);
                if (logics == null) break;
                script.setLogic(logics);
                break;
            }
            case External_ModelsAndUnsatCoreMode: {
                script.setOption(":produce-models", (Object)true);
                script.setOption(":produce-unsat-cores", (Object)true);
                if (logics == null) break;
                script.setLogic(logics);
                break;
            }
            case External_PrincessInterpolationMode: 
            case External_SMTInterpolInterpolationMode: 
            case External_MathsatInterpolationMode: {
                script.setOption(":produce-models", (Object)true);
                script.setOption(":produce-interpolants", (Object)true);
                if (logics == null) break;
                script.setLogic(logics);
                break;
            }
            case External_Z3InterpolationMode: {
                script.setOption(":produce-models", (Object)true);
                script.setOption(":produce-interpolants", (Object)true);
                if (logics == null) break;
                script.setLogic(logics);
                if (logics.isArray()) {
                    Sort sort = SmtSortUtils.getIntSort(script);
                    Sort sort2 = SmtSortUtils.getIntSort(script);
                    Sort sort3 = SmtSortUtils.getArraySort(script, sort, sort2);
                    script.declareFun("array-ext", new Sort[]{sort3, sort3}, sort);
                    break;
                }
                logics.isBitVector();
                break;
            }
            case Internal_SMTInterpol: {
                script.setOption(":produce-models", (Object)true);
                script.setOption(":produce-unsat-cores", (Object)true);
                script.setOption(":produce-interpolants", (Object)true);
                script.setOption(":interpolant-check-mode", (Object)true);
                script.setOption(":proof-transformation", (Object)"LU");
                if (logics == null) {
                    throw new AssertionError((Object)"SMTInterpol requires explicit logic");
                }
                script.setLogic(logics);
                break;
            }
            default: {
                throw new AssertionError((Object)"unknown solver");
            }
        }
    }

    public static enum ExternalSolver {
        Z3("z3 -smt2 -in SMTLIB2_COMPLIANT=true", "z3 -smt2 -in SMTLIB2_COMPLIANT=true -t:%d", Logics.ALL),
        CVC4("cvc4 --incremental --print-success --lang smt", "cvc4 --incremental --print-success --lang smt --tlimit-per=%d", Logics.ALL),
        CVC5("cvc5 --incremental --print-success --lang smt", "cvc5 --incremental --print-success --lang smt --tlimit-per=%d", Logics.ALL),
        MATHSAT("mathsat -theory.fp.to_bv_overflow_mode=1 -theory.fp.minmax_zero_mode=4 -theory.bv.div_by_zero_mode=1 -unsat_core_generation=3", null, Logics.ALL),
        MATHSAT_INTERPOLATION("mathsat -theory.fp.to_bv_overflow_mode=1 -theory.fp.minmax_zero_mode=4 -theory.bv.div_by_zero_mode=1 -theory.bv.eager=false -theory.fp.enabled=false", null, Logics.ALL),
        SMTINTERPOL(null, null, Logics.ALL),
        PRINCESS(null, null, null);

        private final String mSolverCommand;
        private final String mSolverCommandTimeoutFormatString;
        private final Logics mDefaultLogic;

        private ExternalSolver(String string2, String string3, Logics logics) {
            this.mSolverCommand = string2;
            this.mSolverCommandTimeoutFormatString = string3;
            this.mDefaultLogic = logics;
        }

        public String getSolverCommand() {
            if (this.mSolverCommand == null) {
                throw new UnsupportedOperationException("Unknown or not implemented solver command: " + String.valueOf((Object)this));
            }
            return this.mSolverCommand;
        }

        public String getSolverCommand(long l) {
            if (l == -1L) {
                return this.getSolverCommand();
            }
            if (l < 0L) {
                throw new IllegalArgumentException("Timeout must be non-negative");
            }
            if (this.mSolverCommandTimeoutFormatString == null) {
                throw new UnsupportedOperationException("Unknown or not implemented solver command with timeouts: " + String.valueOf((Object)this));
            }
            return String.format(this.mSolverCommandTimeoutFormatString, l);
        }

        public Logics getDefaultLogic() {
            return this.mDefaultLogic;
        }
    }

    private static final class SMTInterpolTerminationRequest
    implements TerminationRequest {
        private final IProgressMonitorService mMonitor;

        SMTInterpolTerminationRequest(IProgressMonitorService iProgressMonitorService) {
            this.mMonitor = iProgressMonitorService;
        }

        public boolean isTerminationRequested() {
            return !this.mMonitor.continueProcessing();
        }
    }

    private static final class SelfDestructingSolverStorable
    extends WrapperScript
    implements IStorable {
        private static int sCounter = 0;
        private final int mId = sCounter++;
        private IToolchainStorage mStorage;

        protected SelfDestructingSolverStorable(Script script, IToolchainStorage iToolchainStorage) {
            super(script);
            this.mStorage = iToolchainStorage;
            this.mStorage.putStorable(this.getKey(), (IStorable)this);
        }

        public void destroy() {
            if (this.mStorage != null) {
                super.exit();
                this.removeFromStorage();
            }
        }

        public void exit() {
            super.exit();
            this.removeFromStorage();
        }

        private void removeFromStorage() {
            if (this.mStorage != null) {
                this.mStorage.removeStorable(this.getKey());
                this.mStorage = null;
            }
        }

        private String getKey() {
            return ((Object)((Object)this)).getClass().getSimpleName() + this.mId;
        }
    }

    public static enum SolverMode {
        Internal_SMTInterpol(false),
        External_PrincessInterpolationMode(true),
        External_SMTInterpolInterpolationMode(true),
        External_Z3InterpolationMode(true),
        External_MathsatInterpolationMode(true),
        External_ModelsAndUnsatCoreMode(true),
        External_ModelsMode(true),
        External_DefaultMode(true);

        private final boolean mIsExternal;

        private SolverMode(boolean bl) {
            this.mIsExternal = bl;
        }

        public boolean isExternal() {
            return this.mIsExternal;
        }
    }

    public static final class SolverSettings {
        private final ILogger mSolverLogger;
        private final boolean mFakeNonIncrementalScript;
        private final boolean mUseExternalSolver;
        private final String mExternalSolverCommand;
        private final long mTimeoutSmtInterpol;
        private final ScriptorWithGetInterpolants.ExternalInterpolator mExternalInterpolator;
        private final boolean mDumpSmtScriptToFile;
        private final String mPathOfDumpedScript;
        private final String mBaseNameOfDumpedScript;
        private final boolean mUseDiffWrapper;
        private final boolean mDumpFeatureVector;
        private final String mFeatureVectorDumpPath;
        private final boolean mDumpUnsatCoreTrackBenchmark;
        private final boolean mDumpMainTrackBenchmark;
        private final SolverMode mSolverMode;
        private final Logics mSolverLogics;
        private final boolean mCompressDumpedScript;
        private final Map<String, String> mAdditionalOptions;
        private final boolean mUseMinimalUnsatCoreEnumerationForSmtInterpol;

        private SolverSettings(SolverMode solverMode, boolean bl, boolean bl2, String string, Logics logics, long l, ScriptorWithGetInterpolants.ExternalInterpolator externalInterpolator, boolean bl3, boolean bl4, boolean bl5, String string2, String string3, boolean bl6, boolean bl7, String string4, boolean bl8, Map<String, String> map, ILogger iLogger, boolean bl9) {
            this.mSolverMode = solverMode;
            this.mFakeNonIncrementalScript = bl;
            this.mUseExternalSolver = bl2;
            this.mExternalSolverCommand = string;
            this.mSolverLogics = logics;
            this.mTimeoutSmtInterpol = l;
            this.mExternalInterpolator = externalInterpolator;
            this.mDumpSmtScriptToFile = bl3;
            this.mDumpUnsatCoreTrackBenchmark = bl4;
            this.mDumpMainTrackBenchmark = bl5;
            this.mPathOfDumpedScript = string2;
            this.mBaseNameOfDumpedScript = string3;
            this.mUseDiffWrapper = bl6;
            this.mDumpFeatureVector = bl7;
            this.mFeatureVectorDumpPath = string4;
            this.mCompressDumpedScript = bl8;
            this.mAdditionalOptions = map;
            this.mSolverLogger = iLogger;
            this.mUseMinimalUnsatCoreEnumerationForSmtInterpol = bl9;
        }

        public boolean fakeNonIncrementalScript() {
            return this.mFakeNonIncrementalScript;
        }

        public boolean useExternalSolver() {
            return this.mUseExternalSolver;
        }

        public Map<String, String> getAdditionalOptions() {
            return this.mAdditionalOptions;
        }

        public String getCommandExternalSolver() {
            return this.mExternalSolverCommand;
        }

        public long getTimeoutSmtInterpol() {
            return this.mTimeoutSmtInterpol;
        }

        public ScriptorWithGetInterpolants.ExternalInterpolator getExternalInterpolator() {
            return this.mExternalInterpolator;
        }

        public Logics getSolverLogics() {
            return this.mSolverLogics;
        }

        public boolean dumpSmtScriptToFile() {
            return this.mDumpSmtScriptToFile;
        }

        public boolean compressDumpedScript() {
            return this.mCompressDumpedScript;
        }

        public boolean dumpUnsatCoreTrackBenchmark() {
            return this.mDumpUnsatCoreTrackBenchmark;
        }

        public boolean dumpMainTrackBenchmark() {
            return this.mDumpMainTrackBenchmark;
        }

        public String getPathOfDumpedScript() {
            return this.mPathOfDumpedScript;
        }

        public String getBaseNameOfDumpedScript() {
            return this.mBaseNameOfDumpedScript;
        }

        public boolean useDiffWrapper() {
            return this.mUseDiffWrapper;
        }

        public boolean useMinimalUnsatCoreEnumerationForSmtInterpol() {
            return this.mUseMinimalUnsatCoreEnumerationForSmtInterpol;
        }

        public boolean dumpFeatureExtractionVector() {
            return this.mDumpFeatureVector;
        }

        public String getFeatureVectorDumpPath() {
            return this.mFeatureVectorDumpPath;
        }

        public SolverMode getSolverMode() {
            return this.mSolverMode;
        }

        public ILogger getSolverLogger() {
            return this.mSolverLogger;
        }

        public String constructFullPathOfDumpedScript() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(CoreUtil.addFileSeparator((String)this.getPathOfDumpedScript()));
            stringBuilder.append(this.getBaseNameOfDumpedScript());
            if (this.compressDumpedScript()) {
                stringBuilder.append(".smt2.gz");
            } else {
                stringBuilder.append(".smt2");
            }
            return stringBuilder.toString();
        }

        public SolverSettings setDumpSmtScriptToFile(boolean bl, String string, String string2, boolean bl2) {
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, bl, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, string, string2, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, bl2, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setDumpUnsatCoreTrackBenchmark(boolean bl) {
            assert (!bl || this.mDumpSmtScriptToFile && this.mPathOfDumpedScript != null && this.mBaseNameOfDumpedScript != null);
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, bl, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setDumpMainTrackBenchmark(boolean bl) {
            assert (!bl || this.mDumpSmtScriptToFile && this.mPathOfDumpedScript != null && this.mBaseNameOfDumpedScript != null);
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, bl, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setDumpFeatureVectors(boolean bl, String string) {
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, bl, string, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setSmtInterpolTimeout(long l) {
            if (l < 0L && l != -1L) {
                throw new IllegalArgumentException("Timeout for SMTInterpol must be non-negative or -1 to disable timeout");
            }
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, l, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setUseExternalSolver(boolean bl, String string, Logics logics) {
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, bl, string, logics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setUseExternalSolver(ExternalSolver externalSolver) {
            return this.setUseExternalSolver(true, externalSolver.getSolverCommand(), externalSolver.getDefaultLogic());
        }

        public SolverSettings setUseExternalSolver(ExternalSolver externalSolver, Logics logics, long l) {
            return this.setUseExternalSolver(true, externalSolver.getSolverCommand(l), logics);
        }

        public SolverSettings setUseExternalSolver(ExternalSolver externalSolver, Logics logics) {
            return this.setUseExternalSolver(true, externalSolver.getSolverCommand(), logics);
        }

        public SolverSettings setUseExternalSolver(ExternalSolver externalSolver, long l) {
            return this.setUseExternalSolver(true, externalSolver.getSolverCommand(l), externalSolver.getDefaultLogic());
        }

        public SolverSettings setUseFakeIncrementalScript(boolean bl) {
            return new SolverSettings(this.mSolverMode, bl, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setSolverLogics(Logics logics) {
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, logics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setUseMinimalUnsatCoreEnumerationForSmtInterpol(boolean bl) {
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, bl);
        }

        public SolverSettings setSolverMode(SolverMode solverMode) {
            boolean bl;
            ScriptorWithGetInterpolants.ExternalInterpolator externalInterpolator;
            int n;
            boolean bl2;
            if (solverMode == null) {
                return new SolverSettings(solverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
            }
            return new SolverSettings(solverMode, this.mFakeNonIncrementalScript, bl2, this.mExternalSolverCommand, switch (solverMode) {
                case SolverMode.External_ModelsAndUnsatCoreMode, SolverMode.External_ModelsMode, SolverMode.External_DefaultMode -> {
                    bl2 = true;
                    n = -1;
                    externalInterpolator = null;
                    bl = true;
                    yield this.mSolverLogics;
                }
                case SolverMode.External_PrincessInterpolationMode -> {
                    bl2 = true;
                    n = -1;
                    externalInterpolator = ScriptorWithGetInterpolants.ExternalInterpolator.PRINCESS;
                    bl = true;
                    yield this.mSolverLogics;
                }
                case SolverMode.External_SMTInterpolInterpolationMode -> {
                    bl2 = true;
                    n = -1;
                    externalInterpolator = ScriptorWithGetInterpolants.ExternalInterpolator.SMTINTERPOL;
                    bl = false;
                    yield this.mSolverLogics;
                }
                case SolverMode.External_Z3InterpolationMode -> {
                    bl2 = true;
                    n = -1;
                    externalInterpolator = ScriptorWithGetInterpolants.ExternalInterpolator.IZ3;
                    bl = true;
                    yield this.mSolverLogics;
                }
                case SolverMode.External_MathsatInterpolationMode -> {
                    bl2 = true;
                    n = -1;
                    externalInterpolator = ScriptorWithGetInterpolants.ExternalInterpolator.MATHSAT;
                    bl = true;
                    yield this.mSolverLogics;
                }
                case SolverMode.Internal_SMTInterpol -> {
                    bl2 = false;
                    n = -1;
                    externalInterpolator = null;
                    bl = false;
                    yield ExternalSolver.SMTINTERPOL.getDefaultLogic();
                }
                default -> throw new AssertionError((Object)("unknown solver mode " + String.valueOf((Object)solverMode)));
            }, n, externalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, bl, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setAdditionalOptions(Map<String, String> map) {
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, Objects.requireNonNull(map), this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setSolverLogger(ILogger iLogger) {
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, iLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public String toString() {
            return ReflectionUtil.instanceFieldsToString((Object)this);
        }
    }
}

