/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.ITermProvider;

public final class BooleanValue
extends Enum<BooleanValue>
implements ITermProvider {
    public static final /* enum */ BooleanValue TRUE = new BooleanValue();
    public static final /* enum */ BooleanValue FALSE = new BooleanValue();
    public static final /* enum */ BooleanValue TOP = new BooleanValue();
    public static final /* enum */ BooleanValue BOTTOM = new BooleanValue();
    public static final /* enum */ BooleanValue INVALID = new BooleanValue();
    private static final /* synthetic */ BooleanValue[] ENUM$VALUES;

    static {
        ENUM$VALUES = new BooleanValue[]{TRUE, FALSE, TOP, BOTTOM, INVALID};
    }

    public static BooleanValue getBooleanValue(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static BooleanValue getBooleanValue(String string) {
        return BooleanValue.getBooleanValue(Boolean.parseBoolean(string));
    }

    public boolean isEqualTo(BooleanValue booleanValue) {
        if (booleanValue == null) {
            return false;
        }
        return this == booleanValue;
    }

    public boolean isContainedIn(BooleanValue booleanValue) {
        if (booleanValue == null) {
            return false;
        }
        if (booleanValue == TOP) {
            return true;
        }
        if (booleanValue == this) {
            return true;
        }
        return this == BOTTOM;
    }

    public boolean isBottom() {
        return this == BOTTOM;
    }

    public BooleanValue intersect(BooleanValue booleanValue) {
        assert (booleanValue != null);
        if (this == booleanValue) {
            return this;
        }
        if (this == TOP) {
            return booleanValue;
        }
        if (booleanValue == TOP) {
            return this;
        }
        return BOTTOM;
    }

    public BooleanValue merge(BooleanValue booleanValue) {
        assert (booleanValue != null);
        if (this == BOTTOM && booleanValue == BOTTOM) {
            return this;
        }
        if (this == BOTTOM && booleanValue != BOTTOM) {
            return booleanValue;
        }
        if (this != BOTTOM && booleanValue == BOTTOM) {
            return this;
        }
        if (!this.isEqualTo(booleanValue)) {
            return TOP;
        }
        return this;
    }

    public BooleanValue and(BooleanValue booleanValue) {
        assert (booleanValue != null);
        if (this == BOTTOM || booleanValue == BOTTOM) {
            return BOTTOM;
        }
        if (this == FALSE || booleanValue == FALSE) {
            return FALSE;
        }
        if (this == TRUE && booleanValue == TRUE) {
            return TRUE;
        }
        return TOP;
    }

    public BooleanValue or(BooleanValue booleanValue) {
        assert (booleanValue != null);
        if (this == BOTTOM || booleanValue == BOTTOM) {
            return BOTTOM;
        }
        if (this == TRUE || booleanValue == TRUE) {
            return TRUE;
        }
        if (this == TOP || booleanValue == TOP) {
            return TOP;
        }
        return FALSE;
    }

    public BooleanValue neg() {
        if (this == TRUE) {
            return FALSE;
        }
        if (this == FALSE) {
            return TRUE;
        }
        if (this == TOP) {
            return TOP;
        }
        return BOTTOM;
    }

    @Override
    public Term getTerm(Script script, Sort sort, Term term) {
        assert (sort.equals(term.getSort()));
        switch (this) {
            case BOTTOM: {
                return script.term("false", new Term[0]);
            }
            case TOP: {
                return script.term("true", new Term[0]);
            }
            case FALSE: {
                return SmtUtils.not((Script)script, (Term)term);
            }
            case TRUE: {
                return term;
            }
        }
        throw new UnsupportedOperationException("The boolean value type " + String.valueOf(this) + " is not implemented.");
    }

    public boolean isSingleton() {
        return this == FALSE || this == TRUE;
    }

    public static BooleanValue[] values() {
        BooleanValue[] booleanValueArray = ENUM$VALUES;
        int n = booleanValueArray.length;
        BooleanValue[] booleanValueArray2 = new BooleanValue[n];
        System.arraycopy(ENUM$VALUES, 0, booleanValueArray2, 0, n);
        return booleanValueArray2;
    }

    public static BooleanValue valueOf(String string) {
        return Enum.valueOf(BooleanValue.class, string);
    }
}

