/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.GlobalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.ModifiableNestedFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedFormulas;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashTreeRelation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class RelevantVariables<L extends IAction> {
    private final NestedFormulas<L, UnmodifiableTransFormula, IPredicate> mTraceWithFormulas;
    private final Set<IProgramVar>[] mForwardRelevantVariables;
    private final Set<IProgramVar>[] mBackwardRelevantVariables;
    private final Set<IProgramVar>[] mRelevantVariables;
    private final ModifiableGlobalsTable mModifiableGlobals;
    private final NestedConstraintAnalysis mNestedConstraintAnalysis;
    private final VariableOccurrence mOccurrence;

    public RelevantVariables(NestedFormulas<L, UnmodifiableTransFormula, IPredicate> nestedFormulas, ModifiableGlobalsTable modifiableGlobalsTable) {
        this.mModifiableGlobals = modifiableGlobalsTable;
        this.mTraceWithFormulas = nestedFormulas;
        this.mNestedConstraintAnalysis = new NestedConstraintAnalysis(nestedFormulas.getCounterexample(), new TreeMap<Integer, IPredicate>(), nestedFormulas);
        this.mOccurrence = new VariableOccurrence();
        this.mForwardRelevantVariables = new Set[this.mTraceWithFormulas.getTrace().length() + 1];
        this.computeForwardRelevantVariables();
        this.mBackwardRelevantVariables = new Set[this.mTraceWithFormulas.getTrace().length() + 1];
        this.computeBackwardRelevantVariables();
        this.mRelevantVariables = new Set[this.mTraceWithFormulas.getTrace().length() + 1];
        this.computeRelevantVariables();
    }

    private boolean checkRelevantVariables() {
        boolean bl = true;
        int n = 0;
        while (n < this.mTraceWithFormulas.getTrace().length()) {
            Set<IProgramVar> set = this.mRelevantVariables[n + 1];
            for (IProgramVar iProgramVar : set) {
                assert (bl &= this.mOccurrence.occursBefore(iProgramVar, n)) : "superfluous variable";
                assert (bl &= this.mOccurrence.occursAfter(iProgramVar, n)) : "superfluous variable";
            }
            ++n;
        }
        return bl;
    }

    public Set<IProgramVar>[] getForwardRelevantVariables() {
        return this.mForwardRelevantVariables;
    }

    public Set<IProgramVar>[] getBackwardRelevantVariables() {
        return this.mBackwardRelevantVariables;
    }

    public Set<IProgramVar>[] getRelevantVariables() {
        return this.mRelevantVariables;
    }

    private void computeRelevantVariables() {
        int n = 0;
        while (n <= this.mTraceWithFormulas.getTrace().length()) {
            this.mRelevantVariables[n] = new HashSet<IProgramVar>(this.mForwardRelevantVariables[n]);
            this.mRelevantVariables[n].retainAll(this.mBackwardRelevantVariables[n]);
            ++n;
        }
    }

    private void computeForwardRelevantVariables() {
        assert (this.mForwardRelevantVariables[0] == null) : "already computed";
        this.mForwardRelevantVariables[0] = new HashSet<IProgramVar>(this.mTraceWithFormulas.getPrecondition().getVars());
        int n = 1;
        while (n <= this.mTraceWithFormulas.getTrace().length()) {
            assert (this.mForwardRelevantVariables[n] == null) : "already computed";
            this.mForwardRelevantVariables[n] = this.computeForwardRelevantVariables(n);
            ++n;
        }
    }

    private Set<IProgramVar> computeForwardRelevantVariables(int n) {
        Set<IProgramVar> set;
        Set<IProgramVar> set2 = this.mForwardRelevantVariables[n - 1];
        if (this.mTraceWithFormulas.getTrace().isInternalPosition(n - 1)) {
            UnmodifiableTransFormula unmodifiableTransFormula = this.mTraceWithFormulas.getFormulaFromNonCallPos(n - 1);
            set = this.computeSuccessorRvInternal(set2, unmodifiableTransFormula, n - 1);
        } else if (this.mTraceWithFormulas.getTrace().isCallPosition(n - 1)) {
            UnmodifiableTransFormula unmodifiableTransFormula = this.mTraceWithFormulas.getOldVarAssignment(n - 1);
            UnmodifiableTransFormula unmodifiableTransFormula2 = this.mTraceWithFormulas.getLocalVarAssignment(n - 1);
            UnmodifiableTransFormula unmodifiableTransFormula3 = this.mTraceWithFormulas.getGlobalVarAssignment(n - 1);
            String string = ((IAction)this.mTraceWithFormulas.getTrace().getSymbol(n - 1)).getSucceedingProcedure();
            boolean bl = this.mTraceWithFormulas.getTrace().isPendingCall(n - 1);
            int n2 = this.mTraceWithFormulas.getTrace().getReturnPosition(n - 1);
            set = this.computeSuccessorRvCall(set2, unmodifiableTransFormula2, unmodifiableTransFormula, unmodifiableTransFormula3, bl, string, n - 1, n2);
        } else if (this.mTraceWithFormulas.getTrace().isReturnPosition(n - 1)) {
            int n3 = this.mTraceWithFormulas.getTrace().getCallPosition(n - 1);
            Set<IProgramVar> set3 = this.mForwardRelevantVariables[n3];
            UnmodifiableTransFormula unmodifiableTransFormula = this.mTraceWithFormulas.getFormulaFromNonCallPos(n - 1);
            UnmodifiableTransFormula unmodifiableTransFormula4 = this.mTraceWithFormulas.getLocalVarAssignment(n3);
            String string = ((IAction)this.mTraceWithFormulas.getTrace().getSymbol(n - 1)).getPrecedingProcedure();
            set = this.computeSuccessorRvReturn(set2, set3, unmodifiableTransFormula, unmodifiableTransFormula4, string, n3, n - 1);
        } else {
            throw new AssertionError();
        }
        return set;
    }

    private Set<IProgramVar> computeSuccessorRvInternal(Set<IProgramVar> set, UnmodifiableTransFormula unmodifiableTransFormula, int n) {
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>(set.size());
        HashSet<IProgramVar> hashSet2 = new HashSet<IProgramVar>(set);
        ConstraintAnalysis constraintAnalysis = (ConstraintAnalysis)this.mNestedConstraintAnalysis.getFormulaFromNonCallPos(n);
        hashSet2.removeAll(constraintAnalysis.getUnconstraintOut());
        hashSet2.addAll(constraintAnalysis.getConstraintOut());
        for (IProgramVar iProgramVar : set) {
            if (unmodifiableTransFormula.isHavocedOut(iProgramVar)) continue;
            hashSet.add(iProgramVar);
        }
        for (IProgramVar iProgramVar : unmodifiableTransFormula.getOutVars().keySet()) {
            if (unmodifiableTransFormula.isHavocedOut(iProgramVar)) continue;
            hashSet.add(iProgramVar);
        }
        assert (hashSet.equals(hashSet2)) : "not equal";
        return hashSet;
    }

    private Set<IProgramVar> computeSuccessorRvCall(Set<IProgramVar> set, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, UnmodifiableTransFormula unmodifiableTransFormula3, boolean bl, String string, int n, int n2) {
        assert (!bl || n2 == Integer.MAX_VALUE);
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>(set.size());
        this.addAllNonModifiableGlobals(set, string, hashSet);
        ConstraintAnalysis constraintAnalysis = (ConstraintAnalysis)this.mNestedConstraintAnalysis.getGlobalVarAssignment(n);
        hashSet.addAll(constraintAnalysis.getConstraintOut());
        ConstraintAnalysis constraintAnalysis2 = (ConstraintAnalysis)this.mNestedConstraintAnalysis.getLocalVarAssignment(n);
        hashSet.addAll(constraintAnalysis2.getConstraintOut());
        ConstraintAnalysis constraintAnalysis3 = (ConstraintAnalysis)this.mNestedConstraintAnalysis.getOldVarAssignment(n);
        hashSet.addAll(constraintAnalysis3.getConstraintOut());
        return hashSet;
    }

    private void addAllNonModifiableGlobals(Set<IProgramVar> set, String string, int n, int n2, Set<IProgramVar> set2) {
        for (IProgramVar iProgramVar : set) {
            if (!iProgramVar.isGlobal()) continue;
            if (iProgramVar instanceof IProgramConst) {
                if (!this.occursBetween(iProgramVar, n, n2)) continue;
                set2.add(iProgramVar);
                continue;
            }
            IProgramNonOldVar iProgramNonOldVar = iProgramVar instanceof IProgramOldVar ? ((IProgramOldVar)iProgramVar).getNonOldVar() : (IProgramNonOldVar)iProgramVar;
            if (this.mModifiableGlobals.isModifiable(iProgramNonOldVar, string) || !this.occursBetween((IProgramVar)iProgramNonOldVar, n, n2)) continue;
            set2.add((IProgramVar)iProgramNonOldVar);
        }
    }

    private void addAllNonModifiableGlobals(Set<IProgramVar> set, String string, Set<IProgramVar> set2) {
        for (IProgramVar iProgramVar : set) {
            if (!iProgramVar.isGlobal()) continue;
            if (iProgramVar instanceof IProgramConst) {
                set2.add(iProgramVar);
                continue;
            }
            IProgramNonOldVar iProgramNonOldVar = iProgramVar instanceof IProgramOldVar ? ((IProgramOldVar)iProgramVar).getNonOldVar() : (IProgramNonOldVar)iProgramVar;
            if (this.mModifiableGlobals.isModifiable(iProgramNonOldVar, string)) continue;
            set2.add(iProgramVar);
        }
    }

    private boolean occursBetween(IProgramVar iProgramVar, int n, int n2) {
        return this.mOccurrence.occurs(iProgramVar, n, n2);
    }

    private Set<IProgramVar> computeSuccessorRvReturn(Set<IProgramVar> set, Set<IProgramVar> set2, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, String string, int n, int n2) {
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>(set2);
        ConstraintAnalysis constraintAnalysis = (ConstraintAnalysis)this.mNestedConstraintAnalysis.getLocalVarAssignment(n);
        ConstraintAnalysis constraintAnalysis2 = (ConstraintAnalysis)this.mNestedConstraintAnalysis.getFormulaFromNonCallPos(n2);
        hashSet.addAll(constraintAnalysis.getConstraintIn());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            IProgramVar object2 = (IProgramVar)iterator.next();
            if (!(object2 instanceof IProgramNonOldVar) || !this.mModifiableGlobals.isModifiable((IProgramNonOldVar)object2, string)) continue;
            iterator.remove();
        }
        for (IProgramVar iProgramVar : set) {
            if (!(iProgramVar instanceof IProgramNonOldVar)) continue;
            hashSet.add(iProgramVar);
        }
        hashSet.removeAll(constraintAnalysis2.getUnconstraintOut());
        hashSet.addAll(constraintAnalysis2.getConstraintOut());
        HashSet<IProgramVar> hashSet2 = new HashSet<IProgramVar>();
        for (IProgramVar iProgramVar : set2) {
            if (unmodifiableTransFormula.isHavocedOut(iProgramVar)) continue;
            if (iProgramVar instanceof IProgramNonOldVar) {
                if (this.mModifiableGlobals.isModifiable((IProgramNonOldVar)iProgramVar, string)) continue;
                hashSet2.add(iProgramVar);
                continue;
            }
            hashSet2.add(iProgramVar);
        }
        for (IProgramVar iProgramVar : set) {
            if (!(iProgramVar instanceof IProgramNonOldVar) || unmodifiableTransFormula.isHavocedOut(iProgramVar)) continue;
            hashSet2.add(iProgramVar);
        }
        for (IProgramVar iProgramVar : unmodifiableTransFormula.getOutVars().keySet()) {
            if (unmodifiableTransFormula.isHavocedOut(iProgramVar)) continue;
            hashSet2.add(iProgramVar);
        }
        for (IProgramVar iProgramVar : unmodifiableTransFormula2.getInVars().keySet()) {
            if (unmodifiableTransFormula.isHavocedOut(iProgramVar)) continue;
            hashSet2.add(iProgramVar);
        }
        assert (hashSet.equals(hashSet2)) : "new rsult ist differtn";
        return hashSet;
    }

    private void computeBackwardRelevantVariables() {
        assert (this.mBackwardRelevantVariables[this.mTraceWithFormulas.getTrace().length()] == null) : "already computed";
        this.mBackwardRelevantVariables[this.mTraceWithFormulas.getTrace().length()] = new HashSet<IProgramVar>(this.mTraceWithFormulas.getPostcondition().getVars());
        int n = this.mTraceWithFormulas.getTrace().length() - 1;
        while (n >= 0) {
            assert (this.mBackwardRelevantVariables[n] == null) : "already computed";
            this.mBackwardRelevantVariables[n] = this.computeBackwardRelevantVariables(n);
            --n;
        }
    }

    private Set<IProgramVar> computeBackwardRelevantVariables(int n) {
        Set<IProgramVar> set;
        Set<IProgramVar> set2 = this.mBackwardRelevantVariables[n + 1];
        if (this.mTraceWithFormulas.getTrace().isInternalPosition(n)) {
            UnmodifiableTransFormula unmodifiableTransFormula = this.mTraceWithFormulas.getFormulaFromNonCallPos(n);
            set = this.computePredecessorRvInternal(set2, unmodifiableTransFormula, n);
        } else if (this.mTraceWithFormulas.getTrace().isCallPosition(n)) {
            UnmodifiableTransFormula unmodifiableTransFormula = this.mTraceWithFormulas.getLocalVarAssignment(n);
            UnmodifiableTransFormula unmodifiableTransFormula2 = this.mTraceWithFormulas.getOldVarAssignment(n);
            UnmodifiableTransFormula unmodifiableTransFormula3 = this.mTraceWithFormulas.getGlobalVarAssignment(n);
            String string = ((IAction)this.mTraceWithFormulas.getTrace().getSymbol(n)).getSucceedingProcedure();
            if (this.mTraceWithFormulas.getTrace().isPendingCall(n)) {
                set = this.computePredecessorRvCall_Pending(set2, unmodifiableTransFormula, unmodifiableTransFormula2, unmodifiableTransFormula3, string, n);
            } else {
                int n2 = this.mTraceWithFormulas.getTrace().getReturnPosition(n);
                Set<IProgramVar> set3 = this.mBackwardRelevantVariables[n2 + 1];
                UnmodifiableTransFormula unmodifiableTransFormula4 = this.mTraceWithFormulas.getFormulaFromNonCallPos(n2);
                set = this.computePredecessorRvCall_NonPending(set2, set3, unmodifiableTransFormula, unmodifiableTransFormula4, unmodifiableTransFormula2, unmodifiableTransFormula3, string, n, n2);
                this.addNonModifiableGlobalsAlongCalledProcedure(set, n);
            }
        } else if (this.mTraceWithFormulas.getTrace().isReturnPosition(n)) {
            int n3 = this.mTraceWithFormulas.getTrace().getCallPosition(n);
            UnmodifiableTransFormula unmodifiableTransFormula = this.mTraceWithFormulas.getOldVarAssignment(n3);
            UnmodifiableTransFormula unmodifiableTransFormula5 = this.mTraceWithFormulas.getLocalVarAssignment(n3);
            UnmodifiableTransFormula unmodifiableTransFormula6 = this.mTraceWithFormulas.getFormulaFromNonCallPos(n);
            String string = ((IAction)this.mTraceWithFormulas.getTrace().getSymbol(n)).getPrecedingProcedure();
            set = this.computePredecessorRvReturn(set2, unmodifiableTransFormula6, unmodifiableTransFormula, unmodifiableTransFormula5, string, n3, n);
        } else {
            throw new AssertionError();
        }
        return set;
    }

    private void addNonModifiableGlobalsAlongCalledProcedure(Set<IProgramVar> set, int n) {
        assert (this.mTraceWithFormulas.getTrace().isCallPosition(n));
        assert (!this.mTraceWithFormulas.getTrace().isPendingCall(n));
        Set set2 = this.mTraceWithFormulas.getGlobalVarAssignment(n).getOutVars().keySet();
        Set set3 = this.mTraceWithFormulas.getOldVarAssignment(n).getOutVars().keySet();
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        for (IProgramVar iProgramVar : set) {
            if (!iProgramVar.isGlobal()) continue;
            if (iProgramVar.isOldvar()) {
                if (set3.contains(iProgramVar)) continue;
                hashSet.add(iProgramVar);
                continue;
            }
            if (set2.contains(iProgramVar)) continue;
            hashSet.add(iProgramVar);
        }
        if (!hashSet.isEmpty()) {
            int n2 = this.mTraceWithFormulas.getTrace().getReturnPosition(n);
            int n3 = n + 1;
            while (n3 <= n2) {
                this.mBackwardRelevantVariables[n3].addAll(hashSet);
                ++n3;
            }
        }
    }

    private Set<IProgramVar> computePredecessorRvInternal(Set<IProgramVar> set, UnmodifiableTransFormula unmodifiableTransFormula, int n) {
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>(set);
        ConstraintAnalysis constraintAnalysis = (ConstraintAnalysis)this.mNestedConstraintAnalysis.getFormulaFromNonCallPos(n);
        hashSet.removeAll(constraintAnalysis.getUnconstraintIn());
        hashSet.addAll(constraintAnalysis.getConstraintIn());
        HashSet<IProgramVar> hashSet2 = new HashSet<IProgramVar>(set.size());
        for (IProgramVar iProgramVar : set) {
            if (unmodifiableTransFormula.isHavocedIn(iProgramVar)) continue;
            hashSet2.add(iProgramVar);
        }
        for (IProgramVar iProgramVar : unmodifiableTransFormula.getInVars().keySet()) {
            if (unmodifiableTransFormula.isHavocedIn(iProgramVar)) continue;
            hashSet2.add(iProgramVar);
        }
        assert (hashSet2.equals(hashSet)) : "notEqual";
        return hashSet2;
    }

    private Set<IProgramVar> computePredecessorRvCall_NonPending(Set<IProgramVar> set, Set<IProgramVar> set2, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, UnmodifiableTransFormula unmodifiableTransFormula3, UnmodifiableTransFormula unmodifiableTransFormula4, String string, int n, int n2) {
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>(set2);
        hashSet.removeAll(unmodifiableTransFormula2.getOutVars().keySet());
        ConstraintAnalysis constraintAnalysis = (ConstraintAnalysis)this.mNestedConstraintAnalysis.getGlobalVarAssignment(n);
        hashSet.removeAll(constraintAnalysis.getUnconstraintOut());
        this.addAllNonModifiableGlobals(set, string, hashSet);
        ConstraintAnalysis constraintAnalysis2 = (ConstraintAnalysis)this.mNestedConstraintAnalysis.getLocalVarAssignment(n);
        hashSet.addAll(constraintAnalysis2.getConstraintIn());
        ConstraintAnalysis constraintAnalysis3 = (ConstraintAnalysis)this.mNestedConstraintAnalysis.getOldVarAssignment(n);
        hashSet.addAll(constraintAnalysis3.getConstraintIn());
        HashSet<IProgramVar> hashSet2 = new HashSet<IProgramVar>();
        for (IProgramVar iProgramVar : set2) {
            if (unmodifiableTransFormula2.getOutVars().containsKey(iProgramVar) || unmodifiableTransFormula4.getAssignedVars().contains(iProgramVar)) continue;
            hashSet2.add(iProgramVar);
        }
        hashSet2.addAll(unmodifiableTransFormula.getInVars().keySet());
        this.addAllNonModifiableGlobals(set, string, hashSet2);
        hashSet2.addAll(unmodifiableTransFormula3.getInVars().keySet());
        assert (hashSet2.equals(hashSet)) : "inconsistent result of live variables analysis";
        return hashSet;
    }

    private Set<IProgramVar> computePredecessorRvCall_Pending(Set<IProgramVar> set, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, UnmodifiableTransFormula unmodifiableTransFormula3, String string, int n) {
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        ConstraintAnalysis constraintAnalysis = (ConstraintAnalysis)this.mNestedConstraintAnalysis.getOldVarAssignment(n);
        ConstraintAnalysis constraintAnalysis2 = (ConstraintAnalysis)this.mNestedConstraintAnalysis.getGlobalVarAssignment(n);
        for (IProgramVar object2 : set) {
            if (object2 instanceof IProgramNonOldVar) {
                if (constraintAnalysis2.getUnconstraintOut().contains(object2)) continue;
                hashSet.add(object2);
                continue;
            }
            if (!(object2 instanceof IProgramOldVar) || constraintAnalysis.getUnconstraintOut().contains(object2)) continue;
            IProgramNonOldVar iProgramNonOldVar = ((IProgramOldVar)object2).getNonOldVar();
            hashSet.add((IProgramVar)iProgramNonOldVar);
        }
        ConstraintAnalysis constraintAnalysis3 = (ConstraintAnalysis)this.mNestedConstraintAnalysis.getLocalVarAssignment(n);
        hashSet.addAll(constraintAnalysis3.getConstraintIn());
        HashSet hashSet2 = new HashSet(unmodifiableTransFormula.getInVars().keySet());
        for (IProgramVar iProgramVar : set) {
            if (!(iProgramVar instanceof IProgramNonOldVar) || RelevantVariables.isHavoced(unmodifiableTransFormula3, unmodifiableTransFormula2, iProgramVar)) continue;
            hashSet2.add(iProgramVar);
        }
        assert (hashSet2.equals(hashSet)) : "notEqual";
        return hashSet;
    }

    private Set<IProgramVar> computePredecessorRvReturn(Set<IProgramVar> set, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, UnmodifiableTransFormula unmodifiableTransFormula3, String string, int n, int n2) {
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        for (IProgramVar object2 : set) {
            if (!(object2 instanceof IProgramNonOldVar)) continue;
            hashSet.add(object2);
        }
        hashSet.removeAll(unmodifiableTransFormula.getOutVars().keySet());
        ConstraintAnalysis constraintAnalysis = (ConstraintAnalysis)this.mNestedConstraintAnalysis.getLocalVarAssignment(n);
        hashSet.addAll(constraintAnalysis.getConstraintOut());
        ConstraintAnalysis constraintAnalysis2 = (ConstraintAnalysis)this.mNestedConstraintAnalysis.getFormulaFromNonCallPos(n2);
        hashSet.addAll(constraintAnalysis2.getConstraintIn());
        ConstraintAnalysis constraintAnalysis3 = (ConstraintAnalysis)this.mNestedConstraintAnalysis.getOldVarAssignment(n);
        hashSet.addAll(constraintAnalysis3.getConstraintOut());
        HashSet<IProgramVar> hashSet2 = new HashSet<IProgramVar>(set.size());
        for (IProgramVar iProgramVar : set) {
            if (!(iProgramVar instanceof IProgramNonOldVar) || unmodifiableTransFormula.isHavocedIn(iProgramVar)) continue;
            hashSet2.add(iProgramVar);
        }
        for (IProgramVar iProgramVar : unmodifiableTransFormula.getInVars().keySet()) {
            if (unmodifiableTransFormula.isHavocedIn(iProgramVar)) continue;
            hashSet2.add(iProgramVar);
        }
        for (IProgramVar iProgramVar : unmodifiableTransFormula2.getInVars().keySet()) {
            if (unmodifiableTransFormula2.isHavocedIn(iProgramVar)) continue;
            hashSet2.add(iProgramVar);
        }
        for (IProgramVar iProgramVar : unmodifiableTransFormula2.getOutVars().keySet()) {
            if (unmodifiableTransFormula2.isHavocedOut(iProgramVar)) continue;
            hashSet2.add(iProgramVar);
        }
        for (IProgramVar iProgramVar : unmodifiableTransFormula3.getOutVars().keySet()) {
            if (unmodifiableTransFormula3.isHavocedOut(iProgramVar)) continue;
            hashSet2.add(iProgramVar);
        }
        assert (hashSet2.equals(hashSet)) : "notEqual";
        return hashSet;
    }

    private static boolean isHavoced(UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, IProgramVar iProgramVar) {
        if (iProgramVar instanceof GlobalProgramVar) {
            boolean bl;
            if (iProgramVar instanceof IProgramOldVar) {
                bl = unmodifiableTransFormula2.isHavocedOut(iProgramVar);
            } else {
                assert (iProgramVar instanceof IProgramNonOldVar);
                bl = unmodifiableTransFormula.isHavocedOut(iProgramVar);
            }
            return bl;
        }
        return false;
    }

    private static class ConstraintAnalysis {
        private final UnmodifiableTransFormula mTransFormula;
        private final Set<IProgramVar> mConstraintIn = new HashSet<IProgramVar>();
        private final Set<IProgramVar> mUnconstraintIn = new HashSet<IProgramVar>();
        private final Set<IProgramVar> mConstraintOut = new HashSet<IProgramVar>();
        private final Set<IProgramVar> mUnconstraintOut = new HashSet<IProgramVar>();
        private final Set<TermVariable> mFreeVars;

        public ConstraintAnalysis(UnmodifiableTransFormula unmodifiableTransFormula) {
            this.mTransFormula = unmodifiableTransFormula;
            this.mFreeVars = new HashSet<TermVariable>(Arrays.asList(unmodifiableTransFormula.getFormula().getFreeVars()));
            this.analyze();
        }

        public Set<IProgramVar> getConstraintIn() {
            return this.mConstraintIn;
        }

        public Set<IProgramVar> getUnconstraintIn() {
            return this.mUnconstraintIn;
        }

        public Set<IProgramVar> getConstraintOut() {
            return this.mConstraintOut;
        }

        public Set<IProgramVar> getUnconstraintOut() {
            return this.mUnconstraintOut;
        }

        private void analyze() {
            TermVariable termVariable;
            TermVariable termVariable2;
            for (IProgramVar iProgramVar : this.mTransFormula.getInVars().keySet()) {
                termVariable2 = (TermVariable)this.mTransFormula.getInVars().get(iProgramVar);
                termVariable = (TermVariable)this.mTransFormula.getOutVars().get(iProgramVar);
                if (termVariable == null) {
                    this.mUnconstraintOut.add(iProgramVar);
                }
                if (this.mFreeVars.contains(termVariable2)) {
                    this.mConstraintIn.add(iProgramVar);
                    continue;
                }
                if (termVariable2 == termVariable) continue;
                this.mUnconstraintIn.add(iProgramVar);
            }
            for (IProgramVar iProgramVar : this.mTransFormula.getOutVars().keySet()) {
                termVariable2 = (TermVariable)this.mTransFormula.getInVars().get(iProgramVar);
                termVariable = (TermVariable)this.mTransFormula.getOutVars().get(iProgramVar);
                if (termVariable2 == null) {
                    this.mUnconstraintIn.add(iProgramVar);
                }
                if (this.mFreeVars.contains(termVariable)) {
                    this.mConstraintOut.add(iProgramVar);
                    continue;
                }
                if (termVariable2 == termVariable) continue;
                this.mUnconstraintOut.add(iProgramVar);
            }
        }

        public String toString() {
            return "ConstraintAnalysis [mConstraintIn=" + String.valueOf(this.mConstraintIn) + ", mUnconstraintIn=" + String.valueOf(this.mUnconstraintIn) + ", mConstraintOut=" + String.valueOf(this.mConstraintOut) + ", mUnconstraintOut=" + String.valueOf(this.mUnconstraintOut) + "]";
        }
    }

    private class NestedConstraintAnalysis
    extends ModifiableNestedFormulas<L, ConstraintAnalysis, IPredicate> {
        public NestedConstraintAnalysis(Counterexample<L> counterexample, SortedMap<Integer, IPredicate> sortedMap, NestedFormulas<L, UnmodifiableTransFormula, IPredicate> nestedFormulas) {
            super(counterexample, sortedMap);
            int n = 0;
            while (n < counterexample.length()) {
                if (this.getTrace().isCallPosition(n)) {
                    var6_6 = nestedFormulas.getGlobalVarAssignment(n);
                    this.setGlobalVarAssignmentAtPos(n, new ConstraintAnalysis(var6_6));
                    UnmodifiableTransFormula unmodifiableTransFormula = nestedFormulas.getOldVarAssignment(n);
                    this.setOldVarAssignmentAtPos(n, new ConstraintAnalysis(unmodifiableTransFormula));
                    UnmodifiableTransFormula unmodifiableTransFormula2 = nestedFormulas.getLocalVarAssignment(n);
                    this.setLocalVarAssignmentAtPos(n, new ConstraintAnalysis(unmodifiableTransFormula2));
                } else {
                    var6_6 = nestedFormulas.getFormulaFromNonCallPos(n);
                    this.setFormulaAtNonCallPos(n, new ConstraintAnalysis(var6_6));
                }
                ++n;
            }
        }
    }

    private class VariableOccurrence {
        HashTreeRelation<IProgramVar, Integer> inRelation = new HashTreeRelation();
        HashTreeRelation<IProgramVar, Integer> outRelation = new HashTreeRelation();

        public VariableOccurrence() {
            this.computeOccurrenceRelations();
        }

        public boolean containsNumberBetween(int n, int n2, TreeSet<Integer> treeSet) {
            Integer n3 = treeSet.ceiling(n);
            if (n3 == null) {
                return false;
            }
            return n3 <= n2;
        }

        public boolean occurs(IProgramVar iProgramVar, int n, int n2) {
            TreeSet treeSet;
            boolean bl = false;
            TreeSet treeSet2 = this.inRelation.getImage((Object)iProgramVar);
            if (treeSet2 != null) {
                boolean bl2 = bl = bl || this.containsNumberBetween(n + 1, n2, treeSet2);
                if (bl) {
                    return bl;
                }
            }
            if ((treeSet = this.outRelation.getImage((Object)iProgramVar)) != null) {
                bl = bl || this.containsNumberBetween(n, n2 - 1, treeSet);
            }
            return bl;
        }

        public boolean occursAfter(IProgramVar iProgramVar, int n) {
            TreeSet treeSet;
            boolean bl = false;
            TreeSet treeSet2 = this.inRelation.getImage((Object)iProgramVar);
            if (treeSet2 != null) {
                boolean bl2 = bl = bl || treeSet2.ceiling(n + 1) != null;
                if (bl) {
                    return bl;
                }
            }
            if ((treeSet = this.outRelation.getImage((Object)iProgramVar)) != null) {
                bl = bl || treeSet.ceiling(n) != null;
            }
            return bl;
        }

        public boolean occursBefore(IProgramVar iProgramVar, int n) {
            TreeSet treeSet;
            boolean bl = false;
            TreeSet treeSet2 = this.inRelation.getImage((Object)iProgramVar);
            if (treeSet2 != null) {
                boolean bl2 = bl = bl || treeSet2.floor(n) != null;
                if (bl) {
                    return bl;
                }
            }
            if ((treeSet = this.outRelation.getImage((Object)iProgramVar)) != null) {
                bl = bl || treeSet.ceiling(n - 1) != null;
            }
            return bl;
        }

        private void computeOccurrenceRelations() {
            this.addVars(this.outRelation, -1, RelevantVariables.this.mTraceWithFormulas.getPrecondition());
            this.addVars(this.inRelation, RelevantVariables.this.mTraceWithFormulas.getTrace().length(), RelevantVariables.this.mTraceWithFormulas.getPostcondition());
            int n = 0;
            while (n < RelevantVariables.this.mTraceWithFormulas.getTrace().length()) {
                if (RelevantVariables.this.mTraceWithFormulas.getTrace().isInternalPosition(n)) {
                    ConstraintAnalysis constraintAnalysis = (ConstraintAnalysis)RelevantVariables.this.mNestedConstraintAnalysis.getFormulaFromNonCallPos(n);
                    this.addVars(this.inRelation, n, constraintAnalysis.getConstraintIn());
                    this.addVars(this.outRelation, n, constraintAnalysis.getConstraintOut());
                } else if (RelevantVariables.this.mTraceWithFormulas.getTrace().isCallPosition(n)) {
                    ConstraintAnalysis constraintAnalysis = (ConstraintAnalysis)RelevantVariables.this.mNestedConstraintAnalysis.getLocalVarAssignment(n);
                    var3_5 = (ConstraintAnalysis)RelevantVariables.this.mNestedConstraintAnalysis.getOldVarAssignment(n);
                    var4_6 = (ConstraintAnalysis)RelevantVariables.this.mNestedConstraintAnalysis.getGlobalVarAssignment(n);
                    this.addVars(this.inRelation, n, constraintAnalysis.getConstraintIn());
                    this.addVars(this.inRelation, n, var3_5.getConstraintIn());
                    this.addVars(this.outRelation, n, var4_6.getConstraintOut());
                    if (RelevantVariables.this.mTraceWithFormulas.getTrace().isPendingCall(n)) {
                        this.addVars(this.inRelation, n, var3_5.getConstraintIn());
                        this.addVars(this.outRelation, n, constraintAnalysis.getConstraintOut());
                    }
                } else if (RelevantVariables.this.mTraceWithFormulas.getTrace().isReturnPosition(n)) {
                    int n2 = RelevantVariables.this.mNestedConstraintAnalysis.getTrace().getCallPosition(n);
                    var3_5 = (ConstraintAnalysis)RelevantVariables.this.mNestedConstraintAnalysis.getOldVarAssignment(n2);
                    var4_6 = (ConstraintAnalysis)RelevantVariables.this.mNestedConstraintAnalysis.getLocalVarAssignment(n2);
                    ConstraintAnalysis constraintAnalysis = (ConstraintAnalysis)RelevantVariables.this.mNestedConstraintAnalysis.getFormulaFromNonCallPos(n);
                    this.addVars(this.inRelation, n, var4_6.getConstraintOut());
                    this.addVars(this.inRelation, n, var3_5.getConstraintOut());
                    this.addVars(this.inRelation, n, constraintAnalysis.getConstraintIn());
                    this.addVars(this.outRelation, n, constraintAnalysis.getConstraintOut());
                } else {
                    throw new AssertionError();
                }
                ++n;
            }
        }

        private void addVars(HashTreeRelation<IProgramVar, Integer> hashTreeRelation, int n, IPredicate iPredicate) {
            for (IProgramVar iProgramVar : iPredicate.getVars()) {
                hashTreeRelation.addPair((Object)iProgramVar, (Object)n);
            }
        }

        private void addVars(HashTreeRelation<IProgramVar, Integer> hashTreeRelation, int n, Set<IProgramVar> set) {
            for (IProgramVar iProgramVar : set) {
                hashTreeRelation.addPair((Object)iProgramVar, (Object)n);
            }
        }
    }
}

