/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;

public final class GetHandle<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private NestedRun<LETTER, STATE> mHandle;
    private final NoHandleReason mNoHandleReason;

    public GetHandle(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNestedWordAutomaton;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        if (this.mOperand.getInitialStates().size() != 1) {
            this.mNoHandleReason = NoHandleReason.MULTI_INITIAL;
        } else {
            Object e = this.mOperand.getInitialStates().iterator().next();
            this.mHandle = this.getSingleSuccessor(e);
            this.mNoHandleReason = this.mHandle == null ? NoHandleReason.MULTI_INIT_SUCC : this.aa();
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    private NoHandleReason aa() {
        do {
            STATE STATE = this.mHandle.getStateAtPosition(this.mHandle.getLength() - 2);
            STATE STATE2 = this.mHandle.getStateAtPosition(this.mHandle.getLength() - 1);
            boolean bl = this.hasSinglePredecessor(STATE2, STATE);
            if (!bl) {
                return null;
            }
            NestedRun<LETTER, STATE> nestedRun = this.getSingleSuccessor(STATE2);
            if (nestedRun == null) {
                return null;
            }
            this.mHandle = this.mHandle.concatenate(nestedRun);
        } while (this.mHandle.getLength() <= this.mOperand.size());
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)"automaton has cycle shape");
        }
        this.mHandle = null;
        return NoHandleReason.CYCLE_SHAPE;
    }

    public NestedRun<LETTER, STATE> getSingleSuccessor(STATE STATE) {
        NestedRun nestedRun = null;
        for (OutgoingInternalTransition iOutgoingTransitionlet : this.mOperand.internalSuccessors(STATE)) {
            if (nestedRun == null) {
                nestedRun = new NestedRun(STATE, iOutgoingTransitionlet.getLetter(), -2, iOutgoingTransitionlet.getSucc());
                continue;
            }
            return null;
        }
        for (OutgoingCallTransition outgoingCallTransition : this.mOperand.callSuccessors(STATE)) {
            if (nestedRun == null) {
                nestedRun = new NestedRun(STATE, outgoingCallTransition.getLetter(), Integer.MAX_VALUE, outgoingCallTransition.getSucc());
                continue;
            }
            return null;
        }
        for (OutgoingReturnTransition outgoingReturnTransition : this.mOperand.returnSuccessors(STATE)) {
            if (nestedRun == null) {
                nestedRun = new NestedRun(STATE, outgoingReturnTransition.getLetter(), Integer.MIN_VALUE, outgoingReturnTransition.getSucc());
                continue;
            }
            return null;
        }
        return nestedRun;
    }

    public boolean hasSinglePredecessor(STATE STATE, STATE STATE2) {
        Object var3_3 = null;
        for (IncomingInternalTransition<LETTER, STATE> iTransitionlet : this.mOperand.internalPredecessors(STATE)) {
            if (var3_3 == null) {
                var3_3 = iTransitionlet.getPred();
                continue;
            }
            return false;
        }
        for (IncomingCallTransition incomingCallTransition : this.mOperand.callPredecessors(STATE)) {
            if (var3_3 == null) {
                var3_3 = incomingCallTransition.getPred();
                continue;
            }
            return false;
        }
        for (IncomingReturnTransition incomingReturnTransition : this.mOperand.returnPredecessors(STATE)) {
            if (var3_3 == null) {
                var3_3 = incomingReturnTransition.getLinPred();
                continue;
            }
            return false;
        }
        if (var3_3 == null) {
            return false;
        }
        assert (var3_3 == STATE2) : "wrong state";
        return true;
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public NestedRun<LETTER, STATE> getResult() {
        return this.mHandle;
    }

    @Override
    public String exitMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Finished ").append(this.getOperationName());
        if (this.mHandle == null) {
            stringBuilder.append(". Automaton has no handle. Reason: ").append((Object)this.mNoHandleReason);
        } else {
            stringBuilder.append(". Found word of length ").append(this.mHandle.getLength());
        }
        return stringBuilder.toString();
    }

    private static enum NoHandleReason {
        MULTI_INITIAL,
        CYCLE_SHAPE,
        MULTI_INIT_SUCC;

    }
}

