/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.Options;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.BuchiNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.IBuchiNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.IStateNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.DoubleDecker;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.IBuchiNwaComplement;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.NCSB;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.StateNwaNCSB;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntIterator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntSet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.UtilIntSet;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class BuchiNwaComplement
extends BuchiNwa
implements IBuchiNwaComplement {
    private final IBuchiNwa mOperand;
    private final TObjectIntMap<DoubleDecker> mDeckerMap;
    private final List<DoubleDecker> mDeckerList;
    private final TObjectIntMap<StateNwaNCSB> mStateIndices = new TObjectIntHashMap();
    private final IntSet mFinalDeckers;
    private boolean mExplored = false;

    public BuchiNwaComplement(IBuchiNwa iBuchiNwa) {
        super(iBuchiNwa.getAlphabetCall(), iBuchiNwa.getAlphabetInternal(), iBuchiNwa.getAlphabetReturn());
        this.mOperand = iBuchiNwa;
        this.mDeckerMap = new TObjectIntHashMap();
        this.mDeckerList = new ArrayList<DoubleDecker>();
        this.mFinalDeckers = UtilIntSet.newIntSet();
        this.computeInitialStates();
    }

    private void computeInitialStates() {
        IntSet intSet = this.mOperand.getInitialStates().clone();
        intSet.and(this.mOperand.getFinalStates());
        IntSet intSet2 = this.mOperand.getInitialStates().clone();
        intSet2.andNot(intSet);
        IntSet intSet3 = this.generateDeckers(-1, intSet2);
        IntSet intSet4 = this.generateDeckers(-1, intSet);
        NCSB nCSB = new NCSB(intSet3, intSet4, UtilIntSet.newIntSet(), intSet4);
        StateNwaNCSB stateNwaNCSB = new StateNwaNCSB(this, 0, nCSB);
        if (intSet4.isEmpty()) {
            this.setFinal(0);
        }
        this.setInitial(0);
        int n = this.addState(stateNwaNCSB);
        this.mStateIndices.put((Object)stateNwaNCSB, n);
    }

    protected StateNwaNCSB addState(NCSB nCSB) {
        StateNwaNCSB stateNwaNCSB = new StateNwaNCSB(this, 0, nCSB);
        if (this.mStateIndices.containsKey((Object)stateNwaNCSB)) {
            return (StateNwaNCSB)this.getState(this.mStateIndices.get((Object)stateNwaNCSB));
        }
        int n = this.getStateSize();
        StateNwaNCSB stateNwaNCSB2 = new StateNwaNCSB(this, n, nCSB);
        int n2 = this.addState(stateNwaNCSB2);
        this.mStateIndices.put((Object)stateNwaNCSB2, n2);
        if (nCSB.getBSet().isEmpty()) {
            this.setFinal(n);
        }
        return stateNwaNCSB2;
    }

    @Override
    public IBuchiNwa getOperand() {
        return this.mOperand;
    }

    @Override
    public DoubleDecker getDoubleDecker(int n) {
        assert (n < this.mDeckerList.size());
        return this.mDeckerList.get(n);
    }

    @Override
    public int getDoubleDeckerId(DoubleDecker doubleDecker) {
        if (this.mDeckerMap.containsKey((Object)doubleDecker)) {
            return this.mDeckerMap.get((Object)doubleDecker);
        }
        int n = this.mDeckerList.size();
        this.mDeckerList.add(doubleDecker);
        this.mDeckerMap.put((Object)doubleDecker, n);
        if (this.mOperand.isFinal(doubleDecker.getUpState())) {
            this.mFinalDeckers.set(n);
        }
        return n;
    }

    protected IntSet getFinalDeckers() {
        return this.mFinalDeckers;
    }

    protected IntSet generateDeckers(int n, IntSet intSet) {
        IntSet intSet2 = UtilIntSet.newIntSet();
        for (int n2 : intSet.iterable()) {
            intSet2.set(this.getDoubleDeckerId(new DoubleDecker(n, n2)));
        }
        return intSet2;
    }

    public int getUpState(int n) {
        return this.getDoubleDecker(n).getUpState();
    }

    public int getDownState(int n) {
        return this.getDoubleDecker(n).getDownState();
    }

    public void explore() {
        if (this.mExplored) {
            return;
        }
        this.mExplored = true;
        LinkedList<IStateNwa> linkedList = new LinkedList<IStateNwa>();
        IntSet intSet = this.getInitialStates();
        IntIterator intIterator = intSet.iterator();
        while (intIterator.hasNext()) {
            linkedList.addFirst(this.getState(intIterator.next()));
        }
        BitSet bitSet = new BitSet();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        while (!linkedList.isEmpty()) {
            IntSet intSet2;
            int n;
            IStateNwa iStateNwa = (IStateNwa)linkedList.remove();
            if (bitSet.get(iStateNwa.getId())) continue;
            bitSet.set(iStateNwa.getId());
            if (Options.verbose) {
                System.out.println("s" + iStateNwa.getId() + ": " + iStateNwa.toString());
            }
            IntSet intSet3 = this.mOperand.getAlphabetCall();
            IntIterator intIterator2 = intSet3.iterator();
            while (intIterator2.hasNext()) {
                n = intIterator2.next();
                intSet2 = iStateNwa.getSuccessorsCall(n);
                if (!intSet2.isEmpty()) {
                    hashSet.add(iStateNwa.getId());
                }
                this.exploreSuccessors(iStateNwa, linkedList, intSet2, bitSet, n);
            }
            intIterator2 = this.mOperand.getAlphabetInternal().iterator();
            while (intIterator2.hasNext()) {
                n = intIterator2.next();
                if (iStateNwa.getId() == 6 && n == 4) {
                    System.out.println("HAHA");
                }
                intSet2 = iStateNwa.getSuccessorsInternal(n);
                this.exploreSuccessors(iStateNwa, linkedList, intSet2, bitSet, n);
            }
            intIterator2 = this.mOperand.getAlphabetReturn().iterator();
            while (intIterator2.hasNext()) {
                n = intIterator2.next();
                int n2 = this.getStateSize();
                int n3 = 0;
                while (n3 < n2) {
                    for (Integer n4 : hashSet) {
                        IStateNwa iStateNwa2 = this.getState(n3);
                        if (Options.verbose) {
                            System.out.println("current: " + iStateNwa2.toString() + "  hier: " + String.valueOf(n4) + " :" + this.getState(n4).toString());
                        }
                        IntSet intSet4 = iStateNwa2.getSuccessorsReturn(n4, n);
                        this.exploreSuccessors(iStateNwa2, linkedList, intSet4, bitSet, n);
                    }
                    ++n3;
                }
            }
        }
    }

    private void exploreSuccessors(IStateNwa iStateNwa, LinkedList<IStateNwa> linkedList, IntSet intSet, BitSet bitSet, int n) {
        IntIterator intIterator = intSet.iterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            if (Options.verbose) {
                System.out.println(" s" + iStateNwa.getId() + ": " + iStateNwa.toString() + "- L" + n + " -> s" + n2 + ": " + String.valueOf(this.getState(n2)));
            }
            if (bitSet.get(n2)) continue;
            linkedList.addFirst(this.getState(n2));
        }
    }
}

