/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SmtSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IOperationTranslator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;

public class DefaultOperationTranslator
implements IOperationTranslator {
    protected final Boogie2SmtSymbolTable mBoogie2SmtSymbolTable;
    protected final Script mScript;

    public DefaultOperationTranslator(Boogie2SmtSymbolTable boogie2SmtSymbolTable, Script script) {
        this.mBoogie2SmtSymbolTable = boogie2SmtSymbolTable;
        this.mScript = script;
    }

    @Override
    public String opTranslation(BinaryExpression.Operator operator, IBoogieType iBoogieType, IBoogieType iBoogieType2) {
        if (operator == BinaryExpression.Operator.COMPEQ) {
            return "=";
        }
        if (operator == BinaryExpression.Operator.COMPGEQ) {
            return ">=";
        }
        if (operator == BinaryExpression.Operator.COMPGT) {
            return ">";
        }
        if (operator == BinaryExpression.Operator.COMPLEQ) {
            return "<=";
        }
        if (operator == BinaryExpression.Operator.COMPLT) {
            return "<";
        }
        if (operator == BinaryExpression.Operator.COMPNEQ) {
            throw new UnsupportedOperationException();
        }
        if (operator == BinaryExpression.Operator.LOGICAND) {
            return "and";
        }
        if (operator == BinaryExpression.Operator.LOGICOR) {
            return "or";
        }
        if (operator == BinaryExpression.Operator.LOGICIMPLIES) {
            return "=>";
        }
        if (operator == BinaryExpression.Operator.LOGICIFF) {
            return "=";
        }
        if (operator == BinaryExpression.Operator.ARITHDIV) {
            IBoogieType iBoogieType3;
            IBoogieType iBoogieType4 = iBoogieType3 = iBoogieType == null ? iBoogieType2 : iBoogieType;
            if (iBoogieType3 instanceof BoogiePrimitiveType) {
                BoogiePrimitiveType boogiePrimitiveType = (BoogiePrimitiveType)iBoogieType3;
                if (boogiePrimitiveType.getTypeCode() == -2) {
                    return "div";
                }
                if (boogiePrimitiveType.getTypeCode() == -3) {
                    return "/";
                }
                throw new AssertionError((Object)("ARITHDIV of this type not allowed: " + String.valueOf(iBoogieType3)));
            }
            throw new AssertionError((Object)("ARITHDIV of this type not allowed: " + String.valueOf(iBoogieType3)));
        }
        if (operator == BinaryExpression.Operator.ARITHMINUS) {
            return "-";
        }
        if (operator == BinaryExpression.Operator.ARITHMOD) {
            return "mod";
        }
        if (operator == BinaryExpression.Operator.ARITHMUL) {
            return "*";
        }
        if (operator == BinaryExpression.Operator.ARITHPLUS) {
            return "+";
        }
        if (operator == BinaryExpression.Operator.BITVECCONCAT) {
            return "concat";
        }
        throw new AssertionError((Object)("Unsupported binary expression " + String.valueOf(operator)));
    }

    @Override
    public String opTranslation(UnaryExpression.Operator operator, IBoogieType iBoogieType) {
        if (operator == UnaryExpression.Operator.LOGICNEG) {
            return "not";
        }
        if (operator == UnaryExpression.Operator.ARITHNEGATIVE) {
            return "-";
        }
        throw new AssertionError((Object)("Unsupported unary expression " + String.valueOf(operator)));
    }

    @Override
    public String funcApplication(String string, IBoogieType[] iBoogieTypeArray) {
        return this.mBoogie2SmtSymbolTable.getBoogieFunction2SmtFunction().get(string);
    }

    @Override
    public Term booleanTranslation(BooleanLiteral booleanLiteral) {
        return booleanLiteral.getValue() ? this.mScript.term("true", new Term[0]) : this.mScript.term("false", new Term[0]);
    }

    @Override
    public Term bitvecTranslation(BitvecLiteral bitvecLiteral) {
        String[] stringArray = new String[]{String.valueOf(bitvecLiteral.getLength())};
        return this.mScript.term("bv" + bitvecLiteral.getValue(), stringArray, null, new Term[0]);
    }

    @Override
    public Term integerTranslation(IntegerLiteral integerLiteral) {
        BigInteger bigInteger = new BigInteger(integerLiteral.getValue());
        Rational rational = SmtUtils.toRational((BigInteger)bigInteger);
        return rational.toTerm(SmtSortUtils.getIntSort((Script)this.mScript));
    }

    @Override
    public Term realTranslation(RealLiteral realLiteral) {
        Rational rational = SmtUtils.toRational((String)realLiteral.getValue());
        return rational.toTerm(SmtSortUtils.getRealSort((Script)this.mScript));
    }
}

