/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import java.util.Map;

public class SharedTermEvaluator {
    private final Clausifier mClausifier;

    public SharedTermEvaluator(Clausifier clausifier) {
        this.mClausifier = clausifier;
    }

    public Rational evaluate(Term term, Theory theory) {
        SMTAffineTerm sMTAffineTerm = SMTAffineTerm.create(term);
        Rational rational = sMTAffineTerm.getConstant();
        for (Map.Entry<Term, Rational> entry : sMTAffineTerm.getSummands().entrySet()) {
            LinVar linVar = this.mClausifier.getLinVar(entry.getKey());
            rational = rational.addmul(this.mClausifier.getLASolver().realValue(linVar), entry.getValue());
        }
        return rational;
    }
}

