/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.ComputeStoreInfosAndArrayGroups;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.SubArrayManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayCellAccess;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreLocationBlock;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SubtreePosition;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers.PositionAwareTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.CrossProducts;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class PartitionProjectionTermTransformer
extends PositionAwareTermTransformer {
    private final Stack<List<StoreLocationBlock>> mProjectLists;
    private final ManagedScript mMgdScript;
    private final NestedMap2<ArrayCellAccess, Integer, StoreLocationBlock> mArrayCellAccessToIntegerToLocationBlock;
    private final HashRelation3<ArrayGroup, Integer, StoreLocationBlock> mArrayGroupToDimensionToLocationBlocks;
    private final SubArrayManager mSubArrayManager;
    private final HashMap<IProgramVar, TermVariable> mNewInVars;
    private final HashMap<IProgramVar, TermVariable> mNewOutVars;
    private final EdgeInfo mEdgeInfo;
    private final NestedMap2<Term, IProgramVarOrConst, Term> mOriginalTermToSubArrayToReplacementTerm;
    private final List<IProgramVarOrConst> mHeapArrays;
    private boolean mIsFinished;
    private final Set<IProgramVar> mInVarsWithATermVar;
    private final Set<IProgramVar> mOutVarsWithATermVar;
    private final ILogger mLogger;
    private final Set<IProgramVarOrConst> mUpdatedSubarrays;
    private final ComputeStoreInfosAndArrayGroups<?> mCsiag;

    public PartitionProjectionTermTransformer(ILogger iLogger, ManagedScript managedScript, SubArrayManager subArrayManager, NestedMap2<ArrayCellAccess, Integer, StoreLocationBlock> nestedMap2, EdgeInfo edgeInfo, HashRelation3<ArrayGroup, Integer, StoreLocationBlock> hashRelation3, ComputeStoreInfosAndArrayGroups<?> computeStoreInfosAndArrayGroups, List<IProgramVarOrConst> list) {
        this.mLogger = Objects.requireNonNull(iLogger);
        this.mMgdScript = Objects.requireNonNull(managedScript);
        this.mSubArrayManager = Objects.requireNonNull(subArrayManager);
        this.mHeapArrays = Objects.requireNonNull(list);
        this.mCsiag = computeStoreInfosAndArrayGroups;
        assert (Objects.nonNull(nestedMap2) || !ArrayCellAccess.extractArrayCellAccesses(edgeInfo.getEdge().getTransformula().getFormula()).stream().anyMatch(arrayCellAccess -> this.mHeapArrays.contains(edgeInfo.getProgramVarOrConstForTerm(arrayCellAccess.getSimpleArray())))) : "this input map must be non-null if we have a select on a heap array inside the edge";
        this.mArrayCellAccessToIntegerToLocationBlock = nestedMap2;
        this.mArrayGroupToDimensionToLocationBlocks = hashRelation3;
        this.mEdgeInfo = edgeInfo;
        this.mNewInVars = new HashMap();
        this.mNewOutVars = new HashMap();
        this.mInVarsWithATermVar = new HashSet<IProgramVar>();
        this.mOutVarsWithATermVar = new HashSet<IProgramVar>();
        this.mProjectLists = new Stack();
        this.mProjectLists.push(Collections.emptyList());
        this.mOriginalTermToSubArrayToReplacementTerm = new NestedMap2();
        this.mUpdatedSubarrays = new HashSet<IProgramVarOrConst>();
    }

    @Override
    protected void convert(Term term, SubtreePosition subtreePosition) {
        assert (this.mProjectLists.stream().allMatch(list -> list.stream().allMatch(Objects::nonNull)));
        List<StoreLocationBlock> list2 = this.mProjectLists.peek();
        if (term instanceof ConstantTerm || term instanceof TermVariable) {
            IProgramVar iProgramVar;
            IProgramVar iProgramVar2 = this.mEdgeInfo.getInVar(term);
            if (iProgramVar2 != null) {
                this.mInVarsWithATermVar.add(iProgramVar2);
            }
            if ((iProgramVar = this.mEdgeInfo.getOutVar(term)) != null) {
                this.mOutVarsWithATermVar.add(iProgramVar);
            }
            if (this.isPartitionedArray(term)) {
                Term term2 = this.getSubArrayReplacementTerm(term, list2);
                this.setResult(term2);
            } else {
                this.setResult(term);
            }
        } else if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            String string = applicationTerm.getFunction().getName();
            if (string.equals("=") && applicationTerm.getFunction().getParameterSorts().length == 2 && applicationTerm.getParameters()[0].getSort().isArraySort()) {
                assert (list2.isEmpty()) : "We should not have an active projection on the Boolean level.";
                Term term3 = applicationTerm.getParameters()[0];
                Term term4 = applicationTerm.getParameters()[1];
                Term term5 = this.extractSimpleArrayTerm(term3);
                Term term6 = this.extractSimpleArrayTerm(term4);
                if (!this.mCsiag.isArrayTermSubjectToSeparation(this.mEdgeInfo, term5)) {
                    assert (!this.mCsiag.isArrayTermSubjectToSeparation(this.mEdgeInfo, term6));
                    super.convert(term, subtreePosition);
                    return;
                }
                assert (this.mCsiag.isArrayTermSubjectToSeparation(this.mEdgeInfo, term6));
                ArrayGroup arrayGroup = this.mCsiag.getArrayGroupForTermInEdge(this.mEdgeInfo, term5);
                List<List<StoreLocationBlock>> list3 = this.getAllLocationBlockTuplesForHeapArray(arrayGroup);
                this.enqueueWalker(new BuildConjunction(list3.size(), this.mMgdScript.getScript()));
                for (List<StoreLocationBlock> list4 : list3) {
                    this.enqueueWalker(new EndScope());
                    this.enqueueWalker(new PositionAwareTermTransformer.BuildApplicationTerm((ApplicationTerm)term, subtreePosition));
                    this.pushTerms(applicationTerm.getParameters(), subtreePosition);
                    this.enqueueWalker(new BeginScope(Collections.unmodifiableList(list4)));
                }
            } else if (string.equals("select")) {
                Term term7 = applicationTerm.getParameters()[0];
                IProgramVarOrConst iProgramVarOrConst = this.mEdgeInfo.getProgramVarOrConstForTerm(this.extractSimpleArrayTerm(term7));
                if (!this.mHeapArrays.contains(iProgramVarOrConst)) {
                    super.convert(term, subtreePosition);
                    return;
                }
                ArrayCellAccess arrayCellAccess = new ArrayCellAccess(MultiDimensionalSelect.of((Term)term));
                this.enqueueWalker(new BuildArrayCellAccessTerm(arrayCellAccess, this.mMgdScript.getScript()));
                this.enqueueWalker(new EndScope());
                this.pushTerms((Term[])arrayCellAccess.getIndex().toArray((Object[])new Term[arrayCellAccess.getIndex().size()]), subtreePosition.append(1));
                this.enqueueWalker(new BeginScope(Collections.emptyList()));
                ArrayList<StoreLocationBlock> arrayList = new ArrayList<StoreLocationBlock>();
                int n = 1;
                while (n <= arrayCellAccess.getIndex().size()) {
                    StoreLocationBlock storeLocationBlock = (StoreLocationBlock)this.mArrayCellAccessToIntegerToLocationBlock.get((Object)arrayCellAccess, (Object)n);
                    assert (storeLocationBlock != null);
                    arrayList.add(storeLocationBlock);
                    ++n;
                }
                this.enqueueWalker(new EndScope());
                this.pushTerm(arrayCellAccess.getArray(), subtreePosition.append(2));
                this.enqueueWalker(new BeginScope(this.append(arrayList, list2)));
            } else if (string.equals("store")) {
                Term term8 = applicationTerm.getParameters()[0];
                Term term9 = applicationTerm.getParameters()[1];
                Term term10 = applicationTerm.getParameters()[2];
                Term term11 = this.extractSimpleArrayTerm(term8);
                IProgramVarOrConst iProgramVarOrConst = this.mEdgeInfo.getProgramVarOrConstForTerm(term11);
                if (!this.mHeapArrays.contains(iProgramVarOrConst)) {
                    super.convert(term, subtreePosition);
                    return;
                }
                assert (list2.size() > 0) : "(IndexOutOfBoundsExceptions are hard to catch somehow..";
                if (this.fallsInto(subtreePosition, term, list2.get(0))) {
                    if (term11 == term8) {
                        assert (new MultiDimensionalSort(term11.getSort()).getDimension() == list2.size());
                        IProgramVarOrConst iProgramVarOrConst2 = this.mSubArrayManager.getSubArray(iProgramVarOrConst, list2);
                        this.mUpdatedSubarrays.add(iProgramVarOrConst2);
                    }
                    this.enqueueWalker(new PositionAwareTermTransformer.BuildApplicationTerm((ApplicationTerm)term, subtreePosition));
                    this.enqueueWalker(new EndScope());
                    this.pushTerm(term10, subtreePosition.append(2));
                    this.enqueueWalker(new BeginScope(PartitionProjectionTermTransformer.dropFirst(list2)));
                    this.enqueueWalker(new EndScope());
                    this.pushTerm(term9, subtreePosition.append(1));
                    this.enqueueWalker(new BeginScope(Collections.emptyList()));
                    this.enqueueWalker(new EndScope());
                    this.pushTerm(term8, subtreePosition.append(0));
                    this.enqueueWalker(new BeginScope(list2));
                } else {
                    this.pushTerm(term8, subtreePosition.append(0));
                }
            } else {
                this.enqueueWalker(new PositionAwareTermTransformer.BuildApplicationTerm((ApplicationTerm)term, subtreePosition));
                this.pushTerms(((ApplicationTerm)term).getParameters(), subtreePosition);
            }
        } else if (term instanceof LetTerm) {
            super.convert(term, subtreePosition);
        } else if (term instanceof QuantifiedFormula) {
            super.convert(term, subtreePosition);
        } else if (term instanceof AnnotatedTerm) {
            super.convert(term, subtreePosition);
        } else {
            throw new AssertionError((Object)("Unknown Term: " + term.toStringDirect()));
        }
    }

    private List<StoreLocationBlock> append(List<StoreLocationBlock> list, List<StoreLocationBlock> list2) {
        ArrayList<StoreLocationBlock> arrayList = new ArrayList<StoreLocationBlock>(list);
        arrayList.addAll(list2);
        assert (PartitionProjectionTermTransformer.assertIsSortedByDimensions(arrayList));
        return arrayList;
    }

    static boolean isSorted(List<Integer> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list);
        Collections.sort(arrayList);
        return list.equals(arrayList);
    }

    private Term extractSimpleArrayTerm(Term term) {
        if (!term.getSort().isArraySort()) {
            throw new IllegalArgumentException();
        }
        Term term2 = term;
        while (SmtUtils.isFunctionApplication((Term)term2, (String)"store") || SmtUtils.isFunctionApplication((Term)term2, (String)"select")) {
            term2 = ((ApplicationTerm)term2).getParameters()[0];
        }
        assert (!(term2 instanceof ApplicationTerm) || ((ApplicationTerm)term2).getParameters().length == 0);
        return term2;
    }

    private Term getSubArrayReplacementTerm(Term term, List<StoreLocationBlock> list) {
        IProgramVarOrConst iProgramVarOrConst = this.mEdgeInfo.getProgramVarOrConstForTerm(term);
        IProgramVarOrConst iProgramVarOrConst2 = this.mSubArrayManager.getSubArray(iProgramVarOrConst, list);
        return this.getOrConstructSubArrayTermAndUpdateInOutVarMappings(term, iProgramVarOrConst, iProgramVarOrConst2);
    }

    private Term getOrConstructSubArrayTermAndUpdateInOutVarMappings(Term term, IProgramVarOrConst iProgramVarOrConst, IProgramVarOrConst iProgramVarOrConst2) {
        Term term2 = (Term)this.mOriginalTermToSubArrayToReplacementTerm.get((Object)term, (Object)iProgramVarOrConst2);
        if (term2 == null) {
            if (!(term instanceof TermVariable)) {
                throw new UnsupportedOperationException("TODO: if this occurs, extend below code to replace a constant term by a constant term");
            }
            term2 = this.mMgdScript.constructFreshTermVariable(iProgramVarOrConst2.getGloballyUniqueId(), iProgramVarOrConst2.getSort());
            this.mOriginalTermToSubArrayToReplacementTerm.put((Object)term, (Object)iProgramVarOrConst2, (Object)term2);
            if (iProgramVarOrConst2 instanceof IProgramVar) {
                Term term3;
                assert (iProgramVarOrConst instanceof IProgramVar);
                IProgramVar iProgramVar = (IProgramVar)iProgramVarOrConst2;
                Term term4 = (Term)this.mEdgeInfo.getEdge().getTransformula().getInVars().get(iProgramVarOrConst);
                if (term4 == term) {
                    this.mNewInVars.put(iProgramVar, (TermVariable)term2);
                }
                if ((term3 = (Term)this.mEdgeInfo.getEdge().getTransformula().getOutVars().get(iProgramVarOrConst)) == term) {
                    this.mNewOutVars.put(iProgramVar, (TermVariable)term2);
                }
            }
        }
        return term2;
    }

    private boolean isPartitionedArray(Term term) {
        if (!term.getSort().isArraySort()) {
            return false;
        }
        return this.mCsiag.isArrayTermSubjectToSeparation(this.mEdgeInfo, term);
    }

    private List<Set<StoreLocationBlock>> getLocationBlocksForArrayGroup(ArrayGroup arrayGroup) {
        ArrayList<Set<StoreLocationBlock>> arrayList = new ArrayList<Set<StoreLocationBlock>>();
        int n = 1;
        while (n <= arrayGroup.getDimensionality()) {
            arrayList.add(this.mArrayGroupToDimensionToLocationBlocks.projectToTrd((Object)arrayGroup, (Object)n));
            ++n;
        }
        return arrayList;
    }

    private static <E> List<E> addToFront(E e, List<E> list) {
        ArrayList<E> arrayList = new ArrayList<E>();
        arrayList.add(e);
        arrayList.addAll(list);
        return Collections.unmodifiableList(arrayList);
    }

    private static <E> List<E> dropFirst(List<E> list) {
        ArrayList<E> arrayList = new ArrayList<E>(list.subList(1, list.size()));
        return Collections.unmodifiableList(arrayList);
    }

    private boolean fallsInto(SubtreePosition subtreePosition, Term term, StoreLocationBlock storeLocationBlock) {
        assert (SmtUtils.isFunctionApplication((Term)term, (String)"store"));
        StoreInfo storeInfo = this.mCsiag.getStoreInfoForStoreTermAtPositionInEdge(this.mEdgeInfo, subtreePosition);
        return storeLocationBlock.contains(storeInfo);
    }

    private void pushLocationBlockList(List<StoreLocationBlock> list) {
        assert (Objects.nonNull(list));
        assert (list.stream().allMatch(Objects::nonNull));
        this.mProjectLists.push(Collections.unmodifiableList(list));
    }

    private void popLocationBlockList() {
        this.mProjectLists.pop();
    }

    static boolean assertIsSortedByDimensions(List<StoreLocationBlock> list) {
        return PartitionProjectionTermTransformer.isSorted(list.stream().map(storeLocationBlock -> storeLocationBlock.getDimension()).collect(Collectors.toList()));
    }

    public Map<IProgramVar, TermVariable> getNewInVars() {
        if (!this.mIsFinished) {
            throw new IllegalStateException();
        }
        return Collections.unmodifiableMap(this.mNewInVars);
    }

    public Map<IProgramVar, TermVariable> getNewOutVars() {
        if (!this.mIsFinished) {
            throw new IllegalStateException();
        }
        return Collections.unmodifiableMap(this.mNewOutVars);
    }

    public void finish() {
        TermVariable termVariable;
        IProgramVar iProgramVar;
        List<List<StoreLocationBlock>> list;
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mEdgeInfo.getInVars().entrySet()) {
            if (this.mHeapArrays.contains(entry.getKey())) continue;
            this.mNewInVars.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mEdgeInfo.getOutVars().entrySet()) {
            if (this.mHeapArrays.contains(entry.getKey())) continue;
            this.mNewOutVars.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mEdgeInfo.getInVars().entrySet()) {
            if (this.mInVarsWithATermVar.contains(entry.getKey()) || !this.mHeapArrays.contains(entry.getKey())) continue;
            list = this.getAllLocationBlockTuplesForHeapArray(this.mCsiag.getArrayGroupForArrayPvoc((IProgramVarOrConst)entry.getKey()));
            for (List<StoreLocationBlock> list2 : list) {
                iProgramVar = (IProgramVar)this.mSubArrayManager.getSubArray((IProgramVarOrConst)entry.getKey(), list2);
                termVariable = this.mMgdScript.constructFreshCopy(iProgramVar.getTermVariable());
                assert (!this.mNewInVars.containsKey(iProgramVar));
                this.mNewInVars.put(iProgramVar, termVariable);
            }
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mEdgeInfo.getOutVars().entrySet()) {
            if (this.mOutVarsWithATermVar.contains(entry.getKey()) || !this.mHeapArrays.contains(entry.getKey())) continue;
            list = this.getAllLocationBlockTuplesForHeapArray(this.mCsiag.getArrayGroupForArrayPvoc((IProgramVarOrConst)entry.getKey()));
            for (List<StoreLocationBlock> list2 : list) {
                iProgramVar = (IProgramVar)this.mSubArrayManager.getSubArray((IProgramVarOrConst)entry.getKey(), list2);
                termVariable = this.mMgdScript.constructFreshCopy(iProgramVar.getTermVariable());
                assert (!this.mNewOutVars.containsKey(iProgramVar));
                this.mNewOutVars.put(iProgramVar, termVariable);
            }
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mNewInVars.entrySet()) {
            if (!this.mHeapArrays.contains(entry.getKey())) continue;
            throw new IllegalStateException();
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mNewOutVars.entrySet()) {
            if (!this.mHeapArrays.contains(entry.getKey())) continue;
            throw new IllegalStateException();
        }
        this.mIsFinished = true;
    }

    private List<List<StoreLocationBlock>> getAllLocationBlockTuplesForHeapArray(ArrayGroup arrayGroup) {
        assert (arrayGroup != null && !DataStructureUtils.intersection(new HashSet<IProgramVarOrConst>(this.mHeapArrays), arrayGroup.getArrays()).isEmpty());
        List<Set<StoreLocationBlock>> list = this.getLocationBlocksForArrayGroup(arrayGroup);
        List list2 = CrossProducts.crossProductOfSets(list);
        return list2;
    }

    public Set<IProgramVarOrConst> getUpdatedSubarrays() {
        return this.mUpdatedSubarrays;
    }

    protected static class BeginScope
    implements NonRecursive.Walker {
        private final List<StoreLocationBlock> mLocBlockList;

        public BeginScope(List<StoreLocationBlock> list) {
            assert (Objects.nonNull(list));
            assert (list.stream().allMatch(Objects::nonNull));
            assert (PartitionProjectionTermTransformer.assertIsSortedByDimensions(list));
            this.mLocBlockList = list;
        }

        public void walk(NonRecursive nonRecursive) {
            PartitionProjectionTermTransformer partitionProjectionTermTransformer = (PartitionProjectionTermTransformer)nonRecursive;
            partitionProjectionTermTransformer.beginScope();
            partitionProjectionTermTransformer.pushLocationBlockList(this.mLocBlockList);
        }
    }

    protected static class BuildArrayCellAccessTerm
    implements NonRecursive.Walker {
        private final Script mScript;
        private final ArrayCellAccess mArrayCellAccess;

        BuildArrayCellAccessTerm(ArrayCellAccess arrayCellAccess, Script script) {
            this.mArrayCellAccess = arrayCellAccess;
            this.mScript = script;
        }

        public void walk(NonRecursive nonRecursive) {
            PartitionProjectionTermTransformer partitionProjectionTermTransformer = (PartitionProjectionTermTransformer)nonRecursive;
            Term[] termArray = new Term[this.mArrayCellAccess.getIndex().size()];
            int n = this.mArrayCellAccess.getIndex().size() - 1;
            while (n >= 0) {
                termArray[n] = partitionProjectionTermTransformer.getConverted();
                --n;
            }
            ArrayIndex arrayIndex = new ArrayIndex(Arrays.asList(termArray));
            Term term = partitionProjectionTermTransformer.getConverted();
            Term term2 = new MultiDimensionalSelect(term, arrayIndex).toTerm(this.mScript);
            partitionProjectionTermTransformer.setResult(term2);
        }
    }

    protected static class BuildConjunction
    implements NonRecursive.Walker {
        int mNumberOfConjuncts;
        Script mScript;

        public BuildConjunction(int n, Script script) {
            this.mNumberOfConjuncts = n;
            this.mScript = script;
        }

        public void walk(NonRecursive nonRecursive) {
            PartitionProjectionTermTransformer partitionProjectionTermTransformer = (PartitionProjectionTermTransformer)nonRecursive;
            Term[] termArray = new Term[this.mNumberOfConjuncts];
            int n = 0;
            while (n < this.mNumberOfConjuncts) {
                termArray[n] = partitionProjectionTermTransformer.getConverted();
                ++n;
            }
            partitionProjectionTermTransformer.setResult(SmtUtils.and((Script)this.mScript, (Term[])termArray));
        }

        public String toString() {
            return "and\\^" + this.mNumberOfConjuncts;
        }
    }

    protected static class EndScope
    implements NonRecursive.Walker {
        protected EndScope() {
        }

        public void walk(NonRecursive nonRecursive) {
            PartitionProjectionTermTransformer partitionProjectionTermTransformer = (PartitionProjectionTermTransformer)nonRecursive;
            partitionProjectionTermTransformer.endScope();
            partitionProjectionTermTransformer.popLocationBlockList();
        }
    }
}

