/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.TestGraphs;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.layout.PersistentLayout;
import edu.uci.ics.jung.visualization.layout.PersistentLayoutImpl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PersistentLayoutDemo {
    Graph<String, Number> graph = TestGraphs.getOneComponentGraph();
    String fileName;
    VisualizationViewer<String, Number> vv;
    PersistentLayout<String, Number> persistentLayout;

    public PersistentLayoutDemo(final String fileName) {
        this.fileName = fileName;
        this.persistentLayout = new PersistentLayoutImpl<String, Number>(new FRLayout<String, Number>(this.graph));
        this.vv = new VisualizationViewer<String, Number>(this.persistentLayout);
        this.vv.setVertexToolTipTransformer(new ToStringLabeller());
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(gm);
        JFrame frame = new JFrame();
        frame.getContentPane().add(new GraphZoomScrollPane(this.vv));
        frame.setDefaultCloseOperation(3);
        JPanel p = new JPanel();
        JButton persist = new JButton("Save Layout");
        persist.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    PersistentLayoutDemo.this.persistentLayout.persist(fileName);
                }
                catch (IOException e1) {
                    System.err.println("got " + e1);
                }
            }
        });
        p.add(persist);
        JButton restore = new JButton("Restore Layout");
        restore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    PersistentLayoutDemo.this.persistentLayout.restore(fileName);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        p.add(restore);
        p.add(gm.getModeComboBox());
        frame.getContentPane().add((Component)p, "South");
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        String filename = args.length >= 1 ? args[0] : "PersistentLayoutDemo.out";
        new PersistentLayoutDemo(filename);
    }
}

