/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.mso;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.mso.MSODUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MSODAlphabetSymbol {
    private final Map<Term, Boolean> mMap = new HashMap<Term, Boolean>();

    public MSODAlphabetSymbol() {
    }

    public MSODAlphabetSymbol(Term term, boolean bl) {
        this.add(term, bl);
    }

    public MSODAlphabetSymbol(Term term, Term term2, boolean bl, boolean bl2) {
        this.add(term, bl);
        this.add(term2, bl2);
    }

    public MSODAlphabetSymbol(List<Term> list, boolean bl) {
        list.forEach(term -> this.add((Term)term, bl));
    }

    public final Map<Term, Boolean> getMap() {
        return this.mMap;
    }

    public final Set<Term> getTerms() {
        return this.mMap.keySet();
    }

    public void add(Term term, boolean bl) {
        if (!MSODUtils.isConstantOrTermVariable(term)) {
            throw new IllegalArgumentException("Input term must be an Int or SetOfInt variable.");
        }
        this.mMap.put(term, bl);
    }

    public boolean contains(MSODAlphabetSymbol mSODAlphabetSymbol) {
        return this.mMap.entrySet().containsAll(mSODAlphabetSymbol.mMap.entrySet());
    }

    public boolean allMatches(boolean bl, Term ... termArray) {
        HashSet<Term> hashSet = new HashSet<Term>(Arrays.asList(termArray));
        for (Map.Entry<Term, Boolean> entry : this.mMap.entrySet()) {
            if (hashSet.contains(entry.getKey()) || entry.getValue().equals(bl)) continue;
            return false;
        }
        return true;
    }

    public Set<Term> containsSort(String ... stringArray) {
        HashSet<Term> hashSet = new HashSet<Term>();
        for (Term term : this.getTerms()) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if (term.getSort().getName().equals(string)) {
                    hashSet.add(term);
                }
                ++n2;
            }
        }
        return hashSet;
    }

    public String toString() {
        if (this.mMap.isEmpty()) {
            return "\u03b5";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Term, Boolean> entry : this.mMap.entrySet()) {
            stringBuilder.append(entry.getKey().toString()).append("=").append(entry.getValue() != false ? "1 " : "0 ");
        }
        return stringBuilder.toString().trim();
    }

    public int hashCode() {
        return 31 + this.mMap.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this == object || ((MSODAlphabetSymbol)object).mMap.equals(this.mMap);
    }
}

