/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata;

import de.uni_freiburg.informatik.ultimate.automata.StatisticsType;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class AutomataOperationStatistics
implements ICsvProviderProvider<Object> {
    private static final int INVALID_PERCENTAGE = -1;
    private final TreeMap<StatisticsType, Object> mKeyValueMap = new TreeMap();

    public ICsvProvider<Object> createCsvProvider() {
        ArrayList<String> arrayList = new ArrayList<String>(this.mKeyValueMap.size());
        ArrayList<Object> arrayList2 = new ArrayList<Object>(this.mKeyValueMap.size());
        for (Map.Entry<StatisticsType, Object> simpleCsvProvider2 : this.mKeyValueMap.entrySet()) {
            arrayList.add(simpleCsvProvider2.getKey().toString());
            arrayList2.add(simpleCsvProvider2.getValue());
        }
        SimpleCsvProvider simpleCsvProvider = new SimpleCsvProvider(arrayList);
        simpleCsvProvider.addRow(arrayList2);
        return simpleCsvProvider;
    }

    public void addKeyValuePair(StatisticsType statisticsType, Object object) {
        assert (!this.mKeyValueMap.containsKey((Object)statisticsType)) : "The statistics for key " + String.valueOf((Object)statisticsType) + " would be overwritten, which is not allowed.";
        this.mKeyValueMap.put(statisticsType, object);
    }

    public void addAllStatistics(AutomataOperationStatistics automataOperationStatistics) {
        for (Map.Entry<StatisticsType, Object> entry : automataOperationStatistics.mKeyValueMap.entrySet()) {
            this.addKeyValuePair(entry.getKey(), entry.getValue());
        }
    }

    public void addPercentageData(StatisticsType statisticsType, StatisticsType statisticsType2, StatisticsType statisticsType3) {
        this.addPercentageDataHelper(statisticsType, statisticsType2, statisticsType3, false);
    }

    public void addPercentageDataInverted(StatisticsType statisticsType, StatisticsType statisticsType2, StatisticsType statisticsType3) {
        this.addPercentageDataHelper(statisticsType, statisticsType2, statisticsType3, true);
    }

    private void addPercentageDataHelper(StatisticsType statisticsType, StatisticsType statisticsType2, StatisticsType statisticsType3, boolean bl) {
        int n = this.getInteger(statisticsType);
        if (n == 0) {
            this.addKeyValuePair(statisticsType3, -1);
            return;
        }
        int n2 = this.getInteger(statisticsType2);
        int n3 = 100 * n2 / n;
        Integer n4 = bl ? 100 - n3 : n3;
        this.addKeyValuePair(statisticsType3, n4);
    }

    public void addDifferenceData(StatisticsType statisticsType, StatisticsType statisticsType2, StatisticsType statisticsType3) {
        int n = this.getDifference(statisticsType, statisticsType2);
        this.addKeyValuePair(statisticsType3, n);
    }

    private int getDifference(StatisticsType statisticsType, StatisticsType statisticsType2) {
        int n = this.getInteger(statisticsType);
        int n2 = this.getInteger(statisticsType2);
        return n - n2;
    }

    private Integer getInteger(StatisticsType statisticsType) {
        Object object = this.mKeyValueMap.get((Object)statisticsType);
        if (object == null) {
            throw new IllegalArgumentException("First insert the value for key " + String.valueOf((Object)statisticsType));
        }
        if (!(object instanceof Integer)) {
            throw new IllegalArgumentException(String.valueOf((Object)statisticsType) + " has a value stored that is not of integer type.");
        }
        return (Integer)object;
    }

    public String toString() {
        return this.mKeyValueMap.toString();
    }
}

