/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding;

import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Condition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.ConditionMarking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Configuration;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class Event<LETTER, PLACE>
implements Serializable {
    private static final long serialVersionUID = 7162664880110047121L;
    private static final boolean USE_HASH_JENKINS = false;
    private static final int HASH_PRIME = 89;
    private static final boolean BUMBLEBEE_B17_OPTIMIZAION = true;
    private int mSerialNumber = -1;
    private final int mHashCode;
    private final Set<Condition<LETTER, PLACE>> mPredecessors;
    private final Set<Condition<LETTER, PLACE>> mSuccessors;
    private final Configuration<LETTER, PLACE> mLocalConfiguration;
    private final Marking<PLACE> mMark;
    private final ConditionMarking<LETTER, PLACE> mConditionMark;
    private Event<LETTER, PLACE> mCompanion;
    private final Transition<LETTER, PLACE> mTransition;
    private final Map<PLACE, Set<PLACE>> mPlaceCorelationMap;
    private int mDepth;
    private boolean mIsCompanion = false;
    private final Set<Event<LETTER, PLACE>> mIsCompanionToCutoffEventsSet = new HashSet<Event<LETTER, PLACE>>();

    public Event(Collection<Condition<LETTER, PLACE>> collection, Transition<LETTER, PLACE> transition, BranchingProcess<LETTER, PLACE> branchingProcess, int n) throws PetriNetNot1SafeException {
        assert (this.conditionToPlaceEqual(collection, (Collection<PLACE>)transition.getPredecessors())) : "An event was created with inappropriate predecessors.\n  transition: " + transition.toString() + "\n  events predecessors: " + collection.toString() + "\n  transitions predecessors:" + String.valueOf(transition.getPredecessors());
        this.mPredecessors = new HashSet<Condition<LETTER, PLACE>>(collection);
        this.mTransition = transition;
        this.mSuccessors = transition.getSuccessors().stream().map(object -> branchingProcess.constructCondition(this, object)).collect(Collectors.toSet());
        this.mHashCode = n;
        HashSet hashSet = new HashSet();
        this.mDepth = 0;
        Set set = collection.stream().map(condition -> condition.getPredecessorEvent()).collect(Collectors.toSet());
        HashSet hashSet2 = new HashSet();
        for (Event event : set) {
            for (Event<LETTER, PLACE> event2 : event.mLocalConfiguration) {
                hashSet2.add(event2);
            }
            event.mConditionMark.addTo(hashSet);
            this.mDepth = Math.max(this.mDepth, event.getDepth());
        }
        ++this.mDepth;
        hashSet2.add(this);
        this.mLocalConfiguration = new Configuration(hashSet2, this.mDepth);
        for (Event event : this.mLocalConfiguration) {
            hashSet.removeAll(event.getPredecessorConditions());
        }
        hashSet.addAll(this.mSuccessors);
        this.mConditionMark = new ConditionMarking(hashSet);
        this.mMark = this.mConditionMark.getMarking();
        this.mPlaceCorelationMap = new HashMap<PLACE, Set<PLACE>>();
        if (branchingProcess.getNewFiniteComprehensivePrefixMode()) {
            this.computePlaceCorelationMap(branchingProcess);
        }
    }

    @Deprecated
    public void setSerialNumber(int n) {
        this.mSerialNumber = n;
    }

    public int getDepth() {
        return this.mDepth;
    }

    public Event(BranchingProcess<LETTER, PLACE> branchingProcess) {
        this.mTransition = null;
        this.mLocalConfiguration = new Configuration(new HashSet(), 0);
        this.mMark = new Marking(ImmutableSet.of(branchingProcess.getNet().getInitialPlaces()));
        HashSet hashSet = new HashSet();
        this.mConditionMark = new ConditionMarking(hashSet);
        this.mPredecessors = new HashSet<Condition<LETTER, PLACE>>();
        this.mSuccessors = this.mMark.stream().map(object -> branchingProcess.constructCondition(this, object)).collect(Collectors.toSet());
        hashSet.addAll(this.mSuccessors);
        this.mHashCode = HashUtils.hashJenkins((int)89, (Object)0);
        this.mPlaceCorelationMap = new HashMap<PLACE, Set<PLACE>>();
        if (branchingProcess.getNewFiniteComprehensivePrefixMode()) {
            this.computePlaceCorelationMap(branchingProcess);
        }
        this.mDepth = 0;
    }

    public Set<Event<LETTER, PLACE>> getSuccessorEvents() {
        HashSet<Event<LETTER, PLACE>> hashSet = new HashSet<Event<LETTER, PLACE>>();
        for (Condition<LETTER, PLACE> condition : this.getSuccessorConditions()) {
            hashSet.addAll(condition.getSuccessorEvents());
        }
        return hashSet;
    }

    public Set<Event<LETTER, PLACE>> getPredecessorEvents() {
        HashSet<Event<LETTER, PLACE>> hashSet = new HashSet<Event<LETTER, PLACE>>();
        for (Condition<LETTER, PLACE> condition : this.getPredecessorConditions()) {
            hashSet.add(condition.getPredecessorEvent());
        }
        return hashSet;
    }

    private boolean conditionToPlaceEqual(Collection<Condition<LETTER, PLACE>> collection, Collection<PLACE> collection2) {
        HashSet<PLACE> hashSet = new HashSet<PLACE>(collection2);
        for (Condition<LETTER, PLACE> condition : collection) {
            if (hashSet.remove(condition.getPlace())) continue;
            return false;
        }
        return hashSet.isEmpty();
    }

    public ConditionMarking<LETTER, PLACE> getConditionMark() {
        return this.mConditionMark;
    }

    public Set<Condition<LETTER, PLACE>> getSuccessorConditions() {
        return this.mSuccessors;
    }

    public Set<Condition<LETTER, PLACE>> getPredecessorConditions() {
        return this.mPredecessors;
    }

    public Map<PLACE, Set<PLACE>> getPlaceCorelationMap() {
        return this.mPlaceCorelationMap;
    }

    public Marking<PLACE> getMark() {
        return this.mMark;
    }

    public boolean checkCutOffAndSetCompanion(Event<LETTER, PLACE> event, Comparator<Event<LETTER, PLACE>> comparator, boolean bl) {
        if (bl && !this.getTransition().equals(event.getTransition())) {
            return false;
        }
        if (!this.getMark().equals(event.getMark())) {
            return false;
        }
        this.setCompanion(event);
        return true;
    }

    public boolean checkCutOffAndSetCompanionForComprehensivePrefix(Event<LETTER, PLACE> event, Comparator<Event<LETTER, PLACE>> comparator, boolean bl) {
        if (bl && !this.getTransition().equals(event.getTransition())) {
            return false;
        }
        if (comparator.compare(event, this) >= 0) {
            return false;
        }
        if (!event.getPlaceCorelationMap().equals(this.getPlaceCorelationMap())) {
            return false;
        }
        this.setCompanion(event);
        return true;
    }

    public void computePlaceCorelationMap(BranchingProcess<LETTER, PLACE> branchingProcess) {
        for (Condition<LETTER, PLACE> condition : this.getConditionMark()) {
            this.mPlaceCorelationMap.put(condition.getPlace(), branchingProcess.computeCoRelatedPlaces(condition));
        }
    }

    public void setCompanion(Event<LETTER, PLACE> event) {
        assert (this.mCompanion == null);
        if (event.getCompanion() == null) {
            this.mCompanion = event;
            event.makeCompanionOf(this);
        } else {
            this.setCompanion(event.getCompanion());
        }
    }

    public void makeCompanionOf(Event<LETTER, PLACE> event) {
        this.mIsCompanion = true;
        this.mIsCompanionToCutoffEventsSet.add(event);
    }

    public boolean isCompanion() {
        return this.mIsCompanion;
    }

    public Set<Event<LETTER, PLACE>> getCutoffEventsThisIsCompanionTo() {
        return this.mIsCompanionToCutoffEventsSet;
    }

    public boolean isCutoffEvent() {
        return this.mCompanion != null;
    }

    public int getAncestors() {
        return this.mLocalConfiguration.size();
    }

    public Configuration<LETTER, PLACE> getLocalConfiguration() {
        return this.mLocalConfiguration;
    }

    public boolean conditionMarkContains(Condition<LETTER, PLACE> condition) {
        return this.mConditionMark.contains(condition);
    }

    public Event<LETTER, PLACE> getCompanion() {
        return this.mCompanion;
    }

    public Transition<LETTER, PLACE> getTransition() {
        return this.mTransition;
    }

    public int getSerialNumber() {
        return this.mSerialNumber;
    }

    public int getTotalOrderId() {
        return this.mTransition.getTotalOrderId();
    }

    public String toString() {
        if (this.mSerialNumber == 0) {
            return "Dummy event whose successors are the initial conditions of the branching process";
        }
        return this.mSerialNumber + ":" + this.mLocalConfiguration.size() + "A:" + this.getTransition().toString();
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public boolean equals(Object object) {
        return this == object;
    }
}

