/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.chc;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieLocation;
import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcBodyAuxVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcBodyVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcHeadVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornUtilConstants;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.ITerm2ExpressionSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.TermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HcSymbolTable
extends DefaultIcfgSymbolTable
implements ITerm2ExpressionSymbolTable {
    private final ManagedScript mManagedScript;
    private final NestedMap2<String, List<Sort>, HcPredicateSymbol> mNameToSortsToHornClausePredicateSymbol = new NestedMap2();
    private HcPredicateSymbol.HornClauseTruePredicateSymbol mTrueHornClausePredSym;
    private HcPredicateSymbol.HornClauseDontCarePredicateSymbol mDontCareHornClausePredSym;
    private final HcPredicateSymbol mFalseHornClausePredSym;
    final Map<TermVariable, Integer> mVersionsMap;
    private final NestedMap3<HcPredicateSymbol, Integer, Sort, HcHeadVar> mPredSymNameToIndexToSortToHcHeadVar;
    private final NestedMap3<HcPredicateSymbol, Integer, Sort, HcBodyVar> mPredSymNameToIndexToSortToHcBodyVar;
    private final Map<TermVariable, HcBodyAuxVar> mTermVariableToHcBodyAuxVar;
    private final Map<TermVariable, IProgramVar> mTermVarToProgramVar;
    private final TermTransferrer mTermTransferrer;
    private final Map<String, String> mSmtFunction2BoogieFunction;
    private final HashRelation3<String, Sort[], Sort> mSkolemFunctions;
    private boolean mGotoProcMode;

    public HcSymbolTable(ManagedScript managedScript) {
        this(null, managedScript);
    }

    public HcSymbolTable(Script script, ManagedScript managedScript) {
        this.mManagedScript = managedScript;
        this.mManagedScript.lock((Object)this);
        ApplicationTerm applicationTerm = (ApplicationTerm)managedScript.getScript().term("false", new Term[0]);
        this.mFalseHornClausePredSym = new HcPredicateSymbol.HornClauseFalsePredicateSymbol(applicationTerm.getFunction());
        ApplicationTerm applicationTerm2 = (ApplicationTerm)managedScript.getScript().term("true", new Term[0]);
        this.mTrueHornClausePredSym = new HcPredicateSymbol.HornClauseTruePredicateSymbol(applicationTerm2.getFunction());
        this.mDontCareHornClausePredSym = new HcPredicateSymbol.HornClauseDontCarePredicateSymbol();
        this.mManagedScript.unlock((Object)this);
        this.mVersionsMap = new HashMap<TermVariable, Integer>();
        this.mPredSymNameToIndexToSortToHcHeadVar = new NestedMap3();
        this.mPredSymNameToIndexToSortToHcBodyVar = new NestedMap3();
        this.mTermVariableToHcBodyAuxVar = new HashMap<TermVariable, HcBodyAuxVar>();
        this.mTermVarToProgramVar = new HashMap<TermVariable, IProgramVar>();
        this.mSmtFunction2BoogieFunction = new HashMap<String, String>();
        this.mSkolemFunctions = new HashRelation3();
        this.mTermTransferrer = script == null ? null : new TermTransferrer(script, managedScript.getScript());
    }

    public TermVariable createFreshVersion(TermVariable termVariable) {
        int n = 1;
        if (this.mVersionsMap.containsKey(termVariable)) {
            n = this.mVersionsMap.get(termVariable) + 1;
        }
        return this.mManagedScript.constructFreshTermVariable(termVariable.getName() + n, termVariable.getSort());
    }

    public TermVariable createPrettyTermVariable(String string, Sort sort) {
        return this.mManagedScript.variable(string, sort);
    }

    public HcPredicateSymbol getOrConstructHornClausePredicateSymbol(ApplicationTerm applicationTerm) {
        ApplicationTerm applicationTerm2 = this.mTermTransferrer == null ? applicationTerm : (ApplicationTerm)this.mTermTransferrer.transform((Term)applicationTerm);
        FunctionSymbol functionSymbol = applicationTerm2.getFunction();
        Sort[] sortArray = functionSymbol.getParameterSorts();
        List<Sort> list = Arrays.asList(sortArray);
        return this.getOrConstructHornClausePredicateSymbol(functionSymbol, list);
    }

    public HcPredicateSymbol getOrConstructHornClausePredicateSymbol(String string, List<Sort> list) {
        try {
            this.mManagedScript.getScript().declareFun(string, list.toArray(new Sort[list.size()]), SmtSortUtils.getBoolSort((ManagedScript)this.mManagedScript));
        }
        catch (SMTLIBException sMTLIBException) {}
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        int n = 0;
        for (Sort sort : list) {
            arrayList.add(this.mManagedScript.variable("dummyVar" + n, sort));
            ++n;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)this.mManagedScript.getScript().term(string, arrayList.toArray(new Term[arrayList.size()]));
        return this.getOrConstructHornClausePredicateSymbol(applicationTerm);
    }

    private HcPredicateSymbol getOrConstructHornClausePredicateSymbol(FunctionSymbol functionSymbol, List<Sort> list) {
        HcPredicateSymbol hcPredicateSymbol = (HcPredicateSymbol)this.mNameToSortsToHornClausePredicateSymbol.get((Object)functionSymbol.getName(), list);
        if (hcPredicateSymbol == null) {
            hcPredicateSymbol = new HcPredicateSymbol(this, functionSymbol);
            this.mNameToSortsToHornClausePredicateSymbol.put((Object)functionSymbol.getName(), list, (Object)hcPredicateSymbol);
        }
        return hcPredicateSymbol;
    }

    public HcPredicateSymbol getFalseHornClausePredicateSymbol() {
        return this.mFalseHornClausePredSym;
    }

    public HcPredicateSymbol getTrueHornClausePredicateSymbol() {
        return this.mTrueHornClausePredSym;
    }

    public HcPredicateSymbol getDontCareHornClausePredicateSymbol() {
        return this.mDontCareHornClausePredSym;
    }

    public List<HcPredicateSymbol> getHcPredicateSymbols() {
        return this.mNameToSortsToHornClausePredicateSymbol.values().collect(Collectors.toList());
    }

    private Sort transferSort(Sort sort) {
        Sort sort2;
        Sort[] sortArray = this.transferSorts(sort.getArguments());
        String[] stringArray = sort.getIndices();
        try {
            sort2 = this.mManagedScript.getScript().sort(sort.getName(), stringArray, sortArray);
        }
        catch (SMTLIBException sMTLIBException) {
            if (sMTLIBException.getMessage().equals("Sort " + sort.getName() + " not declared")) {
                this.mManagedScript.getScript().declareSort(sort.getName(), sort.getArguments().length);
                sort2 = this.mManagedScript.getScript().sort(sort.getName(), sortArray);
            }
            throw sMTLIBException;
        }
        return sort2;
    }

    private Sort[] transferSorts(Sort[] sortArray) {
        Sort[] sortArray2 = new Sort[sortArray.length];
        int n = 0;
        while (n < sortArray.length) {
            sortArray2[n] = this.transferSort(sortArray[n]);
            ++n;
        }
        return sortArray2;
    }

    public HcHeadVar getHeadVar(HcPredicateSymbol hcPredicateSymbol, int n, Sort sort) {
        Sort sort2 = this.transferSort(sort);
        HcHeadVar hcHeadVar = (HcHeadVar)this.mPredSymNameToIndexToSortToHcHeadVar.get((Object)hcPredicateSymbol, (Object)n, (Object)sort2);
        assert (hcHeadVar != null);
        return hcHeadVar;
    }

    public HcHeadVar getOrConstructHeadVar(HcPredicateSymbol hcPredicateSymbol, int n, Sort sort, Object object) {
        Sort sort2 = this.transferSort(sort);
        HcHeadVar hcHeadVar = (HcHeadVar)this.mPredSymNameToIndexToSortToHcHeadVar.get((Object)hcPredicateSymbol, (Object)n, (Object)sort2);
        if (hcHeadVar == null) {
            String string = HornUtilConstants.computeNameForHcVar("hhv", hcPredicateSymbol, n, object.toString());
            this.mManagedScript.lock((Object)this);
            hcHeadVar = new HcHeadVar(string, hcPredicateSymbol, n, sort2, this.mManagedScript, (Object)this);
            this.mManagedScript.unlock((Object)this);
            this.mPredSymNameToIndexToSortToHcHeadVar.put((Object)hcPredicateSymbol, (Object)n, (Object)sort2, (Object)hcHeadVar);
            this.mTermVarToProgramVar.put(hcHeadVar.getTermVariable(), hcHeadVar);
        }
        return hcHeadVar;
    }

    public HcHeadVar getOrConstructHeadVar(HcPredicateSymbol hcPredicateSymbol, int n, IProgramVarOrConst iProgramVarOrConst) {
        return this.getOrConstructHeadVar(hcPredicateSymbol, n, iProgramVarOrConst.getSort(), iProgramVarOrConst);
    }

    public HcBodyVar getOrConstructBodyVar(HcPredicateSymbol hcPredicateSymbol, int n, Sort sort, Object object) {
        Sort sort2 = this.transferSort(sort);
        HcBodyVar hcBodyVar = (HcBodyVar)this.mPredSymNameToIndexToSortToHcBodyVar.get((Object)hcPredicateSymbol, (Object)n, (Object)sort2);
        if (hcBodyVar == null) {
            String string = HornUtilConstants.computeNameForHcVar("hbv", hcPredicateSymbol, n, object.toString());
            this.mManagedScript.lock((Object)this);
            hcBodyVar = new HcBodyVar(string, hcPredicateSymbol, n, sort2, this.mManagedScript, (Object)this);
            this.mManagedScript.unlock((Object)this);
            this.mPredSymNameToIndexToSortToHcBodyVar.put((Object)hcPredicateSymbol, (Object)n, (Object)sort2, (Object)hcBodyVar);
            this.mTermVarToProgramVar.put(hcBodyVar.getTermVariable(), hcBodyVar);
        }
        return hcBodyVar;
    }

    public HcBodyVar getOrConstructBodyVar(HcPredicateSymbol hcPredicateSymbol, int n, IProgramVarOrConst iProgramVarOrConst) {
        return this.getOrConstructBodyVar(hcPredicateSymbol, n, iProgramVarOrConst.getSort(), iProgramVarOrConst);
    }

    public HcBodyAuxVar getOrConstructBodyAuxVar(TermVariable termVariable, Object object) {
        HcBodyAuxVar hcBodyAuxVar = this.mTermVariableToHcBodyAuxVar.get(termVariable);
        if (hcBodyAuxVar == null) {
            hcBodyAuxVar = new HcBodyAuxVar(termVariable, this.mManagedScript, object);
            this.mTermVariableToHcBodyAuxVar.put(termVariable, hcBodyAuxVar);
            this.mTermVarToProgramVar.put(hcBodyAuxVar.getTermVariable(), hcBodyAuxVar);
        }
        return hcBodyAuxVar;
    }

    public IProgramFunction getProgramFun(FunctionSymbol functionSymbol) {
        throw new AssertionError();
    }

    public String translateToBoogieFunction(String string, IBoogieType iBoogieType) {
        return this.mSmtFunction2BoogieFunction.get(string);
    }

    public IProgramVar getProgramVar(TermVariable termVariable) {
        IProgramVar iProgramVar = this.mTermVarToProgramVar.get(termVariable);
        assert (iProgramVar != null);
        return iProgramVar;
    }

    public ILocation getLocation(IProgramVar iProgramVar) {
        return new BoogieLocation(iProgramVar.getGloballyUniqueId(), 0, 0, 0, 0);
    }

    public DeclarationInformation getDeclarationInformation(IProgramVar iProgramVar) {
        if (this.mGotoProcMode) {
            return new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, "gotoProc");
        }
        if (iProgramVar instanceof HcBodyVar) {
            return new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, iProgramVar.getProcedure());
        }
        if (iProgramVar instanceof HcHeadVar) {
            return new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, iProgramVar.getProcedure());
        }
        throw new AssertionError();
    }

    public String getMethodNameForPredSymbol(HcPredicateSymbol hcPredicateSymbol) {
        return HornUtilConstants.sanitzePredName(hcPredicateSymbol.getName());
    }

    public List<HcHeadVar> getHcHeadVarsForPredSym(HcPredicateSymbol hcPredicateSymbol, boolean bl) {
        ArrayList<HcHeadVar> arrayList = new ArrayList<HcHeadVar>();
        int n = 0;
        while (n < hcPredicateSymbol.getArity()) {
            Sort sort = hcPredicateSymbol.getParameterSorts().get(n);
            HcHeadVar hcHeadVar = bl ? this.getOrConstructHeadVar(hcPredicateSymbol, n, sort, sort) : this.getHeadVar(hcPredicateSymbol, n, sort);
            arrayList.add(hcHeadVar);
            ++n;
        }
        return arrayList;
    }

    public void announceSkolemFunctions(HashRelation3<String, Sort[], Sort> hashRelation3) {
        for (Triple triple : hashRelation3) {
            assert (!this.mSmtFunction2BoogieFunction.containsKey(triple.getFirst())) : "name clash";
            this.mSkolemFunctions.addTriple((Object)((String)triple.getFirst()), (Object)this.transferSorts((Sort[])triple.getSecond()), (Object)this.transferSort((Sort)triple.getThird()));
            this.mSmtFunction2BoogieFunction.put((String)triple.getFirst(), (String)triple.getFirst());
        }
    }

    public HashRelation3<String, Sort[], Sort> getSkolemFunctions() {
        return this.mSkolemFunctions;
    }

    public void setGotoProcMode(boolean bl) {
        this.mGotoProcMode = bl;
    }

    public ManagedScript getManagedScript() {
        return this.mManagedScript;
    }
}

