/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderTransformer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;

public class CsvProviderScale
implements ICsvProviderTransformer<String> {
    private final Map<String, Pair<Double, ScaleMode>> mColumn2Scale;

    public CsvProviderScale(Map<String, Pair<Double, ScaleMode>> map) {
        this.mColumn2Scale = map;
    }

    @Override
    public ICsvProvider<String> transform(ICsvProvider<String> iCsvProvider) {
        int n = -1;
        int n2 = iCsvProvider.getRowHeaders().size();
        for (String string : iCsvProvider.getColumnTitles()) {
            ++n;
            Pair<Double, ScaleMode> pair = this.mColumn2Scale.get(string);
            if (pair == null) continue;
            int n3 = 0;
            while (n3 < n2) {
                BigDecimal bigDecimal = new BigDecimal(iCsvProvider.getRow(n3).get(n));
                double d = CsvProviderScale.computeScale(bigDecimal, pair);
                iCsvProvider.getRow(n3).set(n, Double.toString(d));
                ++n3;
            }
        }
        return iCsvProvider;
    }

    private static double computeScale(BigDecimal bigDecimal, Pair<Double, ScaleMode> pair) {
        return switch (pair.getSecond()) {
            case ScaleMode.DIV_INT -> {
                BigDecimal var4_2 = BigDecimal.valueOf(pair.getFirst());
                if (var4_2 == BigDecimal.ZERO) {
                    yield Double.NaN;
                }
                BigDecimal var5_4 = bigDecimal.divide(var4_2, RoundingMode.HALF_UP);
                BigDecimal var6_5 = var5_4.setScale(0, RoundingMode.HALF_UP);
                yield var6_5.doubleValue();
            }
            default -> throw new IllegalArgumentException("Unknown scale mode: " + String.valueOf((Object)pair.getSecond()));
        };
    }

    public static enum ScaleMode {
        DIV_INT;

    }
}

