/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.List;
import java.util.function.Predicate;

public final class CastExpression
extends Expression {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(CastExpression.class);
    ACSLType castedType;
    Expression expression;

    public CastExpression(ACSLType aCSLType, Expression expression) {
        this.castedType = aCSLType;
        this.expression = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid CastExpression: " + String.valueOf(this);
    }

    public CastExpression(ACSLType aCSLType, ACSLType aCSLType2, Expression expression) {
        super(aCSLType);
        this.castedType = aCSLType2;
        this.expression = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid CastExpression: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CastExpression").append('[');
        stringBuffer.append(this.castedType);
        stringBuffer.append(',').append(this.expression);
        return stringBuffer.append(']').toString();
    }

    public ACSLType getCastedType() {
        return this.castedType;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.castedType);
        list.add(this.expression);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((Expression)this)) {
            return;
        }
        if (aCSLVisitor.visit(this)) {
            if (this.castedType != null) {
                this.castedType.accept(aCSLVisitor);
            }
            if (this.expression != null) {
                this.expression.accept(aCSLVisitor);
            }
            if (this.type != null) {
                this.type.accept(aCSLVisitor);
            }
        }
    }

    @Override
    public Expression accept(ACSLTransformer aCSLTransformer) {
        Expression expression = aCSLTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        ACSLType aCSLType = null;
        if (this.castedType != null) {
            aCSLType = this.castedType.accept(aCSLTransformer);
        }
        Expression expression2 = null;
        if (this.expression != null) {
            expression2 = this.expression.accept(aCSLTransformer);
        }
        ACSLType aCSLType2 = null;
        if (this.type != null) {
            aCSLType2 = this.type.accept(aCSLTransformer);
        }
        if (this.castedType != aCSLType || this.expression != expression2 || this.type != aCSLType2) {
            return new CastExpression(aCSLType2, aCSLType, expression2);
        }
        return this;
    }
}

