/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.List;
import java.util.function.Predicate;

public final class FieldAccessExpression
extends Expression {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(FieldAccessExpression.class);
    Expression struct;
    String field;

    public FieldAccessExpression(Expression expression, String string) {
        this.struct = expression;
        this.field = string;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid FieldAccessExpression: " + String.valueOf(this);
    }

    public FieldAccessExpression(ACSLType aCSLType, Expression expression, String string) {
        super(aCSLType);
        this.struct = expression;
        this.field = string;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid FieldAccessExpression: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FieldAccessExpression").append('[');
        stringBuffer.append(this.struct);
        stringBuffer.append(',').append(this.field);
        return stringBuffer.append(']').toString();
    }

    public Expression getStruct() {
        return this.struct;
    }

    public String getField() {
        return this.field;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.struct);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((Expression)this)) {
            return;
        }
        if (aCSLVisitor.visit(this)) {
            if (this.struct != null) {
                this.struct.accept(aCSLVisitor);
            }
            if (this.type != null) {
                this.type.accept(aCSLVisitor);
            }
        }
    }

    @Override
    public Expression accept(ACSLTransformer aCSLTransformer) {
        Expression expression = aCSLTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        Expression expression2 = null;
        if (this.struct != null) {
            expression2 = this.struct.accept(aCSLTransformer);
        }
        ACSLType aCSLType = null;
        if (this.type != null) {
            aCSLType = this.type.accept(aCSLTransformer);
        }
        if (this.struct != expression2 || this.type != aCSLType) {
            return new FieldAccessExpression(aCSLType, expression2, this.field);
        }
        return this;
    }
}

