/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie.req2pea;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.pea.BoogieBooleanExpressionDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import de.uni_freiburg.informatik.ultimate.lib.srparse.Durations;
import de.uni_freiburg.informatik.ultimate.lib.srparse.SrParseScope;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.DeclarationPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.pea2boogie.IReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.PeaResultUtil;
import de.uni_freiburg.informatik.ultimate.pea2boogie.req2pea.IReq2Pea;
import de.uni_freiburg.informatik.ultimate.pea2boogie.req2pea.IReq2PeaAnnotator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.req2pea.ReqCheckAnnotator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.translator.ReqSymboltableBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Req2Pea
implements IReq2Pea {
    private static final boolean ENABLE_DEBUG_LOGS = false;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final PeaResultUtil mResultUtil;
    private final List<PatternType.ReqPeas> mPattern2Peas;
    private final IReqSymbolTable mSymbolTable;
    private final boolean mHasErrors;
    private final Durations mDurations;

    public Req2Pea(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, List<DeclarationPattern> list, List<PatternType<?>> list2) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mResultUtil = new PeaResultUtil(this.mLogger, this.mServices);
        List<PatternType<?>> list3 = this.replacePrev(list2);
        ReqSymboltableBuilder reqSymboltableBuilder = new ReqSymboltableBuilder(this.mServices, this.mLogger);
        this.mDurations = new Durations();
        for (DeclarationPattern declarationPattern : list) {
            reqSymboltableBuilder.addInitPattern(declarationPattern);
            this.mDurations.addInitPattern(declarationPattern);
        }
        list2.stream().forEach(arg_0 -> ((Durations)this.mDurations).addNonInitPattern(arg_0));
        this.mPattern2Peas = this.generatePeas(list3, this.mDurations);
        for (PatternType.ReqPeas reqPeas : this.mPattern2Peas) {
            for (Object object : reqPeas.getCounterTrace2Pea()) {
                reqSymboltableBuilder.addPea(reqPeas.getPattern(), (PhaseEventAutomata)object.getValue());
            }
        }
        this.mSymbolTable = reqSymboltableBuilder.constructSymbolTable();
        Set<Map.Entry<String, ReqSymboltableBuilder.ErrorInfo>> set = reqSymboltableBuilder.getErrors();
        for (Map.Entry<String, ReqSymboltableBuilder.ErrorInfo> entry : set) {
            Object object;
            if (((ReqSymboltableBuilder.ErrorInfo)entry.getValue()).getType() == ReqSymboltableBuilder.ErrorType.SYNTAX_ERROR) {
                object = this.mSymbolTable.getLocations().get(((ReqSymboltableBuilder.ErrorInfo)entry.getValue()).getSource());
                this.mResultUtil.syntaxError((ILocation)object, ((ReqSymboltableBuilder.ErrorInfo)entry.getValue()).getMessage());
                continue;
            }
            object = ((ReqSymboltableBuilder.ErrorInfo)entry.getValue()).getType().toString() + " of " + (String)entry.getKey();
            this.mResultUtil.typeError(((ReqSymboltableBuilder.ErrorInfo)entry.getValue()).getSource(), (String)object);
        }
        this.mHasErrors = !set.isEmpty();
    }

    private List<PatternType<?>> replacePrev(List<PatternType<?>> list) {
        ArrayList arrayList = new ArrayList(list.size());
        CDDTransformer cDDTransformer = new CDDTransformer();
        for (PatternType<?> patternType : list) {
            SrParseScope srParseScope = patternType.getScope().create(cDDTransformer.transform(patternType.getScope().getCdd1()), cDDTransformer.transform(patternType.getScope().getCdd2()));
            List list2 = patternType.getCdds().stream().map(cDDTransformer::transform).collect(Collectors.toList());
            arrayList.add(patternType.create(srParseScope, patternType.getId(), list2, patternType.getDurations(), patternType.getDurationNames()));
        }
        return arrayList;
    }

    @Override
    public List<PatternType.ReqPeas> getReqPeas() {
        return Collections.unmodifiableList(this.mPattern2Peas);
    }

    @Override
    public IReqSymbolTable getSymboltable() {
        return this.mSymbolTable;
    }

    private List<PatternType.ReqPeas> generatePeas(List<PatternType<?>> list, Durations durations) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.mLogger.info((Object)String.format("Transforming %s requirements to PEAs", list.size()));
        HashMap<Class, Integer> hashMap = new HashMap<Class, Integer>();
        for (PatternType<?> object : list) {
            String string;
            PatternType.ReqPeas reqPeas;
            try {
                hashMap.compute(object.getClass(), (clazz, n) -> n == null ? 1 : n + 1);
                reqPeas = object.transformToPea(this.mLogger, durations);
            }
            catch (Exception exception) {
                string = exception.getMessage() == null ? exception.getClass().toString() : exception.getMessage();
                this.mResultUtil.transformationError(object, string);
                continue;
            }
            if (reqPeas.getCounterTrace2Pea().stream().map(Map.Entry::getValue).anyMatch(phaseEventAutomata -> phaseEventAutomata.getInit().size() == 0)) {
                this.mResultUtil.transformationError(object, "A PEA is missing its initial phase");
                continue;
            }
            PatternType.ReqPeas reqPeas2 = linkedHashMap.put(object, reqPeas);
            if (reqPeas2 == null) continue;
            string = String.format("Duplicate automata: %s and %s", reqPeas2.getCounterTrace2Pea().stream().map(entry -> ((PhaseEventAutomata)entry.getValue()).getName()).collect(Collectors.joining(",")), reqPeas.getCounterTrace2Pea().stream().map(Map.Entry::getValue).map(PhaseEventAutomata::getName).collect(Collectors.joining(",")));
            this.mResultUtil.transformationError(object, string);
        }
        this.mLogger.info((Object)"Following types of requirements were processed");
        for (Map.Entry entry2 : hashMap.entrySet()) {
            this.mLogger.info((Object)(String.valueOf(entry2.getKey()) + " : " + String.valueOf(entry2.getValue())));
        }
        this.mLogger.info((Object)String.format("Finished transforming %s requirements to PEAs", list.size()));
        return linkedHashMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public boolean hasErrors() {
        return this.mHasErrors;
    }

    @Override
    public void transform(IReq2Pea iReq2Pea) {
    }

    @Override
    public IReq2PeaAnnotator getAnnotator() {
        return new ReqCheckAnnotator(this.mServices, this.mLogger, this.mPattern2Peas, this.mSymbolTable, this.mDurations);
    }

    @Override
    public Durations getDurations() {
        return this.mDurations;
    }

    private static final class CDDTransformer {
        private CDDTransformer() {
        }

        public CDD transform(CDD cDD) {
            if (cDD == null || cDD == CDD.TRUE || cDD == CDD.FALSE) {
                return cDD;
            }
            CDD[] cDDArray = cDD.getChilds();
            int n = 0;
            while (n < cDDArray.length) {
                cDDArray[n] = this.transform(cDDArray[n]);
                ++n;
            }
            Decision decision = cDD.getDecision();
            if (decision instanceof BoogieBooleanExpressionDecision) {
                Expression expression = ((BoogieBooleanExpressionDecision)decision).getExpression().accept((GeneratedBoogieAstTransformer)new PrevFunctionApplicationTransformer());
                decision = BoogieBooleanExpressionDecision.createWithoutReduction((Expression)expression).getDecision();
            }
            return CDD.create((Decision)decision, (CDD[])cDDArray);
        }
    }

    private static final class PrevFunctionApplicationTransformer
    extends GeneratedBoogieAstTransformer {
        private PrevFunctionApplicationTransformer() {
        }

        public Expression transform(FunctionApplication functionApplication) {
            if (!"prev".equals(functionApplication.getIdentifier())) {
                return functionApplication;
            }
            Expression[] expressionArray = functionApplication.getArguments();
            if (expressionArray.length != 1) {
                throw new IllegalArgumentException("Unexpected number of arguments for FunctionApplication: " + expressionArray.length);
            }
            return expressionArray[0].accept((GeneratedBoogieAstTransformer)new PrevFunctionApplicationArgumentTransformer());
        }

        private static final class PrevFunctionApplicationArgumentTransformer
        extends GeneratedBoogieAstTransformer {
            private PrevFunctionApplicationArgumentTransformer() {
            }

            public Expression transform(FunctionApplication functionApplication) {
                if ("prev".equals(functionApplication.getIdentifier())) {
                    throw new IllegalArgumentException("Unsupported nested FunctionApplication prev().");
                }
                return functionApplication;
            }

            public Expression transform(IdentifierExpression identifierExpression) {
                return new IdentifierExpression(identifierExpression.getLoc(), identifierExpression.getType(), "'" + identifierExpression.getIdentifier(), identifierExpression.getDeclarationInformation());
            }
        }
    }
}

