/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.EqualityAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IndexAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IndexAnalyzer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.ArrayTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.ArrayWrite;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapEliminationPreAnalysis;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapEliminationSettings;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapEliminatorUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapTemplate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MapEliminator {
    private final IUltimateServiceProvider mServices;
    private final Script mScript;
    private final ManagedScript mManagedScript;
    private final ReplacementVarFactory mReplacementVarFactory;
    private final ILogger mLogger;
    private final IIcfgSymbolTable mSymbolTable;
    private final MapEliminationSettings mSettings;
    private final MapEliminationPreAnalysis mAnalysis;

    public MapEliminator(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable, ReplacementVarFactory replacementVarFactory, Collection<ModifiableTransFormula> collection, MapEliminationSettings mapEliminationSettings) {
        this.mSettings = mapEliminationSettings;
        this.mServices = iUltimateServiceProvider;
        this.mScript = managedScript.getScript();
        this.mLogger = iLogger;
        this.mLogger.info((Object)("Using MapEliminator with " + String.valueOf(this.mSettings)));
        this.mManagedScript = managedScript;
        this.mReplacementVarFactory = replacementVarFactory;
        this.mSymbolTable = iIcfgSymbolTable;
        this.mAnalysis = new MapEliminationPreAnalysis(managedScript, collection);
    }

    public ModifiableTransFormula eliminateMaps(ModifiableTransFormula modifiableTransFormula, EqualityAnalysisResult equalityAnalysisResult, EqualityAnalysisResult equalityAnalysisResult2) {
        ModifiableTransFormula modifiableTransFormula2 = new ModifiableTransFormula(modifiableTransFormula);
        Term term = modifiableTransFormula2.getFormula();
        if (!QuantifierUtils.isQuantifierFree((Term)term)) {
            throw new UnsupportedOperationException("Quantifiers are not supported");
        }
        if (!SmtUtils.isNNF((Term)term)) {
            throw new UnsupportedOperationException("Only formulae in NNF are supported");
        }
        HashRelation<MapTemplate, ArrayIndex> hashRelation = this.getLocalIndices(modifiableTransFormula2, this.mAnalysis.getLocalIndices(modifiableTransFormula));
        IndexAnalyzer indexAnalyzer = new IndexAnalyzer(term, this.mAnalysis.getIndexDoubletons(hashRelation), this.mSymbolTable, modifiableTransFormula2, equalityAnalysisResult, equalityAnalysisResult2, this.mLogger, this.mManagedScript);
        IndexAnalysisResult indexAnalysisResult = indexAnalyzer.getResult();
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        Term term2 = this.replaceStoreTerms(term, modifiableTransFormula2, indexAnalysisResult, hashSet);
        assert (!SmtUtils.containsFunctionApplication((Term)term2, (String)"store")) : "The formula contains still store-terms";
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(term2);
        arrayList.addAll(this.getAdditionalEqualities(hashRelation, indexAnalysisResult));
        if (!this.mSettings.onlyTrivialImplicationsForModifiedArguments()) {
            arrayList.addAll(this.getAllImplicationsForIndexAssignment(modifiableTransFormula2, indexAnalysisResult));
        }
        arrayList.addAll(indexAnalysisResult.constructListOfEqualities(this.mScript));
        if (this.mSettings.addInequalities()) {
            arrayList.addAll(indexAnalysisResult.constructListOfNotEquals(this.mScript));
        }
        Term term3 = this.replaceMapReads(modifiableTransFormula2, SmtUtils.and((Script)this.mScript, arrayList), hashSet);
        assert (SmtUtils.isArrayFree((Term)term3)) : "The formula contains still arrays";
        assert (!SmtUtils.containsUninterpretedFunctionApplication((Term)term3)) : "The formula contains still UFs";
        this.setFormulaAndSimplify(modifiableTransFormula2, term3, hashSet);
        return modifiableTransFormula2;
    }

    private HashRelation<MapTemplate, ArrayIndex> getLocalIndices(ModifiableTransFormula modifiableTransFormula, HashRelation<MapTemplate, ArrayIndex> hashRelation) {
        HashRelation hashRelation2 = new HashRelation();
        for (MapTemplate mapTemplate : hashRelation.getDomain()) {
            for (MapTemplate mapTemplate2 : this.getLocalTemplates(mapTemplate, modifiableTransFormula)) {
                for (ArrayIndex arrayIndex : hashRelation.getImage((Object)mapTemplate)) {
                    hashRelation2.addPair((Object)mapTemplate2, (Object)arrayIndex);
                }
            }
        }
        for (MapTemplate mapTemplate : this.mAnalysis.getAllTemplates()) {
            for (MapTemplate mapTemplate2 : this.getLocalTemplates(mapTemplate, modifiableTransFormula)) {
                for (ArrayIndex arrayIndex : this.getInAndOutVarIndices(this.mAnalysis.getIndices(mapTemplate), modifiableTransFormula)) {
                    hashRelation2.addPair((Object)mapTemplate2, (Object)arrayIndex);
                }
            }
        }
        return hashRelation2;
    }

    private Collection<MapTemplate> getLocalTemplates(MapTemplate mapTemplate, ModifiableTransFormula modifiableTransFormula) {
        if (mapTemplate instanceof ArrayTemplate) {
            Term term = (Term)mapTemplate.getIdentifier();
            ArrayTemplate arrayTemplate = new ArrayTemplate(MapEliminatorUtils.getInVarTerm(term, modifiableTransFormula, this.mManagedScript, this.mSymbolTable), this.mScript);
            ArrayTemplate arrayTemplate2 = new ArrayTemplate(MapEliminatorUtils.getOutVarTerm(term, modifiableTransFormula, this.mManagedScript, this.mSymbolTable), this.mScript);
            return Arrays.asList(arrayTemplate, arrayTemplate2);
        }
        return Arrays.asList(mapTemplate);
    }

    private List<Term> getAdditionalEqualities(HashRelation<MapTemplate, ArrayIndex> hashRelation, EqualityAnalysisResult equalityAnalysisResult) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (MapTemplate mapTemplate : hashRelation.getDomain()) {
            UnionFind unionFind = new UnionFind();
            Set set = hashRelation.getImage((Object)mapTemplate);
            ArrayIndex[] arrayIndexArray = set.toArray(new ArrayIndex[set.size()]);
            int n = 0;
            while (n < arrayIndexArray.length) {
                int n2 = n + 1;
                while (n2 < arrayIndexArray.length) {
                    if (MapEliminator.areIndicesEqual(arrayIndexArray[n], arrayIndexArray[n2], equalityAnalysisResult)) {
                        unionFind.findAndConstructEquivalenceClassIfNeeded((Object)arrayIndexArray[n]);
                        unionFind.findAndConstructEquivalenceClassIfNeeded((Object)arrayIndexArray[n2]);
                        unionFind.union((Object)arrayIndexArray[n], (Object)arrayIndexArray[n2]);
                    }
                    ++n2;
                }
                ++n;
            }
            for (ArrayIndex arrayIndex : unionFind.getAllRepresentatives()) {
                Term term = mapTemplate.getTerm(arrayIndex);
                if (term.getSort().isArraySort()) continue;
                for (ArrayIndex arrayIndex2 : unionFind.getEquivalenceClassMembers((Object)arrayIndex)) {
                    if (arrayIndex == arrayIndex2) continue;
                    Term term2 = mapTemplate.getTerm(arrayIndex2);
                    arrayList.add(SmtUtils.binaryEquality((Script)this.mScript, (Term)term, (Term)term2));
                }
            }
        }
        return arrayList;
    }

    private void setFormulaAndSimplify(ModifiableTransFormula modifiableTransFormula, Term term, Set<TermVariable> set) {
        Term term2;
        if (set.isEmpty()) {
            term2 = term;
        } else {
            Term term3 = SmtUtils.quantifier((Script)this.mScript, (int)0, set, (Term)term);
            term2 = PartialQuantifierElimination.eliminate((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (Term)term3, (SmtUtils.SimplificationTechnique)this.mSettings.getSimplificationTechnique());
            modifiableTransFormula.addAuxVars(set);
            set.clear();
        }
        modifiableTransFormula.setFormula(SmtUtils.simplify((ManagedScript)this.mManagedScript, (Term)term2, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)this.mSettings.getSimplificationTechnique()));
        MapEliminator.clearTransFormula(modifiableTransFormula);
    }

    private static void clearTransFormula(ModifiableTransFormula modifiableTransFormula) {
        Term term;
        ArrayList<IProgramVar> arrayList = new ArrayList<IProgramVar>();
        ArrayList<IProgramVar> arrayList2 = new ArrayList<IProgramVar>();
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(modifiableTransFormula.getFormula().getFreeVars()));
        List<TermVariable> list = modifiableTransFormula.getAuxVars().stream().filter(termVariable -> !hashSet.contains(termVariable)).collect(Collectors.toList());
        for (Map.Entry<IProgramVar, TermVariable> entry : modifiableTransFormula.getInVars().entrySet()) {
            term = (Term)entry.getValue();
            IProgramVar iProgramVar = entry.getKey();
            if (term.getSort().isArraySort()) {
                arrayList.add(iProgramVar);
                continue;
            }
            if (hashSet.contains(term) || modifiableTransFormula.getOutVars().get(iProgramVar) != term || SmtUtils.isConstant((Term)term)) continue;
            arrayList.add(iProgramVar);
            arrayList2.add(iProgramVar);
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : modifiableTransFormula.getOutVars().entrySet()) {
            term = (Term)entry.getValue();
            if (!term.getSort().isArraySort()) continue;
            arrayList2.add(entry.getKey());
        }
        arrayList.forEach(modifiableTransFormula::removeInVar);
        arrayList2.forEach(modifiableTransFormula::removeOutVar);
        list.forEach(modifiableTransFormula::removeAuxVar);
    }

    private Term replaceMapReads(ModifiableTransFormula modifiableTransFormula, Term term2, Set<TermVariable> set) {
        for (MapTemplate object2 : this.mAnalysis.getAllTemplates()) {
            for (ArrayIndex arrayIndex : this.mAnalysis.getIndices(object2)) {
                Term term3 = object2.getTerm(arrayIndex);
                MapEliminatorUtils.addReplacementVar(term3, modifiableTransFormula, this.mManagedScript, this.mReplacementVarFactory, this.mSymbolTable);
            }
        }
        Map<Term, Term> map = this.mAnalysis.findMapReads(term2).collect(Collectors.toMap(term -> term, term -> MapEliminatorUtils.getReplacementVar(term, modifiableTransFormula, this.mManagedScript, this.mReplacementVarFactory, set)));
        return Substitution.apply((ManagedScript)this.mManagedScript, map, (Term)term2);
    }

    private Term replaceStoreTerms(Term term, ModifiableTransFormula modifiableTransFormula, EqualityAnalysisResult equalityAnalysisResult, Set<TermVariable> set) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        ArrayList<Term> arrayList = new ArrayList<Term>();
        Term term2 = this.replaceArrayInequalities(term);
        for (MultiDimensionalSelect multiDimensionalSelect : MultiDimensionalSelect.extractSelectDeep((Term)term2)) {
            if (!SmtUtils.isFunctionApplication((Term)multiDimensionalSelect.getArray(), (String)"store") || SmtSortUtils.isArraySort((Sort)multiDimensionalSelect.getSort())) continue;
            Term term3 = multiDimensionalSelect.toTerm(this.mScript);
            hashMap.put(term3, this.replaceSelectStoreTerm(term3, modifiableTransFormula, equalityAnalysisResult, arrayList, set));
        }
        for (MultiDimensionalSelect multiDimensionalSelect : SmtUtils.extractApplicationTerms((String)"=", (Term)term2, (boolean)false)) {
            if (!((ApplicationTerm)multiDimensionalSelect).getParameters()[0].getSort().isArraySort()) continue;
            hashMap.put(multiDimensionalSelect, this.replaceArrayEquality((Term)multiDimensionalSelect, modifiableTransFormula, equalityAnalysisResult));
        }
        arrayList.add(term2);
        return Substitution.apply((ManagedScript)this.mManagedScript, hashMap, (Term)Substitution.apply((ManagedScript)this.mManagedScript, hashMap, (Term)SmtUtils.and((Script)this.mScript, arrayList)));
    }

    private Term replaceArrayInequalities(Term term) {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (Term term2 : SmtUtils.extractApplicationTerms((String)"not", (Term)term, (boolean)false)) {
            ApplicationTerm applicationTerm;
            Term term3 = ((ApplicationTerm)term2).getParameters()[0];
            if (!SmtUtils.isFunctionApplication((Term)term3, (String)"=") || !(applicationTerm = (ApplicationTerm)term3).getParameters()[0].getSort().isArraySort()) continue;
            hashMap.put(term2, this.mScript.term("true", new Term[0]));
        }
        return Substitution.apply((ManagedScript)this.mManagedScript, hashMap, (Term)term);
    }

    private TermVariable replaceSelectStoreTerm(Term term, ModifiableTransFormula modifiableTransFormula, EqualityAnalysisResult equalityAnalysisResult, List<Term> list, Set<TermVariable> set) {
        MultiDimensionalSelect multiDimensionalSelect = MultiDimensionalSelect.of((Term)term);
        ArrayIndex arrayIndex = multiDimensionalSelect.getIndex();
        ArrayWrite arrayWrite = new ArrayWrite(multiDimensionalSelect.getArray(), this.mScript);
        HashSet<ArrayIndex> hashSet = new HashSet<ArrayIndex>();
        TermVariable termVariable = MapEliminatorUtils.getAndAddAuxVar(term, set, this.mReplacementVarFactory);
        for (Pair<ArrayIndex, Term> term22 : arrayWrite.getIndexValuePairs()) {
            ArrayIndex arrayIndex2 = (ArrayIndex)term22.getFirst();
            if (hashSet.contains(arrayIndex2)) continue;
            Term term2 = (Term)term22.getSecond();
            Term term3 = this.indexEqualityInequalityImpliesValueEquality(arrayIndex, arrayIndex2, hashSet, (Term)termVariable, term2, equalityAnalysisResult, modifiableTransFormula);
            if (!SmtUtils.isFunctionApplication((Term)term3, (String)"or") || !this.mSettings.onlyTrivialImplicationsArrayWrite()) {
                list.add(term3);
            }
            hashSet.add(arrayIndex2);
        }
        Term term4 = SmtUtils.multiDimensionalSelect((Script)this.mScript, (Term)arrayWrite.getOldArray(), (ArrayIndex)arrayIndex);
        Term term5 = this.indexEqualityInequalityImpliesValueEquality(arrayIndex, arrayIndex, hashSet, (Term)termVariable, term4, equalityAnalysisResult, modifiableTransFormula);
        if (!SmtUtils.isFunctionApplication((Term)term5, (String)"or") || !this.mSettings.onlyTrivialImplicationsArrayWrite()) {
            list.add(term5);
        }
        return termVariable;
    }

    private Term replaceArrayEquality(Term term, ModifiableTransFormula modifiableTransFormula, EqualityAnalysisResult equalityAnalysisResult) {
        Term term2;
        Term term3;
        ArrayIndex arrayIndex;
        ArrayWrite arrayWrite = new ArrayWrite(term, this.mScript);
        Term term4 = arrayWrite.getOldArray();
        Term term5 = arrayWrite.getNewArray();
        if (!ModifiableTransFormulaUtils.allVariablesAreVisible(term4, modifiableTransFormula) || !ModifiableTransFormulaUtils.allVariablesAreVisible(term5, modifiableTransFormula) || SmtUtils.isFunctionApplication((Term)term5, (String)"store")) {
            return this.mScript.term("true", new Term[0]);
        }
        ArrayList<Term> arrayList = new ArrayList<Term>();
        boolean bl = modifiableTransFormula.getInVarsReverseMapping().containsKey(term4);
        boolean bl2 = modifiableTransFormula.getInVarsReverseMapping().containsKey(term5);
        Term term6 = ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, modifiableTransFormula, term4);
        Term term7 = ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, modifiableTransFormula, term5);
        ArrayTemplate arrayTemplate = new ArrayTemplate(term6, this.mScript);
        ArrayTemplate arrayTemplate2 = new ArrayTemplate(term7, this.mScript);
        HashSet<ArrayIndex> hashSet = new HashSet<ArrayIndex>();
        for (Pair<ArrayIndex, Term> arrayIndex2 : arrayWrite.getIndexValuePairs()) {
            arrayIndex = (ArrayIndex)arrayIndex2.getFirst();
            if (hashSet.contains(arrayIndex) || arrayIndex.size() != SmtUtils.getDimension((Sort)term4.getSort())) continue;
            term3 = (Term)arrayIndex2.getSecond();
            for (ArrayIndex arrayIndex3 : this.mAnalysis.getIndices(arrayTemplate2)) {
                Term term8;
                ArrayIndex arrayIndex4;
                Term term9;
                term2 = arrayTemplate2.getTerm(arrayIndex3);
                if (bl2) {
                    term9 = MapEliminatorUtils.getInVarTerm(term2, modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
                    arrayIndex4 = MapEliminatorUtils.getInVarIndex(arrayIndex3, modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
                } else {
                    term9 = MapEliminatorUtils.getOutVarTerm(term2, modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
                    arrayIndex4 = MapEliminatorUtils.getOutVarIndex(arrayIndex3, modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
                }
                if (hashSet.contains(arrayIndex4) || SmtUtils.isFunctionApplication((Term)(term8 = this.indexEqualityInequalityImpliesValueEquality(arrayIndex4, arrayIndex, hashSet, term9, term3, equalityAnalysisResult, modifiableTransFormula)), (String)"or") && this.mSettings.onlyTrivialImplicationsArrayWrite()) continue;
                arrayList.add(term8);
            }
            hashSet.add(arrayIndex);
        }
        for (ArrayIndex arrayIndex5 : this.mAnalysis.getIndices(arrayTemplate)) {
            ArrayIndex arrayIndex6;
            ArrayIndex arrayIndex3;
            if (bl) {
                arrayIndex = MapEliminatorUtils.getInVarTerm(arrayTemplate.getTerm(arrayIndex5), modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
                arrayIndex3 = MapEliminatorUtils.getInVarIndex(arrayIndex5, modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
            } else {
                arrayIndex = MapEliminatorUtils.getOutVarTerm(arrayTemplate.getTerm(arrayIndex5), modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
                arrayIndex3 = MapEliminatorUtils.getOutVarIndex(arrayIndex5, modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
            }
            if (bl2) {
                term3 = MapEliminatorUtils.getInVarTerm(arrayTemplate2.getTerm(arrayIndex5), modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
                arrayIndex6 = MapEliminatorUtils.getInVarIndex(arrayIndex5, modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
            } else {
                term3 = MapEliminatorUtils.getOutVarTerm(arrayTemplate2.getTerm(arrayIndex5), modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
                arrayIndex6 = MapEliminatorUtils.getOutVarIndex(arrayIndex5, modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
            }
            term2 = this.indexEqualityInequalityImpliesValueEquality(arrayIndex3, arrayIndex6, hashSet, term3, (Term)arrayIndex, equalityAnalysisResult, modifiableTransFormula);
            if (SmtUtils.isFunctionApplication((Term)term2, (String)"or") && this.mSettings.onlyTrivialImplicationsArrayWrite()) continue;
            arrayList.add(term2);
        }
        return SmtUtils.and((Script)this.mScript, arrayList);
    }

    private List<Term> getAllImplicationsForIndexAssignment(ModifiableTransFormula modifiableTransFormula, EqualityAnalysisResult equalityAnalysisResult) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (IProgramVar iProgramVar : modifiableTransFormula.getAssignedVars()) {
            Term term = ReplacementVarUtils.getDefinition(iProgramVar);
            for (ArrayIndex arrayIndex : this.mAnalysis.getIndicesWithVariable(term)) {
                ArrayIndex arrayIndex2 = MapEliminatorUtils.getInVarIndex(arrayIndex, modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
                ArrayIndex arrayIndex3 = MapEliminatorUtils.getOutVarIndex(arrayIndex, modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
                for (MapTemplate mapTemplate : this.mAnalysis.getTemplate(arrayIndex)) {
                    boolean bl = mapTemplate.isAssigned(modifiableTransFormula);
                    Term term2 = mapTemplate.getTerm(arrayIndex);
                    Term term3 = MapEliminatorUtils.getOutVarTerm(term2, modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
                    if (!bl) {
                        Term term4 = MapEliminatorUtils.getInVarTerm(term2, modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
                        arrayList.add(this.indexEqualityImpliesValueEquality(arrayIndex3, arrayIndex2, term3, term4, equalityAnalysisResult, modifiableTransFormula));
                    }
                    for (ArrayIndex arrayIndex4 : this.mAnalysis.getIndices(mapTemplate)) {
                        ArrayIndex arrayIndex5;
                        Term term5;
                        if (arrayIndex.equals((Object)arrayIndex4)) continue;
                        Term term6 = mapTemplate.getTerm(arrayIndex4);
                        if (!bl) {
                            term5 = MapEliminatorUtils.getInVarTerm(term6, modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
                            arrayIndex5 = MapEliminatorUtils.getInVarIndex(arrayIndex4, modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
                            arrayList.add(this.indexEqualityImpliesValueEquality(arrayIndex3, arrayIndex5, term3, term5, equalityAnalysisResult, modifiableTransFormula));
                        }
                        term5 = MapEliminatorUtils.getOutVarTerm(term6, modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
                        arrayIndex5 = MapEliminatorUtils.getOutVarIndex(arrayIndex4, modifiableTransFormula, this.mManagedScript, this.mSymbolTable);
                        arrayList.add(this.indexEqualityImpliesValueEquality(arrayIndex3, arrayIndex5, term3, term5, equalityAnalysisResult, modifiableTransFormula));
                    }
                }
            }
        }
        return arrayList;
    }

    private Collection<ArrayIndex> getInAndOutVarIndices(Set<ArrayIndex> set, ModifiableTransFormula modifiableTransFormula) {
        HashSet<ArrayIndex> hashSet = new HashSet<ArrayIndex>();
        for (ArrayIndex arrayIndex : set) {
            hashSet.add(MapEliminatorUtils.getInVarIndex(arrayIndex, modifiableTransFormula, this.mManagedScript, this.mSymbolTable));
            hashSet.add(MapEliminatorUtils.getOutVarIndex(arrayIndex, modifiableTransFormula, this.mManagedScript, this.mSymbolTable));
        }
        return hashSet;
    }

    public Set<Doubleton<Term>> getDoubletons() {
        return this.mAnalysis.getAllDoubletons();
    }

    private static boolean areIndicesEqual(ArrayIndex arrayIndex, ArrayIndex arrayIndex2, EqualityAnalysisResult equalityAnalysisResult) {
        if (arrayIndex.size() != arrayIndex2.size()) {
            return false;
        }
        int n = 0;
        while (n < arrayIndex.size()) {
            Term term;
            Term term2 = arrayIndex.get(n);
            if (term2 != (term = arrayIndex2.get(n)) && !equalityAnalysisResult.getEqualDoubletons().contains(new Doubleton((Object)term2, (Object)term))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private Term getEqualTerm(ArrayIndex arrayIndex, ArrayIndex arrayIndex2, EqualityAnalysisResult equalityAnalysisResult) {
        if (arrayIndex.size() != arrayIndex2.size()) {
            return this.mScript.term("false", new Term[0]);
        }
        ArrayList<Term> arrayList = new ArrayList<Term>();
        int n = 0;
        while (n < arrayIndex.size()) {
            Term term;
            Term term2 = arrayIndex.get(n);
            if (term2 != (term = arrayIndex2.get(n))) {
                Doubleton doubleton = new Doubleton((Object)term2, (Object)term);
                if (equalityAnalysisResult.getDistinctDoubletons().contains(doubleton)) {
                    return this.mScript.term("false", new Term[0]);
                }
                if (!equalityAnalysisResult.getEqualDoubletons().contains(doubleton)) {
                    arrayList.add(SmtUtils.binaryEquality((Script)this.mScript, (Term)term2, (Term)term));
                }
            }
            ++n;
        }
        return SmtUtils.and((Script)this.mScript, arrayList);
    }

    private Term indexEqualityInequalityImpliesValueEquality(ArrayIndex arrayIndex, ArrayIndex arrayIndex2, Collection<ArrayIndex> collection, Term term, Term term2, EqualityAnalysisResult equalityAnalysisResult, ModifiableTransFormula modifiableTransFormula) {
        List<TermVariable> list = Arrays.asList(modifiableTransFormula.getFormula().getFreeVars());
        Term term3 = Util.not((Script)this.mScript, (Term)this.getEqualTerm(arrayIndex, arrayIndex2, equalityAnalysisResult));
        List<TermVariable> list2 = Arrays.asList(term3.getFreeVars());
        if (SmtUtils.isTrueLiteral((Term)term3) || !list.containsAll(list2) && this.mSettings.onlyArgumentsInFormula()) {
            return this.mScript.term("true", new Term[0]);
        }
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(term3);
        for (ArrayIndex arrayIndex3 : collection) {
            Term term4 = this.getEqualTerm(arrayIndex, arrayIndex3, equalityAnalysisResult);
            List<TermVariable> list3 = Arrays.asList(term4.getFreeVars());
            if (SmtUtils.isTrueLiteral((Term)term4) || !list.containsAll(list3) && this.mSettings.onlyArgumentsInFormula()) {
                return this.mScript.term("true", new Term[0]);
            }
            arrayList.add(term4);
        }
        if (!term.getSort().equals(term2.getSort())) {
            throw new AssertionError((Object)String.format("%s tries to combine %s and %s", this.getClass().getSimpleName(), term.getSort(), term2.getSort()));
        }
        arrayList.add(SmtUtils.binaryEquality((Script)this.mScript, (Term)term, (Term)term2));
        return SmtUtils.or((Script)this.mScript, arrayList);
    }

    private Term indexEqualityImpliesValueEquality(ArrayIndex arrayIndex, ArrayIndex arrayIndex2, Term term, Term term2, EqualityAnalysisResult equalityAnalysisResult, ModifiableTransFormula modifiableTransFormula) {
        return this.indexEqualityInequalityImpliesValueEquality(arrayIndex, arrayIndex2, List.of(), term, term2, equalityAnalysisResult, modifiableTransFormula);
    }
}

