/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.IntvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.IVasrsAbstraction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IntVasrsAbstraction
implements IVasrsAbstraction<Integer> {
    private final IntvasrAbstraction mIntVasrAbstraction;
    private final Integer[][] mSimulationMatrix;
    private Set<Term> mStates;
    private final Set<Triple<Term, Pair<Integer[], Integer[]>, Term>> mTransitions;
    private Term mPreCon;
    private Term mPostCon;
    private final Map<IProgramVar, TermVariable> mInVars;
    private final Map<IProgramVar, TermVariable> mOutVars;

    public IntVasrsAbstraction(IntvasrAbstraction intvasrAbstraction, Set<Term> set, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        this.mIntVasrAbstraction = intvasrAbstraction;
        this.mSimulationMatrix = intvasrAbstraction.getSimulationMatrix();
        this.mStates = set;
        this.mTransitions = new HashSet<Triple<Term, Pair<Integer[], Integer[]>, Term>>();
        this.mPreCon = null;
        this.mPostCon = null;
        this.mInVars = map;
        this.mOutVars = map2;
    }

    public IntVasrsAbstraction(IntvasrAbstraction intvasrAbstraction, Set<Term> set, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2, Term term, Term term2) {
        this.mIntVasrAbstraction = intvasrAbstraction;
        this.mSimulationMatrix = intvasrAbstraction.getSimulationMatrix();
        this.mStates = set;
        this.mTransitions = new HashSet<Triple<Term, Pair<Integer[], Integer[]>, Term>>();
        this.mPreCon = term;
        this.mPostCon = term2;
        this.mInVars = map;
        this.mOutVars = map2;
    }

    @Override
    public void addTransition(Triple<Term, Pair<Integer[], Integer[]>, Term> triple) {
        this.mTransitions.add(triple);
    }

    @Override
    public Set<Term> getStates() {
        return this.mStates;
    }

    public IntvasrAbstraction getAbstraction() {
        return this.mIntVasrAbstraction;
    }

    @Override
    public Set<Triple<Term, Pair<Integer[], Integer[]>, Term>> getTransitions() {
        return this.mTransitions;
    }

    public Integer[][] getSimulationMatrix() {
        return this.mSimulationMatrix;
    }

    public void setStates(Set<Term> set) {
        this.mStates = set;
    }

    @Override
    public void setPreState(Term term) {
        this.mPreCon = term;
    }

    @Override
    public void setPostState(Term term) {
        this.mPostCon = term;
    }

    @Override
    public Term getPreState() {
        return this.mPreCon;
    }

    @Override
    public Term getPostState() {
        return this.mPostCon;
    }

    @Override
    public Map<IProgramVar, TermVariable> getInVars() {
        return this.mInVars;
    }

    @Override
    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.mOutVars;
    }

    @Override
    public void setPrePostStates() {
        HashSet<Term> hashSet = new HashSet<Term>(this.mStates);
        HashSet<Term> hashSet2 = new HashSet<Term>(this.mStates);
        for (Triple<Term, Pair<Integer[], Integer[]>, Term> triple : this.mTransitions) {
            if (triple.getFirst() == triple.getThird()) continue;
            hashSet.remove(triple.getFirst());
            hashSet2.remove(triple.getThird());
        }
        this.mPreCon = hashSet.toArray(new Term[1])[0];
        this.mPostCon = hashSet2.toArray(new Term[1])[0];
    }
}

