/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.InterpolantComputationStatus;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsFuns;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.TraceCheckReasonUnknown;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedInterpolantsBuilder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.RelevantVariables;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class InterpolatingTraceCheckCraig<L extends IAction>
extends InterpolatingTraceCheck<L> {
    private final boolean mInstantiateArrayExt;
    private final InterpolantComputationStatus mInterpolantComputationStatus;

    public InterpolatingTraceCheckCraig(IPredicate iPredicate, IPredicate iPredicate2, SortedMap<Integer, IPredicate> sortedMap, Counterexample<L> counterexample, IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit, ManagedScript managedScript, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier, ITraceCheckPreferences.AssertCodeBlockOrder assertCodeBlockOrder, boolean bl, boolean bl2, InterpolationTechnique interpolationTechnique, boolean bl3, SmtUtils.SimplificationTechnique simplificationTechnique, boolean bl4) {
        super(iPredicate, iPredicate2, sortedMap, counterexample, iUltimateServiceProvider, cfgSmtToolkit, managedScript, predicateFactory, iPredicateUnifier, assertCodeBlockOrder, bl, bl2, simplificationTechnique);
        if (interpolationTechnique == InterpolationTechnique.Craig_NestedInterpolation && assertCodeBlockOrder.getAssertCodeBlockOrderType() != ITraceCheckPreferences.AssertCodeBlockOrderType.NOT_INCREMENTALLY) {
            throw new UnsupportedOperationException("incremental assertion is not available for Craig_NestedInterpolation");
        }
        this.mInstantiateArrayExt = bl3;
        if (this.isCorrect() == Script.LBool.UNSAT) {
            InterpolantComputationStatus interpolantComputationStatus = new InterpolantComputationStatus();
            try {
                this.computeInterpolants(interpolationTechnique);
                this.mTraceCheckBenchmarkGenerator.reportSequenceOfInterpolants(Arrays.asList(this.mInterpolants), TraceCheckStatisticsGenerator.InterpolantType.Craig);
                if (!bl4) {
                    this.mTraceCheckBenchmarkGenerator.reportInterpolantComputation();
                    this.checkPerfectSequence(this.getIpp());
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                interpolantComputationStatus = this.handleUnsupportedOperationException(unsupportedOperationException);
            }
            catch (SMTLIBException sMTLIBException) {
                interpolantComputationStatus = this.handleSmtLibException(sMTLIBException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                interpolantComputationStatus = this.handleIllegalArgumentException(illegalArgumentException);
            }
            catch (NestedTraceCheckException nestedTraceCheckException) {
                interpolantComputationStatus = this.handleNestedTraceCheckException(nestedTraceCheckException);
            }
            this.mTraceCheckFinished = true;
            this.mInterpolantComputationStatus = interpolantComputationStatus;
        } else {
            this.mInterpolantComputationStatus = this.isCorrect() == Script.LBool.SAT ? new InterpolantComputationStatus(InterpolantComputationStatus.ItpErrorStatus.TRACE_FEASIBLE, null) : new InterpolantComputationStatus(InterpolantComputationStatus.ItpErrorStatus.SMT_SOLVER_CANNOT_INTERPOLATE_INPUT, null);
        }
    }

    public InterpolatingTraceCheckCraig(IPredicate iPredicate, IPredicate iPredicate2, SortedMap<Integer, IPredicate> sortedMap, Counterexample<L> counterexample, IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier, ITraceCheckPreferences.AssertCodeBlockOrder assertCodeBlockOrder, boolean bl, boolean bl2, InterpolationTechnique interpolationTechnique, boolean bl3, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this(iPredicate, iPredicate2, sortedMap, counterexample, iUltimateServiceProvider, cfgSmtToolkit, cfgSmtToolkit.getManagedScript(), predicateFactory, iPredicateUnifier, assertCodeBlockOrder, bl, bl2, interpolationTechnique, bl3, simplificationTechnique, false);
    }

    private InterpolantComputationStatus handleNestedTraceCheckException(NestedTraceCheckException nestedTraceCheckException) {
        InterpolantComputationStatus interpolantComputationStatus;
        Throwable throwable = nestedTraceCheckException.getCause();
        if (throwable instanceof UnsupportedOperationException) {
            interpolantComputationStatus = this.handleUnsupportedOperationException((UnsupportedOperationException)throwable);
        } else if (throwable instanceof SMTLIBException) {
            interpolantComputationStatus = this.handleSmtLibException((SMTLIBException)throwable);
        } else if (throwable instanceof IllegalArgumentException) {
            interpolantComputationStatus = this.handleIllegalArgumentException((IllegalArgumentException)throwable);
        } else {
            throw nestedTraceCheckException;
        }
        return interpolantComputationStatus;
    }

    private InterpolantComputationStatus handleUnsupportedOperationException(UnsupportedOperationException unsupportedOperationException) {
        String string = this.throwIfNoMessage(unsupportedOperationException);
        if (InterpolatingTraceCheckCraig.isMessageSolverCannotInterpolate(string)) {
            return new InterpolantComputationStatus(InterpolantComputationStatus.ItpErrorStatus.SMT_SOLVER_CANNOT_INTERPOLATE_INPUT, (Throwable)unsupportedOperationException);
        }
        throw unsupportedOperationException;
    }

    private InterpolantComputationStatus handleSmtLibException(SMTLIBException sMTLIBException) {
        if (!this.mServices.getProgressMonitorService().continueProcessing()) {
            throw new ToolchainCanceledException(this.getClass(), "while computing interpolants");
        }
        String string = this.throwIfNoMessage((RuntimeException)((Object)sMTLIBException));
        if ("Unsupported non-linear arithmetic".equals(string)) {
            return new InterpolantComputationStatus(InterpolantComputationStatus.ItpErrorStatus.SMT_SOLVER_CANNOT_INTERPOLATE_INPUT, (Throwable)sMTLIBException);
        }
        throw sMTLIBException;
    }

    private InterpolantComputationStatus handleIllegalArgumentException(IllegalArgumentException illegalArgumentException) {
        String string = this.throwIfNoMessage(illegalArgumentException);
        if (string.startsWith("Did not find overload for function =")) {
            return new InterpolantComputationStatus(InterpolantComputationStatus.ItpErrorStatus.SMT_SOLVER_CRASH, (Throwable)illegalArgumentException);
        }
        throw illegalArgumentException;
    }

    private String throwIfNoMessage(RuntimeException runtimeException) {
        String string = runtimeException.getMessage();
        if (string == null) {
            this.mLogger.fatal((Object)("Solver crashed with " + runtimeException.getClass().getSimpleName() + " whose message is null"));
            throw runtimeException;
        }
        return string;
    }

    private static boolean isMessageSolverCannotInterpolate(String string) {
        return string.startsWith("Cannot interpolate") || "@diff is unsupported".equals(string) || string.startsWith("Unknown lemma type!") || string.startsWith("Interpolation not supported for quantified formulae");
    }

    protected int getTotalNumberOfPredicates(InterpolationTechnique interpolationTechnique) {
        return this.mInterpolants != null ? this.mInterpolants.length : 0;
    }

    @Override
    protected void computeInterpolants(InterpolationTechnique interpolationTechnique) {
        this.mTraceCheckBenchmarkGenerator.start(TraceCheckStatisticsDefinitions.InterpolantComputationTime.toString());
        assert (this.mPredicateUnifier != null);
        assert (this.mPredicateUnifier.isRepresentative(this.mPrecondition));
        assert (this.mPredicateUnifier.isRepresentative(this.mPostcondition));
        for (IPredicate iPredicate : this.mPendingContexts.values()) {
            assert (this.mPredicateUnifier.isRepresentative(iPredicate));
        }
        try {
            try {
                switch (interpolationTechnique) {
                    case Craig_NestedInterpolation: {
                        this.computeInterpolantsRecursive();
                        break;
                    }
                    case Craig_TreeInterpolation: {
                        this.computeInterpolantsTree();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("unsupportedInterpolation");
                    }
                }
                this.mTraceCheckFinished = true;
            }
            catch (ToolchainCanceledException toolchainCanceledException) {
                toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), "constructing Craig interpolants"));
                throw toolchainCanceledException;
            }
        }
        finally {
            this.mTraceCheckBenchmarkGenerator.stop(TraceCheckStatisticsDefinitions.InterpolantComputationTime.toString());
        }
    }

    private boolean testRelevantVars() {
        boolean bl = true;
        RelevantVariables relevantVariables = new RelevantVariables(this.mNestedFormulas, this.mCsToolkit.getModifiableGlobalsTable());
        int n = 0;
        while (n < this.mInterpolants.length) {
            IPredicate iPredicate = this.mInterpolants[n];
            Set set = iPredicate.getVars();
            Set<IProgramVar> set2 = relevantVariables.getForwardRelevantVariables()[n + 1];
            Set<IProgramVar> set3 = relevantVariables.getBackwardRelevantVariables()[n + 1];
            if (!set2.containsAll(set)) {
                this.mLogger.warn((Object)"forward relevant variables wrong");
                bl = false;
            }
            if (!set3.containsAll(set)) {
                this.mLogger.warn((Object)"backward relevant variables wrong");
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    @Override
    public IPredicate[] getInterpolants() {
        if (this.isCorrect() == Script.LBool.UNSAT) {
            if (this.mInterpolants == null) {
                throw new AssertionError((Object)"No Interpolants");
            }
            assert (this.mInterpolants.length == this.mTrace.length() - 1);
            return this.mInterpolants;
        }
        throw new UnsupportedOperationException("Interpolants are only available if trace is correct.");
    }

    public InterpolantComputationStatus getInterpolantComputationStatus() {
        return this.mInterpolantComputationStatus;
    }

    private void computeInterpolantsTree() {
        if (this.mFeasibilityResult.getLBool() != Script.LBool.UNSAT) {
            throw new IllegalArgumentException("Interpolants only available if trace fulfills specification");
        }
        if (this.mInterpolants != null) {
            throw new AssertionError((Object)"You already computed interpolants");
        }
        Set<Integer> set = Collections.emptySet();
        NestedInterpolantsBuilder nestedInterpolantsBuilder = new NestedInterpolantsBuilder(this.mTcSmtManager, this.mTraceCheckLock, this.mAAA.getAnnotatedSsa(), this.mNsb.getConstants2BoogieVar(), this.mPredicateUnifier, (BasicPredicateFactory)this.mPredicateFactory, set, true, this.mServices, this, this.mCfgManagedScript, this.mInstantiateArrayExt, this.mSimplificationTechnique, this.mPrecondition, this.mPostcondition);
        this.mInterpolants = nestedInterpolantsBuilder.getNestedInterpolants();
        assert (TraceCheckUtils.checkInterpolantsInductivityForward(Arrays.asList(this.mInterpolants), (NestedWord<? extends IAction>)this.mTrace, this.mPrecondition, this.mPostcondition, this.mPendingContexts, "Craig", this.mCsToolkit, this.mLogger)) : "invalid Hoare triple in tree interpolants";
        assert (this.mInterpolants != null);
    }

    private void computeInterpolantsRecursive() {
        if (this.mFeasibilityResult.getLBool() != Script.LBool.UNSAT) {
            if (this.mFeasibilityResult.getLBool() == null) {
                throw new AssertionError((Object)"No trace check at the moment - no interpolants!");
            }
            throw new AssertionError((Object)"Interpolants only available if trace fulfills specification");
        }
        if (this.mInterpolants != null) {
            throw new AssertionError((Object)"You already computed interpolants");
        }
        List<Integer> list = InterpolatingTraceCheckCraig.computeOutermostNonPendingCallPosition(this.mTrace);
        Set<Integer> set = InterpolatingTraceCheckCraig.computeSkippedInnerProcedurePositions(this.mTrace, list);
        NestedInterpolantsBuilder nestedInterpolantsBuilder = new NestedInterpolantsBuilder(this.mTcSmtManager, this.mTraceCheckLock, this.mAAA.getAnnotatedSsa(), this.mNsb.getConstants2BoogieVar(), this.mPredicateUnifier, (BasicPredicateFactory)this.mPredicateFactory, set, false, this.mServices, this, this.mCfgManagedScript, this.mInstantiateArrayExt, this.mSimplificationTechnique, this.mPrecondition, this.mPostcondition);
        this.mInterpolants = nestedInterpolantsBuilder.getNestedInterpolants();
        IPredicate iPredicate = this.mPrecondition;
        IPredicate iPredicate2 = this.mPostcondition;
        for (Integer n : list) {
            TraceCheckReasonUnknown traceCheckReasonUnknown;
            int n2 = this.mTrace.getReturnPosition(n.intValue());
            NestedWord nestedWord = this.mTrace.getSubWord(n + 1, n2 + 1);
            IIcfgCallTransition iIcfgCallTransition = (IIcfgCallTransition)this.mTrace.getSymbol(n.intValue());
            String string = iIcfgCallTransition.getSucceedingProcedure();
            TermVarsFuns termVarsFuns = TraceCheckUtils.getOldVarsEquality(string, this.mCsToolkit.getModifiableGlobalsTable(), this.mCfgManagedScript);
            IPredicate iPredicate3 = this.mPredicateUnifier.getOrConstructPredicate(termVarsFuns.getFormula());
            TreeMap<Integer, IPredicate> treeMap = new TreeMap<Integer, IPredicate>();
            IPredicate iPredicate4 = n == 0 ? iPredicate : this.mInterpolants[n - 1];
            treeMap.put(nestedWord.length() - 1, iPredicate4);
            IPredicate iPredicate5 = n2 == this.mTrace.length() - 1 ? iPredicate2 : this.mInterpolants[n2];
            assert (iPredicate5 != null);
            this.mLogger.info((Object)("Compute interpolants for subsequence at non-pending call position " + String.valueOf(n)));
            InterpolatingTraceCheckCraig interpolatingTraceCheckCraig = new InterpolatingTraceCheckCraig(iPredicate3, iPredicate5, treeMap, new Counterexample(nestedWord), this.mServices, this.mCsToolkit, this.mTcSmtManager, this.mPredicateFactory, this.mPredicateUnifier, this.mAssertCodeBlockOrder, false, this.mTraceCheckBenchmarkGenerator.isCollectingInterpolantSequenceStatistics(), InterpolationTechnique.Craig_NestedInterpolation, this.mInstantiateArrayExt, this.mSimplificationTechnique, true);
            Script.LBool lBool = interpolatingTraceCheckCraig.isCorrect();
            if (lBool == Script.LBool.SAT) {
                throw new AssertionError((Object)"has to be unsat by construction, we do check only for interpolant computation");
            }
            if (lBool == Script.LBool.UNKNOWN) {
                if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                    throw new ToolchainCanceledException(this.getClass(), "construction of nested interpolants");
                }
                traceCheckReasonUnknown = interpolatingTraceCheckCraig.getTraceCheckReasonUnknown();
                throw new NestedTraceCheckException("UNKNOWN during nested interpolation. I don't know how to continue", traceCheckReasonUnknown.getException());
            }
            traceCheckReasonUnknown = interpolatingTraceCheckCraig.getInterpolants();
            assert (this.mPredicateFactory.isDontCare(this.mInterpolants[n]));
            this.mInterpolants[n.intValue()] = iPredicate3;
            int n3 = 0;
            while (n3 < ((TraceCheckReasonUnknown)traceCheckReasonUnknown).length) {
                assert (this.mPredicateFactory.isDontCare(this.mInterpolants[n + 1 + n3]));
                this.mInterpolants[n.intValue() + 1 + n3] = traceCheckReasonUnknown[n3];
                ++n3;
            }
        }
        assert (TraceCheckUtils.checkInterpolantsInductivityForward(Arrays.asList(this.mInterpolants), (NestedWord<? extends IAction>)this.mTrace, this.mPrecondition, this.mPostcondition, this.mPendingContexts, "Craig", this.mCsToolkit, this.mLogger)) : "invalid Hoare triple in nested interpolants";
    }

    private static <L> List<Integer> computeOutermostNonPendingCallPosition(NestedWord<L> nestedWord) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        while (n < nestedWord.length()) {
            if (nestedWord.isCallPosition(n) && !nestedWord.isPendingCall(n)) {
                arrayList.add(n);
                n = nestedWord.getReturnPosition(n);
            }
            ++n;
        }
        return arrayList;
    }

    private static <L> Set<Integer> computeSkippedInnerProcedurePositions(NestedWord<L> nestedWord, List<Integer> list) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n : list) {
            int n2 = nestedWord.getReturnPosition(n);
            int n3 = n;
            while (n3 < n2) {
                hashSet.add(n3);
                ++n3;
            }
        }
        return hashSet;
    }

    private static final class NestedTraceCheckException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NestedTraceCheckException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

