/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.StatisticsType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.UnaryNetOperation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.PetriNetUtils;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.CopySubnet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.FinitePrefix;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class RemoveUnreachable<LETTER, PLACE, CRSF extends IPetriNet2FiniteAutomatonStateFactory<PLACE> & INwaInclusionStateFactory<PLACE>>
extends UnaryNetOperation<LETTER, PLACE, CRSF> {
    private static final boolean DEBUG_COMPUTE_REMOVED_TRANSITIONS = false;
    private final IPetriNet<LETTER, PLACE> mOperand;
    private final BoundedPetriNet<LETTER, PLACE> mResult;
    private final Set<Transition<LETTER, PLACE>> mReachableTransitions;

    public RemoveUnreachable(AutomataLibraryServices automataLibraryServices, IPetriNet<LETTER, PLACE> iPetriNet) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        this(automataLibraryServices, iPetriNet, null);
    }

    public RemoveUnreachable(AutomataLibraryServices automataLibraryServices, IPetriNet<LETTER, PLACE> iPetriNet, Set<Transition<LETTER, PLACE>> set) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        super(automataLibraryServices);
        this.mOperand = iPetriNet;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mReachableTransitions = set == null ? this.computeReachableTransitions() : set;
        this.mResult = CopySubnet.copy(automataLibraryServices, this.mOperand, this.mReachableTransitions);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String exitMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Finished " + this.getOperationName() + ".");
        stringBuilder.append(" ");
        stringBuilder.append("Removed ");
        stringBuilder.append(this.computeRemovedPlaces() + " of " + this.mOperand.getPlaces().size() + " places");
        stringBuilder.append(", ");
        stringBuilder.append(this.computeRemovedTransitions() + " of " + this.mOperand.getTransitions().size() + " transitions");
        stringBuilder.append(", ");
        stringBuilder.append(this.computeRemovedFlow() + " of " + this.mOperand.flowSize() + " flow.");
        return stringBuilder.toString();
    }

    private Set<Transition<LETTER, PLACE>> computeReachableTransitions() throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        try {
            Object object = new FinitePrefix<LETTER, PLACE>(this.mServices, this.mOperand).getResult();
            return RemoveUnreachable.reachableTransitions(object);
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), "analyzing net that has " + this.mOperand.getPlaces().size() + " and " + this.mOperand.getTransitions().size() + " transistions.");
            automataOperationCanceledException.addRunningTaskInfo(runningTaskInfo);
            throw automataOperationCanceledException;
        }
    }

    public static <LETTER, PLACE> Set<Transition<LETTER, PLACE>> reachableTransitions(BranchingProcess<LETTER, PLACE> branchingProcess) {
        return branchingProcess.getEvents().stream().map(Event::getTransition).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public BoundedPetriNet<LETTER, PLACE> getResult() {
        return this.mResult;
    }

    @Override
    protected IPetriNet<LETTER, PLACE> getOperand() {
        return this.mOperand;
    }

    private int computeRemovedPlaces() {
        return this.mOperand.getPlaces().size() - this.mResult.getPlaces().size();
    }

    private int computeRemovedTransitions() {
        return this.mOperand.getTransitions().size() - this.mResult.getTransitions().size();
    }

    private int computeRemovedFlow() {
        return this.mOperand.flowSize() - this.mResult.flowSize();
    }

    @Override
    public boolean checkResult(CRSF CRSF) throws AutomataLibraryException {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Testing correctness of " + this.getOperationName()));
        }
        boolean bl = PetriNetUtils.isEquivalent(this.mServices, CRSF, this.mOperand, this.mResult);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        }
        return bl;
    }

    @Override
    public AutomataOperationStatistics getAutomataOperationStatistics() {
        AutomataOperationStatistics automataOperationStatistics = new AutomataOperationStatistics();
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_REMOVED_PLACES, this.computeRemovedPlaces());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_REMOVED_TRANSITIONS, this.computeRemovedTransitions());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_REMOVED_FLOW, this.computeRemovedFlow());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_ALPHABET, this.mResult.getAlphabet().size());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_PLACES, this.mResult.getPlaces().size());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_TRANSITIONS, this.mResult.getTransitions().size());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_FLOW, this.mResult.flowSize());
        return automataOperationStatistics;
    }
}

