/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.core.model.models.IDirectedGraph;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Function;
import java.util.stream.Stream;

public class GraphToTgf<N> {
    private final StringBuilder mTgfNodes = new StringBuilder();
    private final StringBuilder mTgfEdges = new StringBuilder();
    private final Map<N, Integer> mVisitedNodeToId = new HashMap<N, Integer>();
    private final Queue<N> mWorklist = new ArrayDeque<N>();
    private final Function<N, Object> mLabelOf;
    private final Function<N, Collection<N>> mSuccessorsOf;
    private final Function<N, Collection<N>> mPredecessorsOf;

    public GraphToTgf(Function<N, Collection<N>> function, Function<N, Collection<N>> function2, Function<N, Object> function3) {
        this.mSuccessorsOf = function;
        this.mPredecessorsOf = function2;
        this.mLabelOf = function3;
    }

    public static <GN extends IDirectedGraph<GN, ?>> GraphToTgf<GN> graph(Function<GN, Object> function) {
        return new GraphToTgf<IDirectedGraph>(IDirectedGraph::getOutgoingNodes, IDirectedGraph::getIncomingNodes, function);
    }

    public static <GN extends IDirectedGraph<GN, ?>> GraphToTgf<GN> graph(GN GN) {
        return GraphToTgf.graph(Object::toString).includeComponentOf((Function<IDirectedGraph, Object>)GN);
    }

    public String getTgf() {
        return String.valueOf(this.mTgfNodes) + "#\n" + String.valueOf(this.mTgfEdges);
    }

    public GraphToTgf<N> includeComponentOf(N n) {
        if (this.isUnvisited(n)) {
            this.visit(n);
        }
        while (!this.mWorklist.isEmpty()) {
            N n2 = this.mWorklist.remove();
            this.visitNeighbors(n2);
            this.addEdges(n2);
        }
        return this;
    }

    public GraphToTgf<N> includeComponentsOf(Collection<N> collection) {
        for (N n : collection) {
            this.includeComponentOf(n);
        }
        return this;
    }

    private void visitNeighbors(N n) {
        Stream.concat(this.mPredecessorsOf.apply(n).stream(), this.mSuccessorsOf.apply(n).stream()).filter(this::isUnvisited).forEach(this::visit);
    }

    private int visit(N n) {
        int n2 = this.mVisitedNodeToId.size();
        this.mVisitedNodeToId.put(n, n2);
        this.mTgfNodes.append(n2).append(' ').append(this.mLabelOf.apply(n)).append("\n");
        this.mWorklist.add(n);
        return n2;
    }

    private void addEdges(N n) {
        int n2 = this.idOf(n);
        this.mPredecessorsOf.apply(n).forEach(object -> this.addEdge(n2, this.idOf(object), "backward"));
        this.mSuccessorsOf.apply(n).forEach(object -> this.addEdge(n2, this.idOf(object), "forward"));
    }

    private void addEdge(int n, int n2, String string) {
        this.mTgfEdges.append(n).append(' ').append(n2).append(" ").append(string).append("\n");
    }

    private int idOf(N n) {
        return this.mVisitedNodeToId.get(n);
    }

    private boolean isUnvisited(N n) {
        return !this.mVisitedNodeToId.containsKey(n);
    }
}

