/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.type;

import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;

public class BoogieFunctionSignature {
    private final int typeArgCount;
    private final String[] paramNames;
    private final String resultName;
    private final BoogieType[] paramTypes;
    private final BoogieType resultType;

    public BoogieFunctionSignature(int n, String[] stringArray, BoogieType[] boogieTypeArray, String string, BoogieType boogieType) {
        this.typeArgCount = n;
        this.paramNames = stringArray;
        this.paramTypes = boogieTypeArray;
        this.resultName = string;
        this.resultType = boogieType;
    }

    public int getTypeArgCount() {
        return this.typeArgCount;
    }

    public int getParamCount() {
        return this.paramTypes.length;
    }

    public String getParamName(int n) {
        return this.paramNames[n];
    }

    public BoogieType getParamType(int n) {
        return this.paramTypes[n];
    }

    public BoogieType getResultType() {
        return this.resultType;
    }

    public String toString() {
        int n;
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.typeArgCount > 0) {
            stringBuilder.append("<");
            string = "";
            n = 0;
            while (n < this.typeArgCount) {
                stringBuilder.append(string).append("$" + n);
                string = ",";
                ++n;
            }
            stringBuilder.append(">");
        }
        stringBuilder.append("(");
        string = "";
        n = 0;
        while (n < this.paramTypes.length) {
            stringBuilder.append(string);
            if (this.paramNames[n] != null) {
                stringBuilder.append(this.paramNames[n]).append(":");
            }
            stringBuilder.append(this.paramTypes[n].toString(this.typeArgCount, false));
            string = ", ";
            ++n;
        }
        stringBuilder.append(") returns (");
        if (this.resultName != null) {
            stringBuilder.append(this.resultName).append(":");
        }
        stringBuilder.append(this.resultType.toString(this.typeArgCount, false));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

