/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class QuantifierSequence {
    private final ManagedScript mMgdScript;
    private final List<QuantifiedVariables> mQuantifierBlocks;
    private Term mInnerTerm;

    public QuantifierSequence(ManagedScript managedScript, Term term, List<QuantifiedVariables> list) {
        this.mMgdScript = managedScript;
        this.mInnerTerm = term;
        this.mQuantifierBlocks = list;
    }

    public QuantifierSequence(ManagedScript managedScript, Term term) {
        this.mMgdScript = managedScript;
        this.mQuantifierBlocks = new ArrayList<QuantifiedVariables>();
        Term term2 = term;
        while (term2 instanceof QuantifiedFormula) {
            QuantifiedFormula object = (QuantifiedFormula)term2;
            Set<TermVariable> set = SmtUtils.projectToFreeVars(new HashSet<TermVariable>(Arrays.asList(object.getVariables())), object.getSubformula());
            if (!set.isEmpty()) {
                int n = object.getQuantifier();
                if (this.mQuantifierBlocks.isEmpty() || this.mQuantifierBlocks.get(this.mQuantifierBlocks.size() - 1).getQuantifier() != n) {
                    var7_9 = new QuantifiedVariables(object.getQuantifier(), set);
                    this.mQuantifierBlocks.add(var7_9);
                } else {
                    var7_9 = this.mQuantifierBlocks.remove(this.mQuantifierBlocks.size() - 1);
                    HashSet<TermVariable> hashSet = new HashSet<TermVariable>(var7_9.getVariables());
                    hashSet.addAll((Collection<TermVariable>)set);
                    this.mQuantifierBlocks.add(new QuantifiedVariables(n, hashSet));
                }
            }
            term2 = object.getSubformula();
        }
        for (QuantifiedVariables quantifiedVariables : this.mQuantifierBlocks) {
            if (!quantifiedVariables.getVariables().isEmpty()) continue;
            throw new IllegalArgumentException("empty set not allowed");
        }
        this.mInnerTerm = term2;
    }

    public static Term prependQuantifierSequence(Script script, List<QuantifiedVariables> list, Term term) {
        Term term2 = term;
        int n = list.size() - 1;
        while (n >= 0) {
            QuantifiedVariables quantifiedVariables = list.get(n);
            term2 = script.quantifier(quantifiedVariables.getQuantifier(), quantifiedVariables.getVariables().toArray(new TermVariable[quantifiedVariables.getVariables().size()]), term2, (Term[][])new Term[0][]);
            --n;
        }
        return term2;
    }

    public Term getInnerTerm() {
        return this.mInnerTerm;
    }

    public Term toTerm() {
        return QuantifierSequence.prependQuantifierSequence(this.mMgdScript.getScript(), this.mQuantifierBlocks, this.mInnerTerm);
    }

    public void replace(Set<TermVariable> set, ManagedScript managedScript, String string) {
        Set set2 = set.stream().map(TermVariable::getName).collect(Collectors.toSet());
        HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
        for (QuantifiedVariables quantifiedVariables : this.mQuantifierBlocks) {
            for (TermVariable termVariable : new ArrayList<TermVariable>(quantifiedVariables.getVariables())) {
                if (!set2.contains(termVariable.getName())) continue;
                TermVariable termVariable2 = managedScript.constructFreshTermVariable(string, termVariable.getSort());
                hashMap.put(termVariable, termVariable2);
                quantifiedVariables.mVariables.remove(termVariable);
                quantifiedVariables.mVariables.add(termVariable2);
            }
        }
        this.mInnerTerm = Substitution.apply(this.mMgdScript, hashMap, this.mInnerTerm);
    }

    public static Term mergeQuantifierSequences(ManagedScript managedScript, String string, QuantifierSequence[] quantifierSequenceArray, HashSet<TermVariable> hashSet) {
        Term term;
        int n;
        Arrays.sort(quantifierSequenceArray, Collections.reverseOrder(Comparator.comparing(QuantifierSequence::getNumberOfQuantifierBlocks)));
        QuantifierSequence quantifierSequence = quantifierSequenceArray[0];
        ArrayList<QuantifiedVariables> arrayList = new ArrayList<QuantifiedVariables>(quantifierSequence.getNumberOfQuantifierBlocks());
        Term[] termArray = new Term[quantifierSequenceArray.length];
        int n2 = 0;
        while (n2 < quantifierSequence.getNumberOfQuantifierBlocks()) {
            n = quantifierSequence.getQuantifierBlocks().get(n2).getQuantifier();
            arrayList.add(new QuantifiedVariables(n, new HashSet<TermVariable>()));
            ++n2;
        }
        assert (arrayList.size() == quantifierSequence.getNumberOfQuantifierBlocks());
        HashSet<TermVariable> hashSet2 = new HashSet<TermVariable>(hashSet);
        n = 0;
        while (n < quantifierSequenceArray.length) {
            quantifierSequenceArray[n].replace(hashSet2, managedScript, "prenex");
            for (QuantifiedVariables object2 : quantifierSequenceArray[n].getQuantifierBlocks()) {
                hashSet2.addAll(object2.getVariables());
            }
            termArray[n] = quantifierSequenceArray[n].getInnerTerm();
            if (quantifierSequenceArray[n].getNumberOfQuantifierBlocks() > 0) {
                QuantifierSequence.integrateQuantifierBlocks(arrayList, quantifierSequenceArray[n].getQuantifierBlocks());
            }
            ++n;
        }
        for (QuantifiedVariables quantifiedVariables : arrayList) {
            if (!quantifiedVariables.getVariables().isEmpty()) continue;
            throw new IllegalArgumentException("empty set not allowed");
        }
        if (string.equals("and")) {
            term = SmtUtils.and(managedScript.getScript(), termArray);
        } else if (string.equals("or")) {
            term = SmtUtils.or(managedScript.getScript(), termArray);
        } else {
            throw new IllegalArgumentException("unsupported " + string);
        }
        Term term2 = QuantifierSequence.prependQuantifierSequence(managedScript.getScript(), arrayList, term);
        return term2;
    }

    private static void integrateQuantifierBlocks(List<QuantifiedVariables> list, List<QuantifiedVariables> list2) {
        int n;
        int n2;
        int n3 = list.get(list.size() - 1).getQuantifier();
        if (n3 == (n2 = list2.get(list2.size() - 1).getQuantifier())) {
            n = list.size() - list2.size();
        } else if (list.size() == list2.size()) {
            list.add(new QuantifiedVariables(n2, new HashSet<TermVariable>()));
            n = list.size() - list2.size();
        } else {
            n = list.size() - list2.size() - 1;
        }
        assert (n >= 0);
        n3 = 0;
        while (n3 < list2.size()) {
            assert (list.get(n3 + n).getQuantifier() == list2.get(n3).getQuantifier()) : "wrong offset";
            QuantifiedVariables quantifiedVariables = list.get(n3 + n);
            list.set(n3 + n, quantifiedVariables.addVariables(list2.get(n3).getVariables()));
            ++n3;
        }
    }

    public List<QuantifiedVariables> getQuantifierBlocks() {
        return Collections.unmodifiableList(this.mQuantifierBlocks);
    }

    public int getNumberOfQuantifierBlocks() {
        return this.mQuantifierBlocks.size();
    }

    public String toString() {
        return String.valueOf(this.mQuantifierBlocks) + " " + String.valueOf(this.mInnerTerm);
    }

    public String buildQuantifierSequenceStringRepresentation() {
        StringBuilder stringBuilder = new StringBuilder();
        for (QuantifiedVariables quantifiedVariables : this.mQuantifierBlocks) {
            stringBuilder.append(QuantifierUtils.getAsciiAbbreviation(quantifiedVariables.getQuantifier()));
        }
        return stringBuilder.toString();
    }

    public static class QuantifiedVariables {
        private final int mQuantifier;
        private final Set<TermVariable> mVariables;

        public QuantifiedVariables(int n, Set<TermVariable> set) {
            this.mQuantifier = n;
            this.mVariables = set;
        }

        public int getQuantifier() {
            return this.mQuantifier;
        }

        public Set<TermVariable> getVariables() {
            return Collections.unmodifiableSet(this.mVariables);
        }

        public String toString() {
            return (this.mQuantifier == 0 ? "exists" : "forall") + String.valueOf(this.mVariables) + ". ";
        }

        public QuantifiedVariables addVariables(Collection<TermVariable> collection) {
            LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>(this.mVariables);
            linkedHashSet.addAll(collection);
            return new QuantifiedVariables(this.mQuantifier, linkedHashSet);
        }
    }
}

