/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.xnf;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.xnf.Cnf;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.xnf.Dnf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class XnfUtils {
    private XnfUtils() {
    }

    static <E> Dnf<E> expandConjunctionSingle(Dnf<E> dnf, Dnf<E> dnf2) {
        Dnf dnf3 = new Dnf();
        for (Collection collection : dnf) {
            for (Collection collection2 : dnf2) {
                ArrayList arrayList = new ArrayList(collection);
                arrayList.addAll(collection2);
                dnf3.add(arrayList);
            }
        }
        return dnf3;
    }

    @SafeVarargs
    public static <E> Dnf<E> and(IUltimateServiceProvider iUltimateServiceProvider, Dnf<E> ... dnfArray) {
        boolean bl = true;
        Dnf<E> dnf = null;
        Dnf<E>[] dnfArray2 = dnfArray;
        int n = dnfArray.length;
        int n2 = 0;
        while (n2 < n) {
            Dnf<E> dnf2 = dnfArray2[n2];
            if (!iUltimateServiceProvider.getProgressMonitorService().continueProcessing()) {
                throw new ToolchainCanceledException(XnfUtils.class, "transforming conjunction of length " + dnfArray.length + " to DNF");
            }
            if (bl) {
                dnf = dnf2;
                bl = false;
            } else {
                dnf = XnfUtils.expandConjunctionSingle(dnf2, dnf);
            }
            ++n2;
        }
        return dnf;
    }

    static <E> Dnf<E> expandCnfToDnf(IUltimateServiceProvider iUltimateServiceProvider, Cnf<E> cnf) {
        if (cnf.isEmpty()) {
            List list = Collections.emptyList();
            return new Dnf(list);
        }
        boolean bl = true;
        Dnf dnf = null;
        for (Collection collection : cnf) {
            if (!iUltimateServiceProvider.getProgressMonitorService().continueProcessing()) {
                throw new ToolchainCanceledException(XnfUtils.class, "transforming CNF with " + cnf.size() + "conjuncts to DNF");
            }
            if (bl) {
                dnf = new Dnf();
                for (Object e : collection) {
                    ArrayList arrayList = new ArrayList();
                    arrayList.add(e);
                    dnf.add(arrayList);
                }
                bl = false;
                continue;
            }
            dnf = XnfUtils.expandCnfToDnfSingle(iUltimateServiceProvider, dnf, collection);
        }
        assert (dnf != null);
        return dnf;
    }

    static <E> Dnf<E> expandCnfToDnfSingle(IUltimateServiceProvider iUltimateServiceProvider, Dnf<E> dnf, Collection<E> collection) {
        Dnf dnf2 = new Dnf();
        for (Collection collection2 : dnf) {
            for (E e : collection) {
                if (!iUltimateServiceProvider.getProgressMonitorService().continueProcessing()) {
                    throw new ToolchainCanceledException(XnfUtils.class, "transforming CNF to DNF");
                }
                ArrayList<E> arrayList = new ArrayList<E>(collection2);
                arrayList.add(e);
                dnf2.add(arrayList);
            }
        }
        return dnf2;
    }
}

