/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.source.smtparser.chc;

import de.uni_freiburg.informatik.ultimate.lib.chc.HcHeadVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.TermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.source.smtparser.chc.HornClauseBody;
import de.uni_freiburg.informatik.ultimate.source.smtparser.chc.HornClauseParserScript;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class HornClauseHead {
    private final HornClauseBody mBody;
    private ApplicationTerm mHead;
    private final HornClauseParserScript mParserScript;

    public HornClauseHead(HornClauseParserScript hornClauseParserScript) {
        this.mBody = new HornClauseBody(hornClauseParserScript);
        this.mParserScript = hornClauseParserScript;
    }

    public void addPredicateToBody(ApplicationTerm applicationTerm) {
        this.mBody.addPredicate(applicationTerm);
    }

    public HornClause convertToHornClause(ManagedScript managedScript, HcSymbolTable hcSymbolTable, Script script) {
        HcPredicateSymbol hcPredicateSymbol = this.mHead == null ? null : hcSymbolTable.getOrConstructHornClausePredicateSymbol(this.mHead);
        List<HcPredicateSymbol> list = this.mBody.getPredicates(hcSymbolTable);
        Object object = new TermTransferrer(script, managedScript.getScript());
        this.mHead = this.mHead == null ? null : (ApplicationTerm)object.transform((Term)this.mHead);
        this.mBody.transformTerms(arg_0 -> ((TermTransferrer)object).transform(arg_0));
        object = this.normalizeVariables(hcSymbolTable, managedScript);
        List<List<Term>> list2 = this.mBody.getPredicateToVars(hcSymbolTable);
        if (this.mHead == null) {
            return new HornClause(managedScript, hcSymbolTable, this.getTransitionFormula(managedScript.getScript()), list, list2, (Set)object);
        }
        List list3 = hcSymbolTable.getHcHeadVarsForPredSym(hcPredicateSymbol, false);
        return new HornClause(managedScript, hcSymbolTable, this.getTransitionFormula(managedScript.getScript()), hcPredicateSymbol, list3, list, list2, (Set)object);
    }

    private Set<HcVar> normalizeVariables(HcSymbolTable hcSymbolTable, ManagedScript managedScript) {
        HcHeadVar hcHeadVar;
        int n;
        HashSet<HcVar> hashSet = new HashSet<HcVar>();
        HcPredicateSymbol hcPredicateSymbol = this.mHead == null ? hcSymbolTable.getFalseHornClausePredicateSymbol() : hcSymbolTable.getOrConstructHornClausePredicateSymbol(this.mHead);
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        if (this.mHead != null) {
            n = 0;
            while (n < this.mHead.getParameters().length) {
                TermVariable termVariable = (TermVariable)this.mHead.getParameters()[n];
                Sort sort = termVariable.getSort();
                hcHeadVar = hcSymbolTable.getOrConstructHeadVar(hcPredicateSymbol, n, sort, (Object)termVariable);
                hashMap.put((Term)termVariable, (Term)hcHeadVar.getTermVariable());
                ++n;
            }
            this.mHead = (ApplicationTerm)Substitution.apply((ManagedScript)managedScript, hashMap, (Term)this.mHead);
        }
        n = 1;
        for (TermVariable termVariable : this.mBody.getVariables()) {
            if (hashMap.containsKey(termVariable)) continue;
            hcHeadVar = hcSymbolTable.getOrConstructBodyVar(hcPredicateSymbol, n, termVariable.getSort(), (Object)termVariable);
            ++n;
            hashMap.put((Term)termVariable, (Term)hcHeadVar.getTermVariable());
            hashSet.add((HcVar)hcHeadVar);
        }
        this.mBody.applySubstitution(hashMap);
        return hashSet;
    }

    public boolean setHead(ApplicationTerm applicationTerm) {
        if (this.mHead == null) {
            assert (Arrays.asList(applicationTerm.getParameters()).stream().allMatch(term -> term instanceof TermVariable));
            assert (Arrays.asList(applicationTerm.getParameters()).stream().collect(Collectors.toSet()).size() == applicationTerm.getParameters().length);
            this.mHead = applicationTerm;
            return true;
        }
        return false;
    }

    public void addTransitionFormula(Term term) {
        this.mBody.addTransitionFormula(term);
    }

    public String toString() {
        return "(" + this.mBody.toString() + " ==> " + (this.mHead == null ? "false" : this.mHead.toString()) + ")";
    }

    public Term getTransitionFormula(Script script) {
        return this.mBody.getTransitionFormula(script);
    }
}

