/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class QuantifierExpression
extends Expression {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(QuantifierExpression.class);
    boolean isUniversal;
    String[] typeParams;
    VarList[] parameters;
    Attribute[] attributes;
    Expression subformula;

    public QuantifierExpression(ILocation iLocation, boolean bl, String[] stringArray, VarList[] varListArray, Attribute[] attributeArray, Expression expression) {
        super(iLocation);
        this.isUniversal = bl;
        this.typeParams = stringArray;
        this.parameters = varListArray;
        this.attributes = attributeArray;
        this.subformula = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid QuantifierExpression: " + String.valueOf((Object)this);
    }

    public QuantifierExpression(ILocation iLocation, IBoogieType iBoogieType, boolean bl, String[] stringArray, VarList[] varListArray, Attribute[] attributeArray, Expression expression) {
        super(iLocation, iBoogieType);
        this.isUniversal = bl;
        this.typeParams = stringArray;
        this.parameters = varListArray;
        this.attributes = attributeArray;
        this.subformula = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid QuantifierExpression: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("QuantifierExpression").append('[');
        stringBuffer.append(this.isUniversal);
        stringBuffer.append(',');
        if (this.typeParams == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.typeParams.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.typeParams[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.parameters == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.parameters.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.parameters[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.attributes == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.attributes.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.attributes[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',').append((Object)this.subformula);
        return stringBuffer.append(']').toString();
    }

    public boolean isUniversal() {
        return this.isUniversal;
    }

    public String[] getTypeParams() {
        return this.typeParams;
    }

    public VarList[] getParameters() {
        return this.parameters;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public Expression getSubformula() {
        return this.subformula;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.parameters != null) {
            list.addAll(Arrays.asList(this.parameters));
        }
        if (this.attributes != null) {
            list.addAll(Arrays.asList(this.attributes));
        }
        list.add(this.subformula);
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Expression)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this)) {
            BoogieASTNode boogieASTNode;
            int n;
            int n2;
            BoogieASTNode[] boogieASTNodeArray;
            if (this.parameters != null) {
                boogieASTNodeArray = this.parameters;
                n2 = this.parameters.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((VarList)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
            if (this.attributes != null) {
                boogieASTNodeArray = this.attributes;
                n2 = this.attributes.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((Attribute)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
            if (this.subformula != null) {
                this.subformula.accept(generatedBoogieAstVisitor);
            }
        }
    }

    @Override
    public Expression accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Object object;
        Object object2;
        int n;
        Expression expression = generatedBoogieAstTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        boolean bl = false;
        ArrayList<Attribute[]> arrayList = new ArrayList<Attribute[]>();
        if (this.parameters != null) {
            VarList[] varListArray = this.parameters;
            n = this.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = varListArray[n2];
                object = ((VarList)((Object)object2)).accept(generatedBoogieAstTransformer);
                bl = bl || object != object2;
                arrayList.add((Attribute[])object);
                ++n2;
            }
        }
        object2 = new ArrayList();
        if (this.attributes != null) {
            object = this.attributes;
            int n3 = this.attributes.length;
            n = 0;
            while (n < n3) {
                Attribute attribute = object[n];
                Attribute attribute2 = attribute.accept(generatedBoogieAstTransformer);
                bl = bl || attribute2 != attribute;
                ((ArrayList)object2).add(attribute2);
                ++n;
            }
        }
        Expression expression2 = null;
        if (this.subformula != null) {
            expression2 = this.subformula.accept(generatedBoogieAstTransformer);
        }
        if (bl || this.subformula != expression2) {
            return new QuantifierExpression(this.loc, this.type, this.isUniversal, this.typeParams, arrayList.toArray(new VarList[0]), ((ArrayList)object2).toArray(new Attribute[0]), expression2);
        }
        return this;
    }
}

