/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.IModelManager;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.GraphNotFoundException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.modelwalker.CFGWalker;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.modelwalker.DFSTreeWalker;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.modelwalker.IWalker;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.IGenerator;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchain;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainPlugin;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class PluginConnector {
    private final ILogger mLogger;
    private final IModelManager mModelManager;
    private final IController<RunDefinition> mController;
    private final ITool mTool;
    private boolean mHasPerformedChanges;
    private final IToolchainStorage mStorage;
    private final IUltimateServiceProvider mServices;
    private final IToolchain<RunDefinition> mToolchain;

    public PluginConnector(IToolchain<RunDefinition> iToolchain, IModelManager iModelManager, ITool iTool, IController<RunDefinition> iController) {
        this.mModelManager = Objects.requireNonNull(iModelManager);
        this.mController = Objects.requireNonNull(iController);
        this.mTool = Objects.requireNonNull(iTool);
        this.mToolchain = Objects.requireNonNull(iToolchain);
        this.mStorage = Objects.requireNonNull(iToolchain.getCurrentToolchainData().getStorage());
        this.mServices = Objects.requireNonNull(iToolchain.getCurrentToolchainData().getServices());
        this.mLogger = this.mServices.getLoggingService().getLogger("de.uni_freiburg.informatik.ultimate.core");
        this.init();
    }

    private void init() {
        this.mHasPerformedChanges = false;
    }

    public void run() throws Throwable {
        this.mLogger.info((Object)("------------------------" + this.mTool.getPluginName() + "----------------------------"));
        this.init();
        PluginConnector.initializePlugin(this.mLogger, (IToolchainPlugin)this.mTool, this.mServices, this.mStorage);
        List<ModelType> list = this.selectModels();
        if (list.isEmpty()) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            this.mLogger.error((Object)"Tool did not select a valid model", (Throwable)illegalArgumentException);
            throw illegalArgumentException;
        }
        int n = list.size();
        int n2 = 0;
        for (ModelType modelType : list) {
            this.mTool.setInputDefinition(modelType);
            List list2 = this.mTool.getObservers();
            this.runTool(list2, modelType, n2, n);
            ++n2;
        }
        this.mTool.finish();
        this.mLogger.info((Object)("------------------------ END " + this.mTool.getPluginName() + "----------------------------"));
    }

    public boolean hasPerformedChanges() {
        return this.mHasPerformedChanges;
    }

    public String toString() {
        return this.mTool.getPluginName();
    }

    private void runTool(List<IObserver> list, ModelType modelType, int n, int n2) throws Throwable {
        IElement iElement = this.getEntryPoint(modelType);
        if (this.mTool instanceof IGenerator) {
            IGenerator iGenerator = (IGenerator)this.mTool;
            for (IObserver iObserver : list) {
                this.runObserver(iObserver, modelType, iElement, n, n2);
                this.retrieveModel(iGenerator, iObserver.toString());
            }
        } else {
            for (IObserver iObserver : list) {
                this.runObserver(iObserver, modelType, iElement, n, n2);
            }
        }
    }

    private void runObserver(IObserver iObserver, ModelType modelType, IElement iElement, int n, int n2) throws Throwable {
        this.logObserverRun(iObserver, modelType, n, n2);
        IWalker iWalker = this.selectWalker(modelType);
        iWalker.addObserver(iObserver);
        iObserver.init(modelType, n, n2);
        iWalker.run(iElement);
        iObserver.finish();
        this.mHasPerformedChanges = this.mHasPerformedChanges || iObserver.performedChanges();
    }

    private void logObserverRun(IObserver iObserver, ModelType modelType, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Executing the observer ");
        stringBuilder.append(iObserver.getClass().getSimpleName());
        stringBuilder.append(" from plugin ");
        stringBuilder.append(this.mTool.getPluginName());
        stringBuilder.append(" for \"");
        stringBuilder.append(modelType);
        stringBuilder.append("\" (");
        stringBuilder.append(n + 1);
        stringBuilder.append("/");
        stringBuilder.append(n2);
        stringBuilder.append(") ...");
        this.mLogger.info((Object)stringBuilder.toString());
    }

    private IElement getEntryPoint(ModelType modelType) {
        IElement iElement = null;
        try {
            iElement = this.mModelManager.getRootNode(modelType);
        }
        catch (GraphNotFoundException graphNotFoundException) {
            this.mLogger.error((Object)"Graph not found!", (Throwable)graphNotFoundException);
        }
        return iElement;
    }

    private void retrieveModel(IGenerator iGenerator, String string) {
        IElement iElement = iGenerator.getModel();
        ModelType modelType = iGenerator.getOutputDefinition();
        if (iElement != null && modelType != null) {
            this.mLogger.info((Object)("Adding new model " + String.valueOf(modelType) + " " + iElement.getClass().getSimpleName()));
            this.mModelManager.addItem(iElement, modelType);
        } else {
            this.mLogger.info((Object)String.format("Invalid model from %s for observer %s and model type %s, skipping insertion in model container", iGenerator.getPluginName(), string, modelType));
        }
    }

    private List<ModelType> selectModels() {
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        switch (this.mTool.getModelQuery()) {
            case ALL: {
                arrayList.addAll(this.mModelManager.getItemKeys());
                break;
            }
            case USER: {
                if (this.mModelManager.size() > 1) {
                    for (String string : this.mController.selectModel(this.mToolchain, this.mModelManager.getItemNames())) {
                        ModelType modelType2 = this.mModelManager.getGraphTypeById(string);
                        if (modelType2 == null) continue;
                        arrayList.add(modelType2);
                    }
                    break;
                }
                arrayList.add(this.mModelManager.getItemKeys().get(0));
                break;
            }
            case LAST: {
                arrayList.add(this.mModelManager.getLastAdded());
                break;
            }
            case SOURCE: {
                arrayList.addAll(this.mModelManager.getItemKeys());
                for (ModelType modelType3 : arrayList) {
                    if (modelType3.isFromSource()) continue;
                    arrayList.remove(modelType3);
                }
                break;
            }
            case TOOL: {
                List list = this.mTool.getDesiredToolIds();
                if (list == null || list.isEmpty()) break;
                HashSet hashSet = new HashSet(list);
                this.mModelManager.getItemKeys().stream().filter(modelType -> hashSet.contains(modelType.getCreator())).forEach(arrayList::add);
                break;
            }
            default: {
                IllegalStateException illegalStateException = new IllegalStateException("Unknown query type");
                this.mLogger.fatal((Object)"Unknown query type", (Throwable)illegalStateException);
                throw illegalStateException;
            }
        }
        if (arrayList.isEmpty()) {
            this.mLogger.warn((Object)"no suitable model selected, skipping...");
        }
        assert (CoreUtil.isSorted((Iterable)arrayList.stream().map(ModelType::getCreated).collect(Collectors.toList()))) : "Available models are not sorted according to creation time";
        return arrayList;
    }

    private IWalker selectWalker(ModelType modelType) {
        if ("CFG".equals(modelType.getType().name())) {
            return new CFGWalker(this.mLogger);
        }
        return new DFSTreeWalker(this.mLogger);
    }

    static void initializePlugin(ILogger iLogger, IToolchainPlugin iToolchainPlugin, IUltimateServiceProvider iUltimateServiceProvider, IToolchainStorage iToolchainStorage) {
        iLogger.info((Object)("Initializing " + iToolchainPlugin.getPluginName() + "..."));
        try {
            iToolchainPlugin.setServices(iUltimateServiceProvider);
            iToolchainPlugin.init();
            iLogger.info((Object)(iToolchainPlugin.getPluginName() + " initialized"));
        }
        catch (Exception exception) {
            iLogger.fatal((Object)("Exception during initialization of " + iToolchainPlugin.getPluginName()));
            throw exception;
        }
    }
}

