/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cli;

import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.PluginType;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.xml.sax.SAXException;

public class ToolchainLocator {
    private final File mDir;
    private final ICore<RunDefinition> mCore;
    private final ILogger mLogger;
    private Map<File, IToolchainData<RunDefinition>> mFoundToolchains;

    public ToolchainLocator(File file, ICore<RunDefinition> iCore, ILogger iLogger) {
        this.mDir = file;
        this.mCore = iCore;
        this.mLogger = iLogger;
    }

    public Set<String> createFilterForAvailableTools() {
        Map<File, IToolchainData<RunDefinition>> map = this.locateToolchains();
        return map.values().stream().flatMap(iToolchainData -> ((RunDefinition)iToolchainData.getRootElement()).getToolchain().getPluginOrSubchain().stream()).filter(object -> object instanceof PluginType).map(object -> ((PluginType)object).getId().toLowerCase()).collect(Collectors.toSet());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<File, IToolchainData<RunDefinition>> locateToolchains() {
        File[] fileArray;
        if (this.mFoundToolchains != null) {
            return Collections.unmodifiableMap(this.mFoundToolchains);
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Trying to read toolchain files from " + String.valueOf(this.mDir)));
        }
        if (!this.mDir.exists()) {
            return Collections.emptyMap();
        }
        if (this.mDir.isFile()) {
            if (!this.mDir.getName().endsWith(".xml")) return Collections.emptyMap();
            fileArray = new File[]{this.mDir};
        } else {
            fileArray = this.mDir.listFiles((file, string) -> string.endsWith(".xml"));
            if (fileArray.length == 0) {
                return Collections.emptyMap();
            }
        }
        this.mFoundToolchains = new HashMap<File, IToolchainData<RunDefinition>>();
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray2[n2];
            try {
                IToolchainData iToolchainData = this.mCore.createToolchainData(file2.getAbsolutePath());
                this.mFoundToolchains.put(file2, (IToolchainData<RunDefinition>)iToolchainData);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mLogger.error((Object)("Could not find file: " + fileNotFoundException.getMessage()));
            }
            catch (JAXBException | SAXException throwable) {}
            ++n2;
        }
        return Collections.unmodifiableMap(this.mFoundToolchains);
    }
}

