/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.reqtotest;

import de.uni_freiburg.informatik.ultimate.core.lib.models.ObjectContainer;
import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.BoogieDeclarations;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.pea2boogie.CddToSmt;
import de.uni_freiburg.informatik.ultimate.pea2boogie.IReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.PeaResultUtil;
import de.uni_freiburg.informatik.ultimate.reqtotest.graphtransformer.AuxVarGen;
import de.uni_freiburg.informatik.ultimate.reqtotest.graphtransformer.GraphToBoogie;
import de.uni_freiburg.informatik.ultimate.reqtotest.req.Req2TestReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.reqtotest.req.ReqGuardGraph;
import de.uni_freiburg.informatik.ultimate.reqtotest.req.ReqToDeclarations;
import de.uni_freiburg.informatik.ultimate.reqtotest.req.ReqToGraph;
import de.uni_freiburg.informatik.ultimate.reqtotest.req.ReqToInOut;
import de.uni_freiburg.informatik.ultimate.reqtotest.testgenerator.CounterExampleToTest;
import java.util.List;
import java.util.function.UnaryOperator;

public class ReqToTestObserver
extends BaseObserver {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private IElement mBoogieAst;
    private CounterExampleToTest mResultTransformer;
    private final ManagedScript mManagedScript;
    private final Script mScript;
    private final boolean RETURN_RESULT_AS_COUNTEREXAMPLE = false;

    public ReqToTestObserver(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        SolverBuilder.SolverSettings solverSettings = SolverBuilder.constructSolverSettings().setSolverMode(SolverBuilder.SolverMode.External_DefaultMode).setUseExternalSolver(SolverBuilder.ExternalSolver.Z3);
        this.mScript = SolverBuilder.buildAndInitializeSolver((IUltimateServiceProvider)iUltimateServiceProvider, (SolverBuilder.SolverSettings)solverSettings, (String)"RtInconsistencySolver");
        this.mManagedScript = new ManagedScript(iUltimateServiceProvider, this.mScript);
    }

    public boolean process(IElement iElement) throws Throwable {
        Object object;
        if (!(iElement instanceof ObjectContainer)) {
            return false;
        }
        List list = (List)((ObjectContainer)iElement).getValue();
        Req2TestReqSymbolTable req2TestReqSymbolTable = new ReqToDeclarations(this.mLogger).initPatternToSymbolTable(list);
        BoogieDeclarations boogieDeclarations = new BoogieDeclarations(req2TestReqSymbolTable.constructVariableDeclarations(), this.mLogger);
        Boogie2SMT boogie2SMT = new Boogie2SMT(this.mManagedScript, boogieDeclarations, this.mServices, false);
        PeaResultUtil peaResultUtil = new PeaResultUtil(this.mLogger, this.mServices);
        CddToSmt cddToSmt = new CddToSmt(this.mServices, peaResultUtil, this.mScript, boogie2SMT, boogieDeclarations, (IReqSymbolTable)req2TestReqSymbolTable);
        if (req2TestReqSymbolTable.getOutputVars().isEmpty()) {
            object = new ReqToInOut(this.mLogger, req2TestReqSymbolTable, cddToSmt);
            ((ReqToInOut)object).requirementToInOut(list);
        }
        object = new AuxVarGen(this.mLogger, this.mScript, req2TestReqSymbolTable);
        ReqToGraph reqToGraph = new ReqToGraph(this.mLogger, (AuxVarGen)object, this.mScript, cddToSmt, req2TestReqSymbolTable);
        List<ReqGuardGraph> list2 = reqToGraph.patternListToBuechi(list);
        GraphToBoogie graphToBoogie = new GraphToBoogie(this.mLogger, this.mServices, req2TestReqSymbolTable, (AuxVarGen)object, list2, this.mScript, this.mManagedScript);
        this.mBoogieAst = graphToBoogie.getAst();
        this.mResultTransformer = new CounterExampleToTest(this.mLogger, this.mServices, req2TestReqSymbolTable, (AuxVarGen)object);
        UnaryOperator unaryOperator = this.mResultTransformer::convertCounterExampleToTest;
        this.mServices.getResultService().registerTransformer("CexToTest", unaryOperator);
        return false;
    }

    public IElement getAst() {
        return this.mBoogieAst;
    }
}

