/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.pea.BooleanDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.lib.pea.EventDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.RangeDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.ZDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.XMLWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.sourceforge.czt.parser.util.ParseException;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormulaJ2XMLConverter {
    private static final String DEFAULT_LOGGER = "FormulaJ2XMLConverter";
    ILogger mLogger = null;
    Document mDocument = null;
    protected List<String> mRangeExpressionVariables = null;
    protected List<String> mEvents = null;
    private final Vector<String> mDisjuncts = new Vector();
    private int mDnfCount = 1;

    public FormulaJ2XMLConverter(String string) {
        this.mLogger = string.equals("") ? ILogger.getLogger((String)DEFAULT_LOGGER) : ILogger.getLogger((String)string);
    }

    public FormulaJ2XMLConverter() {
        this("");
    }

    public Element convert(CDD cDD, List<String> list, List<String> list2) {
        this.mDocument = new DocumentImpl();
        this.mRangeExpressionVariables = list;
        this.mEvents = list2;
        this.mLogger.debug((Object)"Trying to build formula node");
        Element element = this.createCDDFormula(cDD);
        this.mLogger.debug((Object)"Building formula node successful");
        return element;
    }

    private Element createCDDFormula(CDD cDD) {
        if (cDD == CDD.TRUE) {
            return this.createBooleanExpressionNode("true");
        }
        if (cDD == CDD.FALSE) {
            return this.createBooleanExpressionNode("false");
        }
        CDD[] cDDArray = cDD.getChilds();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n = 0;
        while (n < cDDArray.length) {
            if (cDDArray[n] != CDD.FALSE) {
                if (cDD.childDominates(n)) {
                    var6_7 = this.createCDDFormula(cDDArray[n]);
                    if (var6_7.getNodeName().equals("formulaTree")) {
                        if (var6_7.getAttribute("operator").equals("OR")) {
                            NodeList nodeList = var6_7.getChildNodes();
                            int n2 = nodeList.getLength();
                            int n3 = 0;
                            while (n3 < n2) {
                                if (nodeList.item(n3).getNodeName().equals("formulaTree")) {
                                    arrayList2.add(nodeList.item(n3));
                                } else {
                                    arrayList.add(nodeList.item(n3));
                                }
                                ++n3;
                            }
                        } else {
                            arrayList2.add(var6_7);
                        }
                    } else {
                        arrayList.add((Node)var6_7);
                    }
                } else {
                    var6_7 = this.createDecisionNode(cDD.getDecision(), n);
                    if (cDDArray[n] != CDD.TRUE) {
                        Element element = this.createCDDFormula(cDDArray[n]);
                        Element element2 = this.createDecisionAndChildTree((Element)var6_7, element);
                        arrayList2.add(element2);
                    } else {
                        arrayList.add((Node)var6_7);
                    }
                }
            }
            ++n;
        }
        if (arrayList.isEmpty() && arrayList2.isEmpty()) {
            throw new RuntimeException("The cdd " + String.valueOf(cDD) + " has no children");
        }
        if (arrayList.size() == 1 && arrayList2.isEmpty()) {
            return (Element)arrayList.get(0);
        }
        if (arrayList2.size() == 1 && arrayList.isEmpty()) {
            return (Element)arrayList2.get(0);
        }
        Element element = this.mDocument.createElement("formulaTree");
        element.setAttribute("operator", "OR");
        for (Element element3 : arrayList) {
            element.appendChild(element3);
        }
        for (Element element4 : arrayList2) {
            element.appendChild(element4);
        }
        return element;
    }

    /*
     * WARNING - void declaration
     */
    private Element createDecisionAndChildTree(Element element, Element element2) {
        Element element3 = this.mDocument.createElement("formulaTree");
        element3.setAttribute("operator", "AND");
        element3.appendChild(element);
        if (element2.getAttribute("operator").equals("AND")) {
            void element5;
            NodeList nodeList = element2.getChildNodes();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = nodeList.getLength() - 1;
            while (element5 >= 0) {
                Element element4 = (Element)nodeList.item((int)element5);
                if (element4.getNodeName().equals("formulaTree")) {
                    arrayList.add(element4);
                } else {
                    element3.appendChild(element4);
                }
                --element5;
            }
            for (Element element6 : arrayList) {
                element3.appendChild(element6);
            }
        } else {
            element3.appendChild(element2);
        }
        return element3;
    }

    private Element createDecisionNode(Decision decision, int n) {
        Object object;
        if (!(decision instanceof BooleanDecision || decision instanceof EventDecision || decision instanceof RangeDecision || decision instanceof ZDecision)) {
            throw new RuntimeException("Decision has to be instance of \"BooleanDecision\", \"EventDecision\", or \"RangeDecision\"");
        }
        if (decision instanceof RangeDecision) {
            Element element = this.createRangeExpressionNode((RangeDecision)decision, n);
            return element;
        }
        Object object2 = null;
        if (decision instanceof BooleanDecision) {
            object = ((BooleanDecision)decision).getVar();
            object2 = this.createBooleanExpressionNode((String)object);
        } else if (decision instanceof EventDecision) {
            object = ((EventDecision)decision).getEvent();
            object2 = this.createEventExpressionNode((String)object);
        } else if (decision instanceof ZDecision) {
            object = this.mDocument.createElement("zTag");
            try {
                object.setTextContent(((ZDecision)decision).getZML());
            }
            catch (ParseException parseException) {
                object.setTextContent(parseException.toString());
            }
            catch (InstantiationException instantiationException) {
                object.setTextContent(instantiationException.toString());
            }
            object2 = object;
        }
        if (n == 0) {
            return object2;
        }
        object = this.mDocument.createElement("formulaTree");
        object.setAttribute("operator", "NOT");
        object.appendChild((Node)object2);
        return object;
    }

    private Element createBooleanExpressionNode(String string) {
        if (string.equals("")) {
            throw new RuntimeException("Boolean expressions with empty content are not allowed");
        }
        Element element = this.mDocument.createElement("booleanExpression");
        element.setAttribute("expression", string.replace("<", "&lt;").replace(">", "&gt;"));
        return element;
    }

    private Element createRangeExpressionNode(RangeDecision rangeDecision, int n) {
        Element element = this.mDocument.createElement("rangeExpression");
        String string = rangeDecision.getVar();
        if (string.equals("")) {
            throw new RuntimeException("Variables are not allowed to be empty");
        }
        element.setAttribute("variable", string);
        if (!this.mRangeExpressionVariables.contains(string)) {
            this.mRangeExpressionVariables.add(string);
        }
        int[] nArray = rangeDecision.getLimits();
        if (n == 0) {
            if ((nArray[0] & 1) == 0) {
                element.setAttribute("operator", "less");
            } else {
                element.setAttribute("operator", "lessequal");
            }
            element.setAttribute("bound", Integer.toString(nArray[0] / 2));
            return element;
        }
        if (n == nArray.length) {
            if ((nArray[nArray.length - 1] & 1) == 1) {
                element.setAttribute("operator", "greater");
            } else {
                element.setAttribute("operator", "greaterequal");
            }
            element.setAttribute("bound", Integer.toString(nArray[nArray.length - 1] / 2));
            return element;
        }
        if (nArray[n - 1] / 2 == nArray[n] / 2) {
            element.setAttribute("operator", "equal");
            element.setAttribute("bound", Integer.toString(nArray[n] / 2));
            return element;
        }
        Element element2 = this.mDocument.createElement("formulaTree");
        element2.setAttribute("operator", "AND");
        if ((nArray[n - 1] & 1) == 1) {
            element.setAttribute("operator", "greater");
        } else {
            element.setAttribute("operator", "greaterequal");
        }
        element.setAttribute("bound", Integer.toString(nArray[n - 1] / 2));
        Element element3 = this.mDocument.createElement("rangeExpression");
        element3.setAttribute("variable", string);
        if ((nArray[n] & 1) == 0) {
            element3.setAttribute("operator", "less");
        } else {
            element3.setAttribute("operator", "lessequal");
        }
        element3.setAttribute("bound", Integer.toString(nArray[n] / 2));
        element2.appendChild(element);
        element2.appendChild(element3);
        return element2;
    }

    private Element createEventExpressionNode(String string) {
        if (string.equals("")) {
            throw new RuntimeException("Events are not allowed to be empty");
        }
        if (!this.mEvents.contains(string)) {
            this.mEvents.add(string);
        }
        Element element = this.mDocument.createElement("eventExpression");
        element.setAttribute("name", string);
        return element;
    }

    public String[] getDisjuncts(CDD cDD, List<String> list, List<String> list2, int n) {
        this.mDisjuncts.clear();
        this.mRangeExpressionVariables = list;
        this.mEvents = list2;
        ++this.mDnfCount;
        this.cddToDNF(new StringBuilder(), cDD);
        int n2 = this.mDisjuncts.size();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = this.mDisjuncts.elementAt(n3);
            ++n3;
        }
        return stringArray;
    }

    public String[] getDisjuncts(CDD cDD, List<String> list, List<String> list2) {
        return this.getDisjuncts(cDD, list, list2, 0);
    }

    private void cddToDNF(StringBuilder stringBuilder, CDD cDD) {
        if (cDD == CDD.TRUE) {
            this.mDisjuncts.add(stringBuilder.toString());
            return;
        }
        if (cDD == CDD.FALSE) {
            return;
        }
        int n = 0;
        while (n < cDD.getChilds().length) {
            StringBuilder stringBuilder2 = new StringBuilder(stringBuilder);
            this.appendDecisionToBuffer(stringBuilder2, cDD.getDecision(), n);
            this.cddToDNF(stringBuilder2, cDD.getChilds()[n]);
            ++n;
        }
    }

    private void appendDecisionToBuffer(StringBuilder stringBuilder, Decision decision, int n) {
        if (decision instanceof RangeDecision) {
            String string = ((RangeDecision)decision).getVar();
            stringBuilder.append("  <rangeExpression variable=\"" + string + "\" ");
            if (!this.mRangeExpressionVariables.contains(string)) {
                this.mRangeExpressionVariables.add(string);
            }
            int[] nArray = ((RangeDecision)decision).getLimits();
            if (n == 0) {
                if ((nArray[0] & 1) == 0) {
                    stringBuilder.append("operator = \"less\" ");
                } else {
                    stringBuilder.append("operator = \"lessequal\" ");
                }
                stringBuilder.append("bound = \"" + nArray[0] / 2 + "\"/>\n");
                return;
            }
            if (n == nArray.length) {
                if ((nArray[nArray.length - 1] & 1) == 1) {
                    stringBuilder.append("operator = \"greater\" ");
                } else {
                    stringBuilder.append("operator = \"greaterequal\" ");
                }
                stringBuilder.append("bound = \"" + nArray[nArray.length - 1] / 2 + "\"/>\n");
                return;
            }
            if (nArray[n - 1] / 2 == nArray[n] / 2) {
                stringBuilder.append("operator = \"greater\" ");
                stringBuilder.append("bound = \"" + nArray[n] / 2 + "\"/>");
                return;
            }
            if ((nArray[n - 1] & 1) == 1) {
                stringBuilder.append("operator = \"greater\" ");
            } else {
                stringBuilder.append("operator = \"greaterequal\" ");
            }
            stringBuilder.append("bound = \"" + nArray[n - 1] / 2 + "\"/>\n");
            stringBuilder.append("  <rangeExpression variable=\"" + string + "\" ");
            if ((nArray[n] & 1) == 0) {
                stringBuilder.append("operator = \"less\" ");
            } else {
                stringBuilder.append("operator = \"lessequal\" ");
            }
            stringBuilder.append("bound = \"" + nArray[n] / 2 + "\"/>\n");
            return;
        }
        if (n == 0) {
            if (decision instanceof BooleanDecision) {
                stringBuilder.append("  <booleanExpression expression=\"" + ((BooleanDecision)decision).getVar().replace("<", "&lt;").replace(">", "&gt;") + "\"/>\n");
            } else if (decision instanceof EventDecision) {
                String string = ((EventDecision)decision).getEvent();
                if (!this.mEvents.contains(string)) {
                    this.mEvents.add(string);
                }
                stringBuilder.append("  <eventExpression name=\"" + string + "\"/>\n");
            } else if (decision instanceof ZDecision) {
                try {
                    stringBuilder.append(((ZDecision)decision).getZML());
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
            }
        } else if (decision instanceof BooleanDecision) {
            stringBuilder.append("  <formulaTree operator = \"NOT\">\n");
            stringBuilder.append("    <booleanExpression expression=\"" + ((BooleanDecision)decision).getVar().replace("<", "&lt;").replace(">", "&gt;") + "\"/>\n");
            stringBuilder.append("  </formulaTree>\n");
        } else if (decision instanceof EventDecision) {
            String string = ((EventDecision)decision).getEvent();
            if (!this.mEvents.contains(string)) {
                this.mEvents.add(string);
            }
            stringBuilder.append("  <formulaTree operator = \"NOT\">\n");
            stringBuilder.append("    <eventExpression name=\"" + string + "\"/>\n");
            stringBuilder.append("  </formulaTree>\n");
        } else if (decision instanceof ZDecision) {
            try {
                stringBuilder.append(((ZDecision)decision).negate().getZML());
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
        }
    }

    public String convertFast(CDD cDD, List<String> list, List<String> list2) {
        XMLWriter xMLWriter = new XMLWriter();
        String string = xMLWriter.writeXMLDocumentToString(this.convert(cDD, list, list2));
        return string.substring(1, string.length()) + "\n";
    }

    public StringBuilder cddToXML(CDD cDD) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (cDD == CDD.TRUE) {
            return new StringBuilder("<booleanExpression expression=\"true\"/>");
        }
        if (cDD == CDD.FALSE) {
            return new StringBuilder("<booleanExpression expression=\"false\"/>");
        }
        CDD[] cDDArray = cDD.getChilds();
        int n = 0;
        while (n < cDDArray.length) {
            if (bl && cDDArray[n] != CDD.FALSE) {
                stringBuilder.append("<formulaTree operator = \"OR\">\n");
            } else if (cDDArray[n] != CDD.FALSE) {
                bl = true;
            }
            ++n;
        }
        bl = false;
        n = 0;
        while (n < cDDArray.length) {
            if (cDDArray[n] != CDD.FALSE) {
                if (cDD.childDominates(n)) {
                    stringBuilder.append((CharSequence)this.cddToXML(cDDArray[n]));
                } else if (cDDArray[n] != CDD.TRUE) {
                    stringBuilder.append("<formulaTree operator = \"AND\">\n");
                    this.appendDecisionToBuffer(stringBuilder, cDD.getDecision(), n);
                    stringBuilder.append((CharSequence)this.cddToXML(cDDArray[n]));
                    stringBuilder.append("</formulaTree>\n");
                } else {
                    this.appendDecisionToBuffer(stringBuilder, cDD.getDecision(), n);
                }
                if (bl) {
                    stringBuilder.append("</formulaTree>\n");
                } else {
                    bl = true;
                }
            }
            ++n;
        }
        return stringBuilder;
    }

    public String formulaToXML(CDD cDD, List<String> list, List<String> list2) {
        this.mRangeExpressionVariables = list;
        this.mEvents = list2;
        return this.cddToXML(cDD).toString();
    }
}

