/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.witnesschecking;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessEdge;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessNode;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessNodeAnnotation;
import java.util.ArrayDeque;
import java.util.LinkedHashSet;
import java.util.Set;

public class WitnessModelToAutomatonTransformer {
    private final NestedWordAutomaton<WitnessEdge, WitnessNode> mResult;
    private final WitnessNode mWitnessRoot;
    private final ArrayDeque<WitnessNode> worklist = new ArrayDeque();

    public WitnessModelToAutomatonTransformer(WitnessNode witnessNode, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mWitnessRoot = witnessNode;
        LinkedHashSet<WitnessEdge> linkedHashSet = new LinkedHashSet<WitnessEdge>();
        IEmptyStackStateFactory iEmptyStackStateFactory = () -> new WitnessNode("EmptyStack");
        this.mResult = new NestedWordAutomaton(new AutomataLibraryServices(iUltimateServiceProvider), new VpAlphabet(linkedHashSet), iEmptyStackStateFactory);
        this.constructAutomaton(linkedHashSet);
    }

    private void constructAutomaton(Set<WitnessEdge> set) {
        this.addNewState(this.mWitnessRoot);
        while (!this.worklist.isEmpty()) {
            WitnessNode witnessNode = this.worklist.removeFirst();
            for (WitnessEdge witnessEdge : witnessNode.getOutgoingEdges()) {
                WitnessNode witnessNode2 = (WitnessNode)witnessEdge.getTarget();
                if (!this.mResult.getStates().contains(witnessNode2)) {
                    this.addNewState(witnessNode2);
                }
                set.add(witnessEdge);
                this.mResult.addInternalTransition((Object)witnessNode, (Object)witnessEdge, (Object)witnessNode2);
            }
        }
    }

    private void addNewState(WitnessNode witnessNode) {
        WitnessNodeAnnotation witnessNodeAnnotation = WitnessNodeAnnotation.getAnnotation((IElement)witnessNode);
        boolean bl = witnessNodeAnnotation != null && witnessNodeAnnotation.isInitial();
        boolean bl2 = witnessNodeAnnotation != null && witnessNodeAnnotation.isError();
        this.mResult.addState(bl, bl2, (Object)witnessNode);
        this.worklist.add(witnessNode);
    }

    public INestedWordAutomaton<WitnessEdge, WitnessNode> getResult() {
        return this.mResult;
    }
}

