/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILoggingService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;

public class AutomataLibraryServices {
    private final ILoggingService mLoggingService;
    private final IProgressAwareTimer mProgressAwareTimer;

    public AutomataLibraryServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLoggingService = iUltimateServiceProvider.getLoggingService();
        this.mProgressAwareTimer = iUltimateServiceProvider.getProgressMonitorService();
    }

    public AutomataLibraryServices(IUltimateServiceProvider iUltimateServiceProvider, long l) {
        this.mLoggingService = iUltimateServiceProvider.getLoggingService();
        this.mProgressAwareTimer = iUltimateServiceProvider.getProgressMonitorService().getChildTimer(l);
    }

    public AutomataLibraryServices(AutomataLibraryServices automataLibraryServices, long l) {
        this.mLoggingService = automataLibraryServices.mLoggingService;
        this.mProgressAwareTimer = automataLibraryServices.mProgressAwareTimer.getChildTimer(l);
    }

    public ILoggingService getLoggingService() {
        return this.mLoggingService;
    }

    public IProgressAwareTimer getProgressAwareTimer() {
        return this.mProgressAwareTimer;
    }
}

