/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.BaseMinimizeStates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiPredicate;

public class MinimizeStatesMultiEdgeSingleNode
extends BaseMinimizeStates {
    public MinimizeStatesMultiEdgeSingleNode(IcfgEdgeBuilder icfgEdgeBuilder, IUltimateServiceProvider iUltimateServiceProvider, BlockEncodingBacktranslator blockEncodingBacktranslator, BiPredicate<IIcfg<?>, IcfgLocation> biPredicate, ILogger iLogger, boolean bl) {
        super(icfgEdgeBuilder, iUltimateServiceProvider, blockEncodingBacktranslator, biPredicate, iLogger, bl);
    }

    @Override
    protected Collection<? extends IcfgLocation> processCandidate(IIcfg<?> iIcfg, IcfgLocation icfgLocation, Set<IcfgLocation> set) {
        if (new HashSet(icfgLocation.getIncomingNodes()).size() != 1 || new HashSet(icfgLocation.getOutgoingNodes()).size() != 1) {
            return icfgLocation.getOutgoingNodes();
        }
        IcfgLocation icfgLocation2 = (IcfgLocation)((IcfgEdge)icfgLocation.getIncomingEdges().get(0)).getSource();
        IcfgLocation icfgLocation3 = (IcfgLocation)((IcfgEdge)icfgLocation.getOutgoingEdges().get(0)).getTarget();
        if (!this.isNotNecessary(iIcfg, icfgLocation) && !this.isAnyNecessary(iIcfg, icfgLocation2, icfgLocation3)) {
            return icfgLocation.getOutgoingNodes();
        }
        if (!this.isAllCombinableEdgePair(icfgLocation.getIncomingEdges(), icfgLocation.getOutgoingEdges())) {
            return icfgLocation.getOutgoingNodes();
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("    will remove " + String.valueOf(icfgLocation.getDebugIdentifier())));
        }
        ArrayList arrayList = new ArrayList(icfgLocation.getIncomingEdges());
        ArrayList arrayList2 = new ArrayList(icfgLocation.getOutgoingEdges());
        for (IcfgEdge icfgEdge : arrayList) {
            icfgEdge.disconnectSource();
            icfgEdge.disconnectTarget();
        }
        for (IcfgEdge icfgEdge : arrayList2) {
            icfgEdge.disconnectSource();
            icfgEdge.disconnectTarget();
        }
        int n = 0;
        for (IcfgEdge icfgEdge : arrayList) {
            for (IcfgEdge icfgEdge2 : arrayList2) {
                IcfgEdge icfgEdge3 = this.getEdgeBuilder().constructSequentialComposition(icfgLocation2, icfgLocation3, icfgEdge, icfgEdge2);
                this.rememberEdgeMapping((IIcfgTransition<?>)icfgEdge3, (IIcfgTransition<?>)icfgEdge);
                this.rememberEdgeMapping((IIcfgTransition<?>)icfgEdge3, (IIcfgTransition<?>)icfgEdge2);
                ++n;
            }
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("    removed " + (arrayList.size() + arrayList2.size()) + ", added " + n + " edges"));
        }
        this.mRemovedEdges += arrayList.size() + arrayList2.size();
        return icfgLocation2.getOutgoingNodes();
    }
}

