/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class Unit
extends BoogieASTNode {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(Unit.class);
    ILocation loc;
    Declaration[] declarations;

    public Unit(ILocation iLocation, Declaration[] declarationArray) {
        super(iLocation);
        this.loc = iLocation;
        this.declarations = declarationArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Unit: " + String.valueOf((Object)this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Unit").append('[');
        stringBuffer.append(this.loc);
        stringBuffer.append(',');
        if (this.declarations == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.declarations.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.declarations[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public ILocation getLoc() {
        return this.loc;
    }

    public void setLoc(ILocation iLocation) {
        if (this.loc != null && iLocation != this.loc) {
            throw new AssertionError((Object)"Value is only writeable once");
        }
        this.loc = iLocation;
    }

    public Declaration[] getDeclarations() {
        return this.declarations;
    }

    public void setDeclarations(Declaration[] declarationArray) {
        this.declarations = declarationArray;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.declarations != null) {
            list.addAll(Arrays.asList(this.declarations));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (generatedBoogieAstVisitor.visit(this) && this.declarations != null) {
            Declaration[] declarationArray = this.declarations;
            int n = this.declarations.length;
            int n2 = 0;
            while (n2 < n) {
                Declaration declaration = declarationArray[n2];
                declaration.accept(generatedBoogieAstVisitor);
                ++n2;
            }
        }
    }

    public Unit accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Unit unit = generatedBoogieAstTransformer.transform(this);
        if (unit != this) {
            return unit;
        }
        boolean bl = false;
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        if (this.declarations != null) {
            Declaration[] declarationArray = this.declarations;
            int n = this.declarations.length;
            int n2 = 0;
            while (n2 < n) {
                Declaration declaration = declarationArray[n2];
                Declaration declaration2 = declaration.accept(generatedBoogieAstTransformer);
                bl = bl || declaration2 != declaration;
                arrayList.add(declaration2);
                ++n2;
            }
        }
        if (bl) {
            return new Unit(this.loc, arrayList.toArray(new Declaration[0]));
        }
        return this;
    }
}

