/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.dataflowdag;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import java.util.List;
import java.util.Objects;

public class TraceCodeBlock {
    private final List<CodeBlock> mTrace;
    private final CodeBlock mBlock;
    private final int mIndex;
    private IPredicate mInterpolant;

    public int hashCode() {
        return Objects.hash(this.mBlock, this.mIndex);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TraceCodeBlock traceCodeBlock = (TraceCodeBlock)object;
        if (this.mBlock == null ? traceCodeBlock.mBlock != null : !this.mBlock.equals(traceCodeBlock.mBlock)) {
            return false;
        }
        return this.mIndex == traceCodeBlock.mIndex;
    }

    public TraceCodeBlock(List<CodeBlock> list, CodeBlock codeBlock, int n) {
        this.mTrace = list;
        this.mBlock = codeBlock;
        this.mIndex = n;
    }

    public List<CodeBlock> getTrace() {
        return this.mTrace;
    }

    public CodeBlock getBlock() {
        return this.mBlock;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public void addInterpolant(IPredicate iPredicate) {
        this.mInterpolant = iPredicate;
    }

    public IPredicate getInterpolant() {
        return this.mInterpolant;
    }

    public String toString() {
        return "[" + this.mIndex + "] " + this.mBlock.toString() + (String)(this.mInterpolant == null ? "" : " itp: " + String.valueOf(this.mInterpolant));
    }
}

