/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngineResult;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction.ICopyActionFactory;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction.IRefinableAbstraction;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.ILattice;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.PowersetLattice;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.UpsideDownLattice;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;

public class HoareAbstraction<L extends IAction, X>
implements IRefinableAbstraction<X, Set<IPredicate>, L> {
    private final IHoareTripleChecker mChecker;
    private final Set<IProgramVar> mAllVariables;
    private final ManagedScript mManagedScript;
    private final ICopyActionFactory<L> mCopyFactory;

    public HoareAbstraction(ManagedScript managedScript, IHoareTripleChecker iHoareTripleChecker, Set<IProgramVar> set, ICopyActionFactory<L> iCopyActionFactory) {
        this.mManagedScript = managedScript;
        this.mChecker = iHoareTripleChecker;
        this.mAllVariables = set;
        this.mCopyFactory = iCopyActionFactory;
    }

    public L abstractLetter(L l, Set<IPredicate> set) {
        assert (l instanceof IInternalAction) : "Cannot abstract transitions of type " + String.valueOf(l.getClass());
        UnmodifiableTransFormula unmodifiableTransFormula = this.concretizeAbstraction(this.computePrePostPairs((IInternalAction)l, set));
        return this.mCopyFactory.copy(l, unmodifiableTransFormula, null);
    }

    private HashRelation<IPredicate, IPredicate> computePrePostPairs(IInternalAction iInternalAction, Set<IPredicate> set) {
        HashRelation hashRelation = new HashRelation();
        for (IPredicate iPredicate : set) {
            for (IPredicate iPredicate2 : set) {
                IncrementalPlicationChecker.Validity validity = this.mChecker.checkInternal(iPredicate, iInternalAction, iPredicate2);
                assert (validity == IncrementalPlicationChecker.Validity.VALID || validity == IncrementalPlicationChecker.Validity.INVALID) : "Could not determine abstraction";
                if (validity != IncrementalPlicationChecker.Validity.VALID) continue;
                hashRelation.addPair((Object)iPredicate, (Object)iPredicate2);
            }
        }
        return hashRelation;
    }

    private UnmodifiableTransFormula concretizeAbstraction(HashRelation<IPredicate, IPredicate> hashRelation) {
        TermVariable termVariable;
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(null, null, true, null, true, null, true);
        HashMap<Object, TermVariable> hashMap = new HashMap<Object, TermVariable>(this.mAllVariables.size());
        for (IProgramVar iProgramVar : this.mAllVariables) {
            TermVariable termVariable2 = iProgramVar.getTermVariable();
            termVariable = this.mManagedScript.constructFreshCopy(termVariable2);
            hashMap.put(termVariable2, termVariable);
            transFormulaBuilder.addOutVar(iProgramVar, termVariable);
        }
        ArrayList<Term> arrayList = new ArrayList<Term>(hashRelation.size());
        for (Object object : hashRelation) {
            IProgramVar iProgramVar2;
            termVariable = (IPredicate)object.getKey();
            IPredicate iPredicate = (IPredicate)object.getValue();
            for (IProgramVar iProgramVar2 : termVariable.getVars()) {
                transFormulaBuilder.addInVar(iProgramVar2, iProgramVar2.getTermVariable());
            }
            iProgramVar2 = Substitution.apply((ManagedScript)this.mManagedScript, hashMap, (Term)iPredicate.getFormula());
            Term term = SmtUtils.implies((Script)this.mManagedScript.getScript(), (Term)termVariable.getFormula(), (Term)iProgramVar2);
            arrayList.add(term);
        }
        transFormulaBuilder.setFormula(SmtUtils.and((Script)this.mManagedScript.getScript(), arrayList));
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return transFormulaBuilder.finishConstruction(this.mManagedScript);
    }

    public ILattice<Set<IPredicate>> getHierarchy() {
        return new UpsideDownLattice((ILattice)new PowersetLattice());
    }

    @Override
    public Set<IPredicate> refine(Set<IPredicate> set, IRefinementEngineResult<L, X> iRefinementEngineResult) {
        Set set2 = iRefinementEngineResult.getUsedTracePredicates().stream().flatMap(qualifiedTracePredicates -> qualifiedTracePredicates.getPredicates().stream()).collect(Collectors.toSet());
        return DataStructureUtils.union(set, set2);
    }
}

