/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.output;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Axiom;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogieOutput;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IToString;

public final class BoogiePrettyPrinter {
    private static final String LINEBREAK = System.getProperty("line.separator");
    private static final IToString<BoogieASTNode> BOOGIE_STRING_PROVIDER = new BoogieStringProvider();

    private BoogiePrettyPrinter() {
    }

    public static String print(Axiom axiom) {
        BoogieOutput boogieOutput = new BoogieOutput(null);
        StringBuilder stringBuilder = new StringBuilder();
        boogieOutput.appendAxiom(stringBuilder, axiom);
        BoogiePrettyPrinter.removeLastLinebreak(stringBuilder);
        return stringBuilder.toString();
    }

    public static String print(Statement statement) {
        BoogieOutput boogieOutput = new BoogieOutput(null);
        StringBuilder stringBuilder = new StringBuilder();
        boogieOutput.appendStatement(stringBuilder, statement);
        BoogiePrettyPrinter.removeLastLinebreak(stringBuilder);
        return stringBuilder.toString();
    }

    public static String print(Expression expression) {
        BoogieOutput boogieOutput = new BoogieOutput(null);
        StringBuilder stringBuilder = new StringBuilder();
        boogieOutput.appendExpression(stringBuilder, expression);
        BoogiePrettyPrinter.removeLastLinebreak(stringBuilder);
        return stringBuilder.toString();
    }

    public static String print(Specification specification) {
        BoogieOutput boogieOutput = new BoogieOutput(null);
        StringBuilder stringBuilder = new StringBuilder();
        boogieOutput.appendSpecification(stringBuilder, specification);
        BoogiePrettyPrinter.removeLastLinebreak(stringBuilder);
        return stringBuilder.toString();
    }

    public static String print(VariableDeclaration variableDeclaration) {
        BoogieOutput boogieOutput = new BoogieOutput(null);
        StringBuilder stringBuilder = new StringBuilder();
        boogieOutput.appendVariableDeclaration(stringBuilder, variableDeclaration);
        BoogiePrettyPrinter.removeLastLinebreak(stringBuilder);
        return stringBuilder.toString();
    }

    public static String print(VarList[] varListArray) {
        BoogieOutput boogieOutput = new BoogieOutput(null);
        StringBuilder stringBuilder = new StringBuilder();
        boogieOutput.appendVarList(stringBuilder, varListArray);
        BoogiePrettyPrinter.removeLastLinebreak(stringBuilder);
        return stringBuilder.toString();
    }

    public static String print(VarList varList) {
        BoogieOutput boogieOutput = new BoogieOutput(null);
        StringBuilder stringBuilder = new StringBuilder();
        boogieOutput.appendVarList(stringBuilder, new VarList[]{varList});
        BoogiePrettyPrinter.removeLastLinebreak(stringBuilder);
        return stringBuilder.toString();
    }

    public static String printSignature(Procedure procedure) {
        Procedure procedure2 = new Procedure(procedure.getLocation(), procedure.getAttributes(), procedure.getIdentifier(), procedure.getTypeParams(), procedure.getInParams(), procedure.getOutParams(), procedure.getSpecification(), null);
        BoogieOutput boogieOutput = new BoogieOutput(null);
        StringBuilder stringBuilder = new StringBuilder();
        boogieOutput.appendProcedure(stringBuilder, procedure2);
        BoogiePrettyPrinter.removeLastLinebreak(stringBuilder);
        return stringBuilder.toString();
    }

    public static String print(ASTType aSTType) {
        BoogieOutput boogieOutput = new BoogieOutput(null);
        StringBuilder stringBuilder = new StringBuilder();
        boogieOutput.appendType(stringBuilder, aSTType, 0);
        BoogiePrettyPrinter.removeLastLinebreak(stringBuilder);
        return stringBuilder.toString();
    }

    public static String print(Attribute[] attributeArray) {
        BoogieOutput boogieOutput = new BoogieOutput(null);
        StringBuilder stringBuilder = new StringBuilder();
        boogieOutput.appendAttributes(stringBuilder, attributeArray);
        BoogiePrettyPrinter.removeLastSpace(stringBuilder);
        return stringBuilder.toString();
    }

    public static IToString<BoogieASTNode> getBoogieToStringProvider() {
        return BOOGIE_STRING_PROVIDER;
    }

    private static void removeLastLinebreak(StringBuilder stringBuilder) {
        int n;
        int n2 = stringBuilder.length();
        if (n2 < (n = LINEBREAK.length())) {
            return;
        }
        if (stringBuilder.substring(n2 - n, n2).equals(LINEBREAK)) {
            stringBuilder.replace(n2 - n, n2, "");
        }
    }

    private static void removeLastSpace(StringBuilder stringBuilder) {
        int n;
        int n2 = stringBuilder.length();
        if (n2 < (n = " ".length())) {
            return;
        }
        if (stringBuilder.substring(n2 - n, n2).equals(" ")) {
            stringBuilder.replace(n2 - n, n2, "");
        }
    }

    private static final class BoogieStringProvider
    implements IToString<BoogieASTNode> {
        private BoogieStringProvider() {
        }

        public String toString(BoogieASTNode boogieASTNode) {
            if (boogieASTNode instanceof Expression) {
                return BoogiePrettyPrinter.print((Expression)boogieASTNode);
            }
            if (boogieASTNode instanceof Statement) {
                return BoogiePrettyPrinter.print((Statement)boogieASTNode);
            }
            if (boogieASTNode instanceof VarList) {
                return BoogiePrettyPrinter.print((VarList)boogieASTNode);
            }
            if (boogieASTNode instanceof VariableDeclaration) {
                return BoogiePrettyPrinter.print((VariableDeclaration)boogieASTNode);
            }
            if (boogieASTNode instanceof Specification) {
                return BoogiePrettyPrinter.print((Specification)boogieASTNode);
            }
            return ((Object)((Object)boogieASTNode)).toString();
        }
    }
}

