/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IAssumption;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public abstract class AbstractAssumption
implements IAssumption {
    protected final Sort mSort;
    protected final Script mScript;
    protected final PolynomialTermUtils.TriFunction<Script, Sort, Term, Term> mRhsAppender;

    protected abstract Term constructContractedLhs();

    protected abstract Term[] getConjunctsForExplicitForm();

    protected AbstractAssumption(Script script, Sort sort, PolynomialTermUtils.TriFunction<Script, Sort, Term, Term> triFunction) {
        this.mSort = sort;
        this.mScript = script;
        this.mRhsAppender = triFunction;
    }

    @Override
    public Sort getSort() {
        return this.mSort;
    }

    @Override
    public Term toContractedTermIfPossible() {
        if (!this.hasContractedForm()) {
            return this.toExplicitTerm();
        }
        Term term = this.constructContractedLhs();
        return this.mRhsAppender.apply(this.mScript, this.mSort, term);
    }

    @Override
    public Term toExplicitTerm() {
        return SmtUtils.and(this.mScript, this.getConjunctsForExplicitForm());
    }

    public String toString() {
        return this.toExplicitTerm().toString();
    }
}

