/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie.translator;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.IReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.translator.IEpsilonTransformer;
import java.util.Arrays;
import java.util.function.Predicate;

public final class EpsilonTransformer
implements IEpsilonTransformer {
    private final Rational mEpsilon;
    private final Script mScript;
    private final IReqSymbolTable mReqSymboltable;

    public EpsilonTransformer(Script script, Rational rational, IReqSymbolTable iReqSymbolTable) {
        this.mEpsilon = rational;
        this.mScript = script;
        this.mReqSymboltable = iReqSymbolTable;
    }

    @Override
    public Term transformGuard(Term term) {
        return new GenericTransformer(EpsilonTransformer::filterAll, this::subtractEpsilon).transform(term);
    }

    @Override
    public Term transformClockInvariant(Term term) {
        return new GenericTransformer(EpsilonTransformer::filterLt, this::subtractEpsilon).transform(term);
    }

    private Term applyTransform(ApplicationTerm applicationTerm, String string, Term[] termArray, IFunTransform iFunTransform) {
        if (termArray.length != 2) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        assert (EpsilonTransformer.filterAll(string));
        if (termArray[0] instanceof ConstantTerm && termArray[1] instanceof TermVariable) {
            return this.applyTransform(applicationTerm, EpsilonTransformer.dual(string), new Term[]{termArray[1], termArray[0]}, iFunTransform);
        }
        if (termArray[1] instanceof ConstantTerm && termArray[0] instanceof TermVariable) {
            TermVariable termVariable = (TermVariable)termArray[0];
            if (this.mReqSymboltable.getClockVars().contains(termVariable.getName())) {
                return iFunTransform.transform(applicationTerm, string, termArray);
            }
            return null;
        }
        if (Arrays.stream(termArray).anyMatch(term -> this.mReqSymboltable.getClockVars().contains(term.toString()))) {
            throw new UnsupportedOperationException("relation not in normal form: " + String.valueOf(applicationTerm));
        }
        return null;
    }

    private static boolean filterAll(String string) {
        switch (string) {
            case "<": 
            case ">": 
            case "<=": 
            case ">=": {
                return true;
            }
        }
        return false;
    }

    private static boolean filterLt(String string) {
        switch (string) {
            case "<": {
                return true;
            }
        }
        return false;
    }

    private static String dual(String string) {
        switch (string) {
            case "<": {
                return ">";
            }
            case ">=": {
                return "<=";
            }
            case "<=": {
                return ">=";
            }
            case ">": {
                return "<";
            }
        }
        throw new AssertionError();
    }

    private Term changeRelation(ApplicationTerm applicationTerm, String string, Term[] termArray) {
        if (string.equals("<")) {
            return this.mScript.term("<=", termArray);
        }
        if (string.equals(">=")) {
            return this.mScript.term(">", termArray);
        }
        return null;
    }

    private Term subtractEpsilon(ApplicationTerm applicationTerm, String string, Term[] termArray) {
        Term[] termArray2 = new Term[termArray.length];
        termArray2[0] = termArray[0];
        Rational rational = SmtUtils.toRational((ConstantTerm)((ConstantTerm)termArray[1]));
        Rational rational2 = rational.sub(this.mEpsilon);
        termArray2[1] = rational2.toTerm(SmtSortUtils.getRealSort((Script)this.mScript));
        return this.mScript.term(string, termArray2);
    }

    private final class GenericTransformer
    extends TermTransformer {
        private final Predicate<String> mPred;
        private final IFunTransform mFun;

        public GenericTransformer(Predicate<String> predicate, IFunTransform iFunTransform) {
            this.mPred = predicate;
            this.mFun = iFunTransform;
        }

        public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
            Term term;
            String string = applicationTerm.getFunction().getName();
            if (this.mPred.test(string) && (term = EpsilonTransformer.this.applyTransform(applicationTerm, string, termArray, this.mFun)) != null) {
                this.setResult(term);
                return;
            }
            super.convertApplicationTerm(applicationTerm, termArray);
        }
    }

    @FunctionalInterface
    private static interface IFunTransform {
        public Term transform(ApplicationTerm var1, String var2, Term[] var3);
    }
}

