/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import java.util.Objects;

public class StateWithRankInfo<STATE> {
    public static final int NO_RANK = Integer.MIN_VALUE;
    private final STATE mState;
    private final int mRank;
    private final boolean mInO;

    public StateWithRankInfo(STATE STATE, int n, boolean bl) {
        this.mState = STATE;
        if (n < 0) {
            throw new IllegalArgumentException("rank has to be nonnegative");
        }
        this.mRank = n;
        this.mInO = bl;
    }

    public StateWithRankInfo(STATE STATE) {
        this.mState = STATE;
        this.mRank = Integer.MIN_VALUE;
        this.mInO = false;
    }

    public boolean hasRank() {
        return this.mRank != Integer.MIN_VALUE;
    }

    public STATE getState() {
        return this.mState;
    }

    public int getRank() {
        return this.mRank;
    }

    public boolean isInO() {
        return this.mInO;
    }

    public int hashCode() {
        return Objects.hash(this.mInO, this.mRank, this.mState);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StateWithRankInfo stateWithRankInfo = (StateWithRankInfo)object;
        if (this.mInO != stateWithRankInfo.mInO) {
            return false;
        }
        if (this.mRank != stateWithRankInfo.mRank) {
            return false;
        }
        return !(this.mState == null ? stateWithRankInfo.mState != null : !this.mState.equals(stateWithRankInfo.mState));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        stringBuilder.append(this.getState());
        stringBuilder.append(',');
        if (this.hasRank()) {
            stringBuilder.append(this.getRank());
            if (this.isInO()) {
                stringBuilder.append('X');
            }
        } else {
            stringBuilder.append("\u221e");
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

